/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.email;

import java.util.Properties;
import javax.jbi.JBIException;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.email.MimeMailMarshaler;
import org.apache.servicemix.components.util.PollingComponentSupport;

public class MimeMailPoller
extends PollingComponentSupport {
    private static Log log = LogFactory.getLog(MimeMailPoller.class);
    private Session session;
    private String hostName;
    private String userName;
    private String password;
    private String mailBox;
    private boolean debug;
    private int maxFetchSize = 5;
    private MimeMailMarshaler marshaler = new MimeMailMarshaler();

    protected void init() throws JBIException {
        super.init();
        if (this.session == null) {
            log.debug((Object)"No Session informed. Using default instance");
            this.session = Session.getDefaultInstance((Properties)System.getProperties());
        }
        if (this.mailBox == null) {
            log.debug((Object)"No mailbox informed. Using INBOX");
            this.mailBox = "INBOX";
        }
        if (this.hostName == null) {
            throw new JBIException("HostName not informed");
        }
        if (this.userName == null) {
            throw new JBIException("UserName not informed");
        }
        if (this.password == null) {
            throw new JBIException("Password not informed");
        }
        if (this.maxFetchSize < 1) {
            throw new JBIException("Fetch Size must be at least 1");
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public MimeMailMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(MimeMailMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws Exception {
        Store store = null;
        Folder folder = null;
        try {
            this.session.setDebug(this.isDebug());
            store = this.session.getStore(this.mailBox.equals("INBOX") ? "pop3" : "imap");
            store.connect(this.hostName, this.userName, this.password);
            folder = store.getFolder(this.mailBox);
            if (folder == null || !folder.exists()) {
                throw new Exception("Folder not found or invalid: " + this.mailBox);
            }
            folder.open(2);
            int msgCount = Math.min(folder.getMessageCount(), this.maxFetchSize);
            DeliveryChannel channel = this.getDeliveryChannel();
            MessageExchangeFactory mef = this.getExchangeFactory();
            for (int i = 1; i <= msgCount; ++i) {
                MimeMessage mailMsg = (MimeMessage)folder.getMessage(i);
                InOnly io = mef.createInOnlyExchange();
                NormalizedMessage normalizedMessage = io.createMessage();
                this.marshaler.prepareExchange((MessageExchange)io, normalizedMessage, mailMsg);
                io.setInMessage(normalizedMessage);
                channel.send((MessageExchange)io);
                mailMsg.setFlag(Flags.Flag.DELETED, true);
            }
        }
        finally {
            try {
                if (folder != null) {
                    folder.close(true);
                }
                if (store != null) {
                    store.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getMailBox() {
        return this.mailBox;
    }

    public void setMailBox(String mailBox) {
        this.mailBox = mailBox;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public int getMaxFetchSize() {
        return this.maxFetchSize;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }
}

