/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.event.EndpointEvent;
import org.apache.servicemix.jbi.event.EndpointListener;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.framework.Endpoint;
import org.apache.servicemix.jbi.framework.EndpointMBean;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.framework.support.EndpointProcessor;
import org.apache.servicemix.jbi.servicedesc.AbstractServiceEndpoint;
import org.apache.servicemix.jbi.servicedesc.ExternalEndpoint;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;
import org.apache.servicemix.jbi.servicedesc.LinkedEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointRegistry {
    private static final Log LOG = LogFactory.getLog(EndpointRegistry.class);
    private Registry registry;
    private Map<AbstractServiceEndpoint, Endpoint> endpointMBeans;
    private Map<String, ServiceEndpoint> internalEndpoints;
    private Map<String, ServiceEndpoint> externalEndpoints;
    private Map<String, ServiceEndpoint> linkedEndpoints;
    private Map<QName, InterfaceConnection> interfaceConnections;
    private List<EndpointProcessor> endpointProcessors;
    private Executor executor = Executors.newSingleThreadExecutor();

    public EndpointRegistry(Registry registry) {
        this.registry = registry;
        this.endpointMBeans = new ConcurrentHashMap<AbstractServiceEndpoint, Endpoint>();
        this.internalEndpoints = new ConcurrentHashMap<String, ServiceEndpoint>();
        this.externalEndpoints = new ConcurrentHashMap<String, ServiceEndpoint>();
        this.linkedEndpoints = new ConcurrentHashMap<String, ServiceEndpoint>();
        this.interfaceConnections = new ConcurrentHashMap<QName, InterfaceConnection>();
        this.endpointProcessors = this.getEndpointProcessors();
        this.executor.execute(new Runnable(){

            public void run() {
                LOG.debug((Object)"Initializing endpoint event dispatch thread");
            }
        });
    }

    private List<EndpointProcessor> getEndpointProcessors() {
        ArrayList<EndpointProcessor> l = new ArrayList<EndpointProcessor>();
        String[] classes = new String[]{"org.apache.servicemix.jbi.framework.support.SUDescriptorProcessor", "org.apache.servicemix.jbi.framework.support.WSDL1Processor", "org.apache.servicemix.jbi.framework.support.WSDL2Processor"};
        for (int i = 0; i < classes.length; ++i) {
            try {
                EndpointProcessor p = (EndpointProcessor)Class.forName(classes[i]).newInstance();
                p.init(this.registry);
                l.add(p);
                continue;
            }
            catch (Throwable e) {
                LOG.warn((Object)("Disabled endpoint processor '" + classes[i] + "': " + e));
            }
        }
        return l;
    }

    public ServiceEndpoint[] getEndpointsForComponent(ComponentNameSpace cns) {
        ArrayList<ServiceEndpoint> endpoints = new ArrayList<ServiceEndpoint>();
        for (InternalEndpoint internalEndpoint : this.getInternalEndpoints()) {
            if (!cns.equals(internalEndpoint.getComponentNameSpace())) continue;
            endpoints.add(internalEndpoint);
        }
        return this.asEndpointArray(endpoints);
    }

    public ServiceEndpoint[] getAllEndpointsForComponent(ComponentNameSpace cns) {
        ArrayList<ServiceEndpoint> endpoints = new ArrayList<ServiceEndpoint>();
        for (InternalEndpoint internalEndpoint : this.getInternalEndpoints()) {
            if (!cns.equals(internalEndpoint.getComponentNameSpace())) continue;
            endpoints.add(internalEndpoint);
        }
        for (ExternalEndpoint externalEndpoint : this.getExternalEndpoints()) {
            if (!cns.equals(externalEndpoint.getComponentNameSpace())) continue;
            endpoints.add(externalEndpoint);
        }
        return this.asEndpointArray(endpoints);
    }

    public Collection<Endpoint> getEndpointMBeans() {
        return this.endpointMBeans.values();
    }

    public ServiceEndpoint[] getEndpointsForService(QName serviceName) {
        Collection<ServiceEndpoint> collection = this.getEndpointsByService(serviceName, this.getInternalEndpoints());
        return this.asEndpointArray(collection);
    }

    public ServiceEndpoint[] getEndpointsForInterface(QName interfaceName) {
        if (interfaceName == null) {
            return this.asEndpointArray(this.internalEndpoints.values());
        }
        InterfaceConnection conn = this.interfaceConnections.get(interfaceName);
        if (conn != null) {
            String key = this.getKey(conn.service, conn.endpoint);
            ServiceEndpoint ep = this.internalEndpoints.get(key);
            if (ep == null) {
                LOG.warn((Object)("Connection for interface " + interfaceName + " could not find target for service " + conn.service + " and endpoint " + conn.endpoint));
                return new ServiceEndpoint[0];
            }
            return new ServiceEndpoint[]{ep};
        }
        Collection<ServiceEndpoint> result = this.getEndpointsByInterface(interfaceName, this.getInternalEndpoints());
        return this.asEndpointArray(result);
    }

    public InternalEndpoint registerInternalEndpoint(ComponentContextImpl provider, QName serviceName, String endpointName) throws JBIException {
        String key = this.getKey(serviceName, endpointName);
        InternalEndpoint registered = (InternalEndpoint)this.internalEndpoints.get(key);
        if (registered != null && registered.isLocal()) {
            throw new JBIException("An internal endpoint for service " + serviceName + " and endpoint " + endpointName + " is already registered");
        }
        InternalEndpoint serviceEndpoint = new InternalEndpoint(provider.getComponentNameSpace(), endpointName, serviceName);
        if (provider.getActivationSpec().getInterfaceName() != null) {
            serviceEndpoint.addInterface(provider.getActivationSpec().getInterfaceName());
        }
        for (EndpointProcessor p : this.endpointProcessors) {
            p.process(serviceEndpoint);
        }
        if (registered != null) {
            InternalEndpoint[] remote = registered.getRemoteEndpoints();
            for (int i = 0; i < remote.length; ++i) {
                serviceEndpoint.addRemoteEndpoint(remote[i]);
            }
        }
        this.internalEndpoints.put(key, serviceEndpoint);
        this.registerEndpoint(serviceEndpoint);
        this.fireEvent(serviceEndpoint, 0);
        return serviceEndpoint;
    }

    public void unregisterInternalEndpoint(ComponentContext provider, InternalEndpoint serviceEndpoint) {
        if (serviceEndpoint.isClustered()) {
            this.fireEvent(serviceEndpoint, 1);
            serviceEndpoint.setComponentName(null);
        } else {
            String key = this.getKey(serviceEndpoint);
            this.internalEndpoints.remove(key);
            this.unregisterEndpoint(serviceEndpoint);
            this.fireEvent(serviceEndpoint, 1);
        }
    }

    public void registerRemoteEndpoint(InternalEndpoint remote) {
        InternalEndpoint endpoint = (InternalEndpoint)this.internalEndpoints.get(this.getKey(remote));
        if (endpoint == null) {
            endpoint = new InternalEndpoint(null, remote.getEndpointName(), remote.getServiceName());
            this.internalEndpoints.put(this.getKey(endpoint), endpoint);
        }
        endpoint.addRemoteEndpoint(remote);
        this.fireEvent(remote, 6);
    }

    public void unregisterRemoteEndpoint(InternalEndpoint remote) {
        String key = this.getKey(remote);
        InternalEndpoint endpoint = (InternalEndpoint)this.internalEndpoints.get(key);
        if (endpoint != null) {
            endpoint.removeRemoteEndpoint(remote);
            if (!endpoint.isClustered() && !endpoint.isLocal()) {
                this.internalEndpoints.remove(key);
                this.unregisterEndpoint(endpoint);
            }
            this.fireEvent(remote, 7);
        }
    }

    public ServiceEndpoint getEndpoint(QName service, String name) {
        String key = this.getKey(service, name);
        ServiceEndpoint ep = this.linkedEndpoints.get(key);
        if (ep == null) {
            ep = this.internalEndpoints.get(key);
        }
        return ep;
    }

    public ServiceEndpoint getInternalEndpoint(QName service, String name) {
        return this.internalEndpoints.get(this.getKey(service, name));
    }

    public void registerExternalEndpoint(ComponentNameSpace cns, ServiceEndpoint externalEndpoint) throws JBIException {
        ExternalEndpoint serviceEndpoint = new ExternalEndpoint(cns, externalEndpoint);
        if (this.externalEndpoints.get(this.getKey(serviceEndpoint)) != null) {
            throw new JBIException("An external endpoint for service " + externalEndpoint.getServiceName() + " and endpoint " + externalEndpoint.getEndpointName() + " is already registered");
        }
        this.registerEndpoint(serviceEndpoint);
        this.externalEndpoints.put(this.getKey(serviceEndpoint), serviceEndpoint);
        this.fireEvent(serviceEndpoint, 2);
    }

    public void unregisterExternalEndpoint(ComponentNameSpace cns, ServiceEndpoint externalEndpoint) {
        ExternalEndpoint ep = (ExternalEndpoint)this.externalEndpoints.remove(this.getKey(externalEndpoint));
        this.unregisterEndpoint(ep);
        this.fireEvent(ep, 3);
    }

    public ServiceEndpoint[] getExternalEndpointsForInterface(QName interfaceName) {
        Collection<ServiceEndpoint> endpoints = this.getEndpointsByInterface(interfaceName, this.getExternalEndpoints());
        return this.asEndpointArray(endpoints);
    }

    public ServiceEndpoint[] getExternalEndpointsForService(QName serviceName) {
        Collection<ServiceEndpoint> endpoints = this.getEndpointsByService(serviceName, this.getExternalEndpoints());
        return this.asEndpointArray(endpoints);
    }

    protected ServiceEndpoint[] asEndpointArray(Collection<ServiceEndpoint> collection) {
        if (collection == null) {
            return new ServiceEndpoint[0];
        }
        ServiceEndpoint[] answer = new ServiceEndpoint[collection.size()];
        answer = collection.toArray(answer);
        return answer;
    }

    protected Collection<ServiceEndpoint> getEndpointsByService(QName serviceName, Collection<ServiceEndpoint> endpoints) {
        ArrayList<ServiceEndpoint> answer = new ArrayList<ServiceEndpoint>();
        for (ServiceEndpoint endpoint : endpoints) {
            if (!endpoint.getServiceName().equals(serviceName)) continue;
            answer.add(endpoint);
        }
        return answer;
    }

    protected Collection<ServiceEndpoint> getEndpointsByInterface(QName interfaceName, Collection<ServiceEndpoint> endpoints) {
        if (interfaceName == null) {
            return endpoints;
        }
        HashSet<ServiceEndpoint> answer = new HashSet<ServiceEndpoint>();
        block0: for (ServiceEndpoint endpoint : endpoints) {
            QName[] interfaces = endpoint.getInterfaces();
            if (interfaces == null) continue;
            for (int k = 0; k < interfaces.length; ++k) {
                QName qn = interfaces[k];
                if (qn == null || !qn.equals(interfaceName)) continue;
                answer.add(endpoint);
                continue block0;
            }
        }
        return answer;
    }

    protected Collection<ServiceEndpoint> getInternalEndpoints() {
        return this.internalEndpoints.values();
    }

    protected Collection<ServiceEndpoint> getExternalEndpoints() {
        return this.externalEndpoints.values();
    }

    public void registerEndpointConnection(QName fromSvc, String fromEp, QName toSvc, String toEp, String link) throws JBIException {
        LinkedEndpoint ep = new LinkedEndpoint(fromSvc, fromEp, toSvc, toEp, link);
        if (this.linkedEndpoints.get(this.getKey(ep)) != null) {
            throw new JBIException("An endpoint connection for service " + ep.getServiceName() + " and name " + ep.getEndpointName() + " is already registered");
        }
        this.linkedEndpoints.put(this.getKey(ep), ep);
        this.registerEndpoint(ep);
        this.fireEvent(ep, 4);
    }

    public void unregisterEndpointConnection(QName fromSvc, String fromEp) {
        LinkedEndpoint ep = (LinkedEndpoint)this.linkedEndpoints.remove(this.getKey(fromSvc, fromEp));
        this.unregisterEndpoint(ep);
        this.fireEvent(ep, 5);
    }

    public void registerInterfaceConnection(QName fromItf, QName toSvc, String toEp) throws JBIException {
        if (this.interfaceConnections.get(fromItf) != null) {
            throw new JBIException("An interface connection for " + fromItf + " is already registered");
        }
        this.interfaceConnections.put(fromItf, new InterfaceConnection(toSvc, toEp));
    }

    public void unregisterInterfaceConnection(QName fromItf) {
        this.interfaceConnections.remove(fromItf);
    }

    private void registerEndpoint(AbstractServiceEndpoint serviceEndpoint) {
        try {
            Endpoint endpoint = new Endpoint(serviceEndpoint, this.registry);
            ObjectName objectName = this.registry.getContainer().getManagementContext().createObjectName(endpoint);
            this.registry.getContainer().getManagementContext().registerMBean(objectName, endpoint, EndpointMBean.class);
            this.endpointMBeans.put(serviceEndpoint, endpoint);
        }
        catch (JMException e) {
            LOG.error((Object)"Could not register MBean for endpoint", (Throwable)e);
        }
    }

    private void unregisterEndpoint(AbstractServiceEndpoint se) {
        Endpoint ep = this.endpointMBeans.remove(se);
        try {
            this.registry.getContainer().getManagementContext().unregisterMBean(ep);
        }
        catch (JBIException e) {
            LOG.error((Object)"Could not unregister MBean for endpoint", (Throwable)e);
        }
    }

    private String getKey(ServiceEndpoint ep) {
        return this.getKey(ep.getServiceName(), ep.getEndpointName());
    }

    private String getKey(QName svcName, String epName) {
        return svcName + epName;
    }

    protected synchronized void fireEvent(final ServiceEndpoint ep, final int type) {
        this.executor.execute(new Runnable(){

            public void run() {
                EndpointEvent event = new EndpointEvent(ep, type);
                EndpointListener[] listeners = (EndpointListener[])EndpointRegistry.this.registry.getContainer().getListeners(EndpointListener.class);
                block10: for (int i = 0; i < listeners.length; ++i) {
                    switch (type) {
                        case 0: {
                            listeners[i].internalEndpointRegistered(event);
                            continue block10;
                        }
                        case 1: {
                            listeners[i].internalEndpointUnregistered(event);
                            continue block10;
                        }
                        case 2: {
                            listeners[i].externalEndpointRegistered(event);
                            continue block10;
                        }
                        case 3: {
                            listeners[i].externalEndpointUnregistered(event);
                            continue block10;
                        }
                        case 4: {
                            listeners[i].linkedEndpointRegistered(event);
                            continue block10;
                        }
                        case 5: {
                            listeners[i].linkedEndpointUnregistered(event);
                            continue block10;
                        }
                        case 6: {
                            listeners[i].remoteEndpointRegistered(event);
                            continue block10;
                        }
                        case 7: {
                            listeners[i].remoteEndpointUnregistered(event);
                            continue block10;
                        }
                    }
                }
            }
        });
    }

    private static class InterfaceConnection {
        QName service;
        String endpoint;

        InterfaceConnection(QName service, String endpoint) {
            this.service = service;
            this.endpoint = endpoint;
        }
    }
}

