/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.jmx;

import java.lang.reflect.Method;
import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jmx.Policy;
import org.apache.servicemix.jbi.security.GroupPrincipal;

public class AdminReadWritePolicy
extends Policy {
    private static final Log LOG = LogFactory.getLog(AdminReadWritePolicy.class);
    private static final String INVOKE = "invoke";

    public void checkAuthorization(Subject subject, Object target, Method method, Object[] args) throws SecurityException {
        if (!(this.isReadOnly(method) || this.isAdmin(subject) || this.isInvokeReadOnly(method, args))) {
            LOG.warn((Object)String.format("Denied access to MBeanServer.%s(%s) to %s", method.getName(), this.explode(args), subject));
            throw new SecurityException("Not authorized to run MBeanServer." + method.getName() + "\n(" + this.explode(args) + ")");
        }
    }

    private boolean isInvokeReadOnly(Method method, Object[] args) {
        return INVOKE.equals(method.getName()) && args != null && args.length >= 2 && this.isReadOnly((String)args[1]);
    }

    private String explode(Object[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Object last = args[args.length - 1];
        for (Object arg : args) {
            buffer.append(arg);
            if (arg == last) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    private boolean isAdmin(Subject subject) {
        for (Principal principal : subject.getPrincipals()) {
            if (!(principal instanceof GroupPrincipal) || !"admin".equals(principal.getName())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "admin group read-write access";
    }
}

