/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.jmx;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jmx.Policy;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.jmx.support.JmxUtils;

public class ConnectorServerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    public static final int REGISTRATION_FAIL_ON_EXISTING = 0;
    public static final int REGISTRATION_IGNORE_EXISTING = 1;
    public static final int REGISTRATION_REPLACE_EXISTING = 2;
    private static final Constants CONSTANTS = new Constants(ConnectorServerFactoryBean.class);
    private Log log = LogFactory.getLog(ConnectorServerFactoryBean.class);
    private org.springframework.jmx.support.ConnectorServerFactoryBean csfb = new org.springframework.jmx.support.ConnectorServerFactoryBean();
    private String serviceUrl = "service:jmx:jmxmp://localhost:9875";
    private boolean daemon;
    private boolean threaded;
    private Map environment;
    private Object objectName;
    private int registrationBehavior = 0;
    private MBeanServer server;
    private Policy policy;

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setEnvironment(Map environment) {
        this.environment = environment;
    }

    public void setObjectName(String objectName) throws MalformedObjectNameException {
        this.objectName = objectName;
    }

    public void setRegistrationBehavior(int registrationBehavior) {
        this.registrationBehavior = registrationBehavior;
    }

    public void setRegistrationBehaviorName(String behavior) {
        this.setRegistrationBehavior(CONSTANTS.asNumber(behavior).intValue());
    }

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setThreaded(boolean threaded) {
        this.csfb.setThreaded(threaded);
    }

    public Object getObject() throws Exception {
        return this.csfb.getObject();
    }

    public Class getObjectType() {
        return this.csfb.getObjectType();
    }

    public boolean isSingleton() {
        return this.csfb.isSingleton();
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public void afterPropertiesSet() throws Exception {
        this.csfb = new org.springframework.jmx.support.ConnectorServerFactoryBean();
        this.csfb.setDaemon(this.daemon);
        this.csfb.setThreaded(this.threaded);
        this.csfb.setRegistrationBehavior(this.registrationBehavior);
        this.csfb.setEnvironmentMap(this.environment);
        this.csfb.setObjectName(this.objectName);
        this.serviceUrl = this.serviceUrl.replaceAll(" ", "");
        this.csfb.setServiceUrl(this.serviceUrl);
        MBeanServer mbs = this.server;
        if (this.policy != null) {
            this.log.info((Object)("Configuring JMX authorization policy: " + this.policy));
            mbs = mbs == null ? this.createProxyForPolicy(JmxUtils.locateMBeanServer()) : this.createProxyForPolicy(mbs);
        }
        this.csfb.setServer(mbs);
        this.csfb.afterPropertiesSet();
        this.log.info((Object)("JMX connector available at: " + this.serviceUrl));
    }

    private MBeanServer createProxyForPolicy(MBeanServer mbs) {
        PolicyAwareInvocationHandler handler = new PolicyAwareInvocationHandler(this.policy, mbs);
        Object proxy = Proxy.newProxyInstance(MBeanServer.class.getClassLoader(), new Class[]{MBeanServer.class}, (InvocationHandler)handler);
        return (MBeanServer)MBeanServer.class.cast(proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        if (this.csfb != null) {
            try {
                this.csfb.destroy();
            }
            finally {
                this.csfb = null;
            }
        }
    }

    public static class PolicyAwareInvocationHandler
    implements InvocationHandler {
        private final Policy policy;
        private final MBeanServer mbs;

        public PolicyAwareInvocationHandler(Policy policy, MBeanServer mbs) {
            this.policy = policy;
            this.mbs = mbs;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject == null) {
                return method.invoke((Object)this.mbs, args);
            }
            this.policy.checkAuthorization(subject, this.mbs, method, args);
            return method.invoke((Object)this.mbs, args);
        }
    }
}

