/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.logging;

import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.jbi.JBIException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.log4j.Logger;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.logging.LogServiceMBean;
import org.apache.servicemix.jbi.logging.LogTask;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.springframework.beans.factory.InitializingBean;

public class LogService
extends BaseSystemService
implements InitializingBean,
LogServiceMBean {
    private static final String DEFAULT_LOG_FILE_NAME = "log4j.xml";
    private static final Logger LOG = Logger.getLogger(LogService.class);
    private boolean autoStart = true;
    private boolean initialized;
    private int refreshPeriod = 60;
    private URL configFileUrl;
    private String configUrl = "file:conf/log4j.xml";
    private LogTask logTask;
    private Timer timer;

    public void afterPropertiesSet() throws Exception {
        if (this.container == null) {
            throw new IllegalArgumentException("container should not be null");
        }
        this.init(this.getContainer());
        if (this.autoStart) {
            this.start();
        }
    }

    public JBIContainer getContainer() {
        return this.container;
    }

    public void setContainer(JBIContainer container) {
        this.container = container;
    }

    public String getDescription() {
        return "Log4j Service which periodicaly scan the config file";
    }

    public void setRefreshPeriod(int seconds) {
        this.refreshPeriod = seconds;
        try {
            if (this.isStarted()) {
                this.stop();
                this.start();
            }
        }
        catch (JBIException ex) {
            LOG.error((Object)"Error occured!", (Throwable)ex);
        }
    }

    public int getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public void setConfigUrl(String url) {
        this.configUrl = url;
        try {
            if (this.isStarted()) {
                this.stop();
                this.start();
            }
        }
        catch (JBIException ex) {
            LOG.error((Object)"Error occured!", (Throwable)ex);
        }
    }

    public String getConfigUrl() {
        return this.configUrl;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public void reconfigureLogSystem() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"try to reconfigure the log4j system");
        }
        if (this.logTask != null) {
            this.logTask.reconfigure();
        }
    }

    protected Class getServiceMBean() {
        return LogServiceMBean.class;
    }

    public void start() throws JBIException {
        this.setUp();
        super.start();
    }

    public void stop() throws JBIException {
        if (this.logTask != null) {
            this.logTask.cancel();
            this.logTask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.initialized = false;
        super.stop();
    }

    public void setUp() throws JBIException {
        if (!this.initialized) {
            this.configFileUrl = this.locateLoggingConfig();
            if (this.configFileUrl != null) {
                this.timer = new Timer(true);
                this.logTask = new LogTask(this.configFileUrl);
                this.logTask.run();
                this.timer.schedule((TimerTask)this.logTask, 1000 * this.refreshPeriod, (long)(1000 * this.refreshPeriod));
                this.initialized = true;
            }
        }
    }

    private URL locateLoggingConfig() {
        URL log4jConfigUrl = ClassLoader.getSystemResource(DEFAULT_LOG_FILE_NAME);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Located logging configuration: " + log4jConfigUrl.toString()));
        }
        return log4jConfigUrl;
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "reconfigureLogSystem", 0, "Reconfigure the log4j system");
        return OperationInfoHelper.join(super.getOperationInfos(), helper.getOperationInfos());
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "configUrl", "the url for the log4j.xml config file");
        helper.addAttribute(this.getObjectToManage(), "refreshPeriod", "schedule time for scanning the log4j config file");
        return AttributeInfoHelper.join(super.getAttributeInfos(), helper.getAttributeInfos());
    }
}

