/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.messaging;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.messaging.InOnlyImpl;
import org.apache.servicemix.jbi.messaging.InOptionalOutImpl;
import org.apache.servicemix.jbi.messaging.InOutImpl;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.messaging.MessageExchangeSupport;
import org.apache.servicemix.jbi.messaging.PojoMarshaler;
import org.apache.servicemix.jbi.messaging.RobustInOnlyImpl;

public class MessageExchangeFactoryImpl
implements MessageExchangeFactory {
    private QName interfaceName;
    private QName serviceName;
    private QName operationName;
    private ServiceEndpoint endpoint;
    private IdGenerator idGenerator;
    private ComponentContextImpl context;
    private AtomicBoolean closed;

    public MessageExchangeFactoryImpl(IdGenerator idGen, AtomicBoolean closed) {
        this.idGenerator = idGen;
        this.closed = closed;
    }

    protected void checkNotClosed() throws MessagingException {
        if (this.closed.get()) {
            throw new MessagingException("DeliveryChannel has been closed.");
        }
    }

    public MessageExchange createExchange(URI pattern) throws MessagingException {
        this.checkNotClosed();
        InOnly result = null;
        if (pattern != null) {
            if (pattern.equals(MessageExchangeSupport.IN_ONLY) || pattern.equals(MessageExchangeSupport.WSDL2_IN_ONLY)) {
                result = this.createInOnlyExchange();
            } else if (pattern.equals(MessageExchangeSupport.IN_OUT) || pattern.equals(MessageExchangeSupport.WSDL2_IN_OUT)) {
                result = this.createInOutExchange();
            } else if (pattern.equals(MessageExchangeSupport.IN_OPTIONAL_OUT) || pattern.equals(MessageExchangeSupport.WSDL2_IN_OPTIONAL_OUT)) {
                result = this.createInOptionalOutExchange();
            } else if (pattern.equals(MessageExchangeSupport.ROBUST_IN_ONLY) || pattern.equals(MessageExchangeSupport.WSDL2_ROBUST_IN_ONLY)) {
                result = this.createRobustInOnlyExchange();
            }
        }
        if (result == null) {
            throw new MessagingException("Do not understand pattern: " + pattern);
        }
        return result;
    }

    public InOnly createInOnlyExchange() throws MessagingException {
        this.checkNotClosed();
        InOnlyImpl result = new InOnlyImpl(this.getExchangeId());
        this.setDefaults(result);
        return result;
    }

    public RobustInOnly createRobustInOnlyExchange() throws MessagingException {
        this.checkNotClosed();
        RobustInOnlyImpl result = new RobustInOnlyImpl(this.getExchangeId());
        this.setDefaults(result);
        return result;
    }

    public InOut createInOutExchange() throws MessagingException {
        this.checkNotClosed();
        InOutImpl result = new InOutImpl(this.getExchangeId());
        this.setDefaults(result);
        return result;
    }

    public InOptionalOut createInOptionalOutExchange() throws MessagingException {
        this.checkNotClosed();
        InOptionalOutImpl result = new InOptionalOutImpl(this.getExchangeId());
        this.setDefaults(result);
        return result;
    }

    public MessageExchange createExchange(QName svcName, QName opName) throws MessagingException {
        this.checkNotClosed();
        InOptionalOutImpl me = new InOptionalOutImpl(this.getExchangeId());
        this.setDefaults(me);
        me.setService(svcName);
        me.setOperation(opName);
        return me;
    }

    protected String getExchangeId() {
        return this.idGenerator.generateId();
    }

    public ServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(ServiceEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName operationName) {
        this.operationName = operationName;
    }

    public ComponentContextImpl getContext() {
        return this.context;
    }

    public void setContext(ComponentContextImpl context) {
        this.context = context;
    }

    protected void setDefaults(MessageExchangeImpl exchange) {
        exchange.setOperation(this.getOperationName());
        if (this.endpoint != null) {
            exchange.setEndpoint(this.getEndpoint());
        } else {
            exchange.setService(this.serviceName);
            exchange.setInterfaceName(this.interfaceName);
        }
        if (this.getContext() != null) {
            exchange.setSourceContext(this.getContext());
            PojoMarshaler marshaler = this.getContext().getActivationSpec().getMarshaler();
            if (marshaler != null) {
                exchange.setMarshaler(marshaler);
            }
        }
        exchange.setProperty("org.apache.servicemix.datestamp", new PrettyCalendar());
    }

    public static class PrettyCalendar
    extends GregorianCalendar {
        public String toString() {
            return new SimpleDateFormat().format(this.getTime());
        }
    }
}

