/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.xbean;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.xbean.classloader.JarFileClassLoader;
import org.apache.xbean.spring.context.SpringApplicationContext;
import org.apache.xbean.spring.context.SpringXmlPreprocessor;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderXmlPreprocessor
implements SpringXmlPreprocessor {
    public static final String CLASSPATH_XML = "classpath.xml";
    public static final String LIB_DIR = "/lib";
    private final File root;

    public ClassLoaderXmlPreprocessor(File root) {
        this.root = root;
    }

    public void preprocess(SpringApplicationContext applicationContext, XmlBeanDefinitionReader reader, Document document) {
        ClassLoader classLoader;
        NodeList classpathElements = document.getDocumentElement().getElementsByTagName("classpath");
        if (classpathElements.getLength() == 0) {
            URL url = this.getResource(CLASSPATH_XML);
            if (url != null) {
                try {
                    DocumentBuilder builder = new SourceTransformer().createDocumentBuilder();
                    Document doc = builder.parse(url.toString());
                    classLoader = this.getClassLoader(applicationContext, reader, doc);
                }
                catch (Exception e) {
                    throw new FatalBeanException("Unable to load classpath.xml file", (Throwable)e);
                }
            } else {
                try {
                    URL[] urls = this.getDefaultLocations();
                    ClassLoader parentLoader = this.getParentClassLoader(applicationContext);
                    classLoader = new JarFileClassLoader(applicationContext.getDisplayName(), urls, parentLoader);
                }
                catch (Exception e) {
                    throw new FatalBeanException("Unable to create default classloader for SU", (Throwable)e);
                }
            }
        } else {
            classLoader = this.getClassLoader(applicationContext, reader, document);
        }
        reader.setBeanClassLoader(classLoader);
        applicationContext.setClassLoader(classLoader);
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private static String replaceString(String text, String searchString, String replacement, int max) {
        if (text == null || text.length() == 0 || searchString == null || searchString.length() == 0 || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuffer buffer = new StringBuffer(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buffer.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buffer.append(text.substring(start));
        return buffer.toString();
    }

    protected URL getResource(String location) {
        URI uri = this.root.toURI().resolve(location);
        File file = new File(uri);
        if (!file.canRead()) {
            return null;
        }
        try {
            return file.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed resource " + uri);
        }
    }

    protected List<URL> getResources(String location) {
        Properties systemProperties = System.getProperties();
        for (String string : systemProperties.keySet()) {
            String value = systemProperties.getProperty(string);
            location = ClassLoaderXmlPreprocessor.replaceString(location, "${" + string + "}", value, -1);
        }
        if (location.startsWith("jar:")) {
            return this.getJarResources(location);
        }
        if (location.startsWith("file:")) {
            return this.getFileResources(location);
        }
        LinkedList<URL> urls = new LinkedList<URL>();
        URI uRI = this.root.toURI().resolve(location);
        File file = new File(uRI);
        if (file.canRead()) {
            try {
                urls.add(file.toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Malformed resource location " + uRI);
            }
        }
        return urls;
    }

    protected List<URL> getJarResources(String location) {
        JarInputStream jarInputStream;
        LinkedList<URL> urls = new LinkedList<URL>();
        int separatorIndex = location.indexOf("!/");
        if (separatorIndex == -1) {
            throw new IllegalArgumentException("The jar URL " + location + " is not valid. !/ separator not found.");
        }
        String jarLocation = location.substring(4, separatorIndex);
        System.out.println("jarLocation: " + jarLocation);
        String entryLocation = location.substring(separatorIndex + 2);
        System.out.println("entryLocation: " + entryLocation);
        if (jarLocation == null || jarLocation.trim().length() < 1 || entryLocation == null || entryLocation.trim().length() < 1) {
            throw new IllegalArgumentException("The jar URL " + location + " is not valid. Jar URL or entry not found.");
        }
        try {
            jarInputStream = new JarInputStream(new URL(jarLocation).openStream());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The jar URL is not valid " + jarLocation + ".", e);
        }
        try {
            ZipEntry entry = jarInputStream.getNextEntry();
            while (entry != null) {
                if (entry.getName().matches(entryLocation)) {
                    String entryUrl = "jar:" + jarLocation + "!/" + entry.getName();
                    urls.add(new URL(entryUrl));
                }
                entry = jarInputStream.getNextEntry();
            }
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException("Can't read jar entries", ioException);
        }
        return urls;
    }

    protected List<URL> getFileResources(String location) {
        LinkedList<URL> urls = new LinkedList<URL>();
        int starIndex = location.indexOf("*");
        if (starIndex == -1) {
            try {
                urls.add(new URL(location));
            }
            catch (MalformedURLException urlException) {
                throw new IllegalArgumentException("Invalid URL " + location);
            }
        } else {
            int lastSeparatorIndex = location.lastIndexOf("/");
            if (starIndex < lastSeparatorIndex) {
                throw new IllegalArgumentException("Regexp is supported only on files name, not on directories.");
            }
            String dirPath = location.substring(0, lastSeparatorIndex);
            File dir = new File(dirPath);
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("The regexp basedir is not a directory.");
            }
            File[] entries = dir.listFiles();
            String fileNameRegexp = location.substring(lastSeparatorIndex);
            for (int i = 0; i < entries.length; ++i) {
                File entry = entries[i];
                if (!entry.getName().matches(fileNameRegexp)) continue;
                try {
                    urls.add(new URL(dirPath + "/" + entry.getName()));
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid URL " + dirPath + "/" + entry.getName(), e);
                }
            }
        }
        return urls;
    }

    protected URL[] getDefaultLocations() {
        try {
            File[] jars = new File(this.root, LIB_DIR).listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return (name = name.toLowerCase()).endsWith(".jar") || name.endsWith(".zip");
                }
            });
            URL[] urls = new URL[jars != null ? jars.length + 1 : 1];
            urls[0] = this.root.toURL();
            if (jars != null) {
                for (int i = 0; i < jars.length; ++i) {
                    urls[i + 1] = jars[i].toURL();
                }
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new FatalBeanException("Unable to get default classpath locations", (Throwable)e);
        }
    }

    protected ClassLoader getClassLoader(SpringApplicationContext applicationContext, XmlBeanDefinitionReader reader, Document document) {
        ClassLoader classLoader;
        NodeList classpathElements = document.getDocumentElement().getElementsByTagName("classpath");
        if (classpathElements.getLength() < 1) {
            classLoader = this.getParentClassLoader(applicationContext);
        } else {
            URL[] urls;
            URL url;
            if (classpathElements.getLength() > 1) {
                throw new FatalBeanException("Expected only classpath element but found " + classpathElements.getLength());
            }
            Element classpathElement = (Element)classpathElements.item(0);
            String fileDelegation = classpathElement.getAttribute("file");
            if (fileDelegation != null && (url = this.getResource(fileDelegation)) != null) {
                try {
                    DocumentBuilder builder = new SourceTransformer().createDocumentBuilder();
                    Document doc = builder.parse(url.toString());
                    ClassLoader classLoader2 = this.getClassLoader(applicationContext, reader, doc);
                    return classLoader2;
                }
                catch (Exception e) {
                    throw new FatalBeanException("Unable to load " + url + " file.", (Throwable)e);
                }
            }
            boolean inverse = false;
            String inverseAttr = classpathElement.getAttribute("inverse");
            if (inverseAttr != null && "true".equalsIgnoreCase(inverseAttr)) {
                inverse = true;
            }
            ArrayList<String> hidden = new ArrayList<String>();
            NodeList hiddenElems = classpathElement.getElementsByTagName("hidden");
            for (int i = 0; i < hiddenElems.getLength(); ++i) {
                Element hiddenElement = (Element)hiddenElems.item(i);
                String pattern = ((Text)hiddenElement.getFirstChild()).getData().trim();
                hidden.add(pattern);
            }
            ArrayList<String> nonOverridable = new ArrayList<String>();
            NodeList nonOverridableElems = classpathElement.getElementsByTagName("nonOverridable");
            for (int i = 0; i < nonOverridableElems.getLength(); ++i) {
                Element nonOverridableElement = (Element)nonOverridableElems.item(i);
                String pattern = ((Text)nonOverridableElement.getFirstChild()).getData().trim();
                nonOverridable.add(pattern);
            }
            ArrayList<String> classpath = new ArrayList<String>();
            NodeList locations = classpathElement.getElementsByTagName("location");
            for (int i = 0; i < locations.getLength(); ++i) {
                Element locationElement = (Element)locations.item(i);
                String location = ((Text)locationElement.getFirstChild()).getData().trim();
                classpath.add(location);
            }
            if (classpath.size() != 0) {
                LinkedList<URL> urlsList = new LinkedList<URL>();
                ListIterator iterator = classpath.listIterator();
                while (iterator.hasNext()) {
                    String location = (String)iterator.next();
                    List<URL> locationUrls = this.getResources(location);
                    for (URL url2 : locationUrls) {
                        urlsList.add(url2);
                    }
                }
                urls = urlsList.toArray(new URL[urlsList.size()]);
            } else {
                urls = this.getDefaultLocations();
            }
            ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>();
            parents.add(this.getParentClassLoader(applicationContext));
            classLoader = new JarFileClassLoader(applicationContext.getDisplayName(), urls, parents.toArray(new ClassLoader[parents.size()]), inverse, hidden.toArray(new String[hidden.size()]), nonOverridable.toArray(new String[nonOverridable.size()]));
            document.getDocumentElement().removeChild(classpathElement);
        }
        return classLoader;
    }

    private ClassLoader getParentClassLoader(SpringApplicationContext applicationContext) {
        ClassLoader classLoader = applicationContext.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }
}

