/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.plist;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.activemq.store.kahadb.plist.EntryLocation;
import org.apache.activemq.store.kahadb.plist.PList;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kahadb.index.BTreeIndex;
import org.apache.kahadb.journal.Journal;
import org.apache.kahadb.journal.Location;
import org.apache.kahadb.page.Page;
import org.apache.kahadb.page.PageFile;
import org.apache.kahadb.page.Transaction;
import org.apache.kahadb.util.ByteSequence;
import org.apache.kahadb.util.IntegerMarshaller;
import org.apache.kahadb.util.LockFile;
import org.apache.kahadb.util.Marshaller;
import org.apache.kahadb.util.StringMarshaller;
import org.apache.kahadb.util.VariableMarshaller;

public class PListStore
extends ServiceSupport {
    static final Log LOG = LogFactory.getLog(PListStore.class);
    private static final int DATABASE_LOCKED_WAIT_DELAY = 10000;
    static final int CLOSED_STATE = 1;
    static final int OPEN_STATE = 2;
    private File directory;
    PageFile pageFile;
    private Journal journal;
    private LockFile lockFile;
    private boolean failIfDatabaseIsLocked;
    private int journalMaxFileLength = 0x2000000;
    private int journalMaxWriteBatchSize = 0x400000;
    private boolean enableIndexWriteAsync = false;
    private boolean initialized = false;
    MetaData metaData = new MetaData(this);
    final MetaDataMarshaller metaDataMarshaller = new MetaDataMarshaller(this);
    Map<String, PList> persistentLists = new HashMap<String, PList>();

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        PListStore pListStore = this;
        synchronized (pListStore) {
            if (!this.initialized) {
                return 0L;
            }
        }
        try {
            return this.journal.getDiskSize() + this.pageFile.getDiskSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PList getPList(final String name) throws Exception {
        if (!this.isStarted()) {
            throw new IllegalStateException("Not started");
        }
        this.intialize();
        PList result = this.persistentLists.get(name);
        if (result == null) {
            final PList pl = new PList(this);
            pl.setName(name);
            this.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    pl.setRootId(tx.allocate().getPageId());
                    pl.load(tx);
                    PListStore.this.metaData.storedSchedulers.put(tx, (Object)name, (Object)pl);
                }
            });
            result = pl;
            this.persistentLists.put(name, pl);
        }
        final PList load = result;
        this.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

            public void execute(Transaction tx) throws IOException {
                load.load(tx);
            }
        });
        return result;
    }

    public synchronized boolean removePList(final String name) throws Exception {
        boolean result = false;
        final PList pl = this.persistentLists.remove(name);
        boolean bl = result = pl != null;
        if (result) {
            this.getPageFile().tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    PListStore.this.metaData.storedSchedulers.remove(tx, (Object)name);
                    pl.destroy(tx);
                }
            });
        }
        return result;
    }

    protected synchronized void intialize() throws Exception {
        if (this.isStarted() && !this.initialized) {
            this.initialized = true;
            if (this.directory == null) {
                this.directory = new File(IOHelper.getDefaultDataDirectory() + File.pathSeparator + "delayedDB");
            }
            IOHelper.mkdirs(this.directory);
            this.lock();
            this.journal = new Journal();
            this.journal.setDirectory(this.directory);
            this.journal.setMaxFileLength(this.getJournalMaxFileLength());
            this.journal.setWriteBatchSize(this.getJournalMaxWriteBatchSize());
            this.journal.start();
            this.pageFile = new PageFile(this.directory, "tmpDB");
            this.pageFile.load();
            this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    if (PListStore.this.pageFile.getPageCount() == 0L) {
                        Page page = tx.allocate();
                        assert (page.getPageId() == 0L);
                        page.set((Object)PListStore.this.metaData);
                        PListStore.this.metaData.page = page;
                        PListStore.this.metaData.createIndexes(tx);
                        tx.store(PListStore.this.metaData.page, (Marshaller)PListStore.this.metaDataMarshaller, true);
                    } else {
                        Page page = tx.load(0L, (Marshaller)PListStore.this.metaDataMarshaller);
                        PListStore.this.metaData = (MetaData)page.get();
                        PListStore.this.metaData.page = page;
                    }
                    PListStore.this.metaData.load(tx);
                    PListStore.this.metaData.loadLists(tx, PListStore.this.persistentLists);
                }
            });
            this.pageFile.flush();
            LOG.info((Object)(this + " initialized"));
        }
    }

    protected synchronized void doStart() throws Exception {
        LOG.info((Object)(this + " started"));
    }

    protected synchronized void doStop(ServiceStopper stopper) throws Exception {
        for (PList pl : this.persistentLists.values()) {
            pl.unload();
        }
        if (this.pageFile != null) {
            this.pageFile.unload();
        }
        if (this.journal != null) {
            this.journal.close();
        }
        if (this.lockFile != null) {
            this.lockFile.unlock();
        }
        this.lockFile = null;
        this.initialized = false;
        LOG.info((Object)(this + " stopped"));
    }

    synchronized void incrementJournalCount(Transaction tx, Location location) throws IOException {
        int logId = location.getDataFileId();
        Integer val = (Integer)this.metaData.journalRC.get(tx, (Object)logId);
        int refCount = val != null ? val + 1 : 1;
        this.metaData.journalRC.put(tx, (Object)logId, (Object)refCount);
    }

    synchronized void decrementJournalCount(Transaction tx, Location location) throws IOException {
        int logId = location.getDataFileId();
        if (logId != -1) {
            int refCount = (Integer)this.metaData.journalRC.get(tx, (Object)logId);
            if (--refCount <= 0) {
                this.metaData.journalRC.remove(tx, (Object)logId);
                HashSet<Integer> set = new HashSet<Integer>();
                set.add(logId);
                this.journal.removeDataFiles(set);
            } else {
                this.metaData.journalRC.put(tx, (Object)logId, (Object)refCount);
            }
        }
    }

    synchronized ByteSequence getPayload(Location location) throws IllegalStateException, IOException {
        ByteSequence result = null;
        result = this.journal.read(location);
        return result;
    }

    synchronized Location write(ByteSequence payload, boolean sync) throws IllegalStateException, IOException {
        return this.journal.write(payload, sync);
    }

    private void lock() throws IOException {
        if (this.lockFile == null) {
            File lockFileName = new File(this.directory, "lock");
            this.lockFile = new LockFile(lockFileName, true);
            if (this.failIfDatabaseIsLocked) {
                this.lockFile.lock();
            } else {
                while (true) {
                    try {
                        this.lockFile.lock();
                    }
                    catch (IOException e) {
                        LOG.info((Object)("Database " + lockFileName + " is locked... waiting " + 10 + " seconds for the database to be unlocked. Reason: " + e));
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
        }
    }

    PageFile getPageFile() {
        this.pageFile.isLoaded();
        return this.pageFile;
    }

    public boolean isFailIfDatabaseIsLocked() {
        return this.failIfDatabaseIsLocked;
    }

    public void setFailIfDatabaseIsLocked(boolean failIfDatabaseIsLocked) {
        this.failIfDatabaseIsLocked = failIfDatabaseIsLocked;
    }

    public int getJournalMaxFileLength() {
        return this.journalMaxFileLength;
    }

    public void setJournalMaxFileLength(int journalMaxFileLength) {
        this.journalMaxFileLength = journalMaxFileLength;
    }

    public int getJournalMaxWriteBatchSize() {
        return this.journalMaxWriteBatchSize;
    }

    public void setJournalMaxWriteBatchSize(int journalMaxWriteBatchSize) {
        this.journalMaxWriteBatchSize = journalMaxWriteBatchSize;
    }

    public boolean isEnableIndexWriteAsync() {
        return this.enableIndexWriteAsync;
    }

    public void setEnableIndexWriteAsync(boolean enableIndexWriteAsync) {
        this.enableIndexWriteAsync = enableIndexWriteAsync;
    }

    public String toString() {
        return "PListStore:" + this.directory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JobSchedulerMarshaller
    extends VariableMarshaller<PList> {
        private final PListStore store;

        JobSchedulerMarshaller(PListStore store) {
            this.store = store;
        }

        public PList readPayload(DataInput dataIn) throws IOException {
            PList result = new PList(this.store);
            result.read(dataIn);
            return result;
        }

        public void writePayload(PList js, DataOutput dataOut) throws IOException {
            js.write(dataOut);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueMarshaller
    extends VariableMarshaller<List<EntryLocation>> {
        ValueMarshaller() {
        }

        public List<EntryLocation> readPayload(DataInput dataIn) throws IOException {
            ArrayList<EntryLocation> result = new ArrayList<EntryLocation>();
            int size = dataIn.readInt();
            for (int i = 0; i < size; ++i) {
                EntryLocation jobLocation = new EntryLocation();
                jobLocation.readExternal(dataIn);
                result.add(jobLocation);
            }
            return result;
        }

        public void writePayload(List<EntryLocation> value, DataOutput dataOut) throws IOException {
            dataOut.writeInt(value.size());
            for (EntryLocation jobLocation : value) {
                jobLocation.writeExternal(dataOut);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MetaDataMarshaller
    extends VariableMarshaller<MetaData> {
        private final PListStore store;

        MetaDataMarshaller(PListStore store) {
            this.store = store;
        }

        public MetaData readPayload(DataInput dataIn) throws IOException {
            MetaData rc = new MetaData(this.store);
            rc.read(dataIn);
            return rc;
        }

        public void writePayload(MetaData object, DataOutput dataOut) throws IOException {
            object.write(dataOut);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MetaData {
        private final PListStore store;
        Page<MetaData> page;
        BTreeIndex<Integer, Integer> journalRC;
        BTreeIndex<String, PList> storedSchedulers;

        protected MetaData(PListStore store) {
            this.store = store;
        }

        void createIndexes(Transaction tx) throws IOException {
            this.storedSchedulers = new BTreeIndex(PListStore.this.pageFile, tx.allocate().getPageId());
            this.journalRC = new BTreeIndex(PListStore.this.pageFile, tx.allocate().getPageId());
        }

        void load(Transaction tx) throws IOException {
            this.storedSchedulers.setKeyMarshaller((Marshaller)StringMarshaller.INSTANCE);
            this.storedSchedulers.setValueMarshaller((Marshaller)new JobSchedulerMarshaller(this.store));
            this.storedSchedulers.load(tx);
            this.journalRC.setKeyMarshaller((Marshaller)IntegerMarshaller.INSTANCE);
            this.journalRC.setValueMarshaller((Marshaller)IntegerMarshaller.INSTANCE);
            this.journalRC.load(tx);
        }

        void loadLists(Transaction tx, Map<String, PList> schedulers) throws IOException {
            Iterator i = this.storedSchedulers.iterator(tx);
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                ((PList)entry.getValue()).load(tx);
                schedulers.put((String)entry.getKey(), (PList)entry.getValue());
            }
        }

        public void read(DataInput is) throws IOException {
            this.storedSchedulers = new BTreeIndex(PListStore.this.pageFile, is.readLong());
            this.storedSchedulers.setKeyMarshaller((Marshaller)StringMarshaller.INSTANCE);
            this.storedSchedulers.setValueMarshaller((Marshaller)new JobSchedulerMarshaller(this.store));
            this.journalRC = new BTreeIndex(PListStore.this.pageFile, is.readLong());
            this.journalRC.setKeyMarshaller((Marshaller)IntegerMarshaller.INSTANCE);
            this.journalRC.setValueMarshaller((Marshaller)IntegerMarshaller.INSTANCE);
        }

        public void write(DataOutput os) throws IOException {
            os.writeLong(this.storedSchedulers.getPageId());
            os.writeLong(this.journalRC.getPageId());
        }
    }
}

