/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.client;

import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.client.DefaultDestination;
import org.apache.servicemix.client.Destination;
import org.apache.servicemix.client.ServiceMixClient;
import org.apache.servicemix.jbi.FaultException;
import org.apache.servicemix.jbi.NoOutMessageAvailableException;
import org.apache.servicemix.jbi.api.EndpointFilter;
import org.apache.servicemix.jbi.api.EndpointResolver;
import org.apache.servicemix.jbi.api.Message;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.messaging.DefaultMarshaler;
import org.apache.servicemix.jbi.messaging.PojoMarshaler;
import org.apache.servicemix.jbi.resolver.ExternalInterfaceNameEndpointResolver;
import org.apache.servicemix.jbi.resolver.ExternalServiceNameEndpointResolver;
import org.apache.servicemix.jbi.resolver.InterfaceNameEndpointResolver;
import org.apache.servicemix.jbi.resolver.NullEndpointFilter;
import org.apache.servicemix.jbi.resolver.ServiceAndEndpointNameResolver;
import org.apache.servicemix.jbi.resolver.ServiceNameEndpointResolver;
import org.apache.servicemix.jbi.resolver.URIResolver;
import org.w3c.dom.DocumentFragment;

public class ServiceMixClientFacade
implements ServiceMixClient {
    private ComponentContext context;
    private org.apache.servicemix.jbi.resolver.EndpointFilter filter = NullEndpointFilter.getInstance();
    private PojoMarshaler marshaler = new DefaultMarshaler();
    private MessageExchangeFactory exchangeFactory;

    public ServiceMixClientFacade(ComponentContext context) {
        this.context = context;
    }

    public ServiceMixClientFacade(JBIContainer container) throws JBIException {
        this(container, new ActivationSpec());
    }

    public ServiceMixClientFacade(JBIContainer container, ActivationSpec activationSpec) throws JBIException {
        activationSpec.setComponent(this);
        container.activateComponent(activationSpec);
    }

    public InOnly createInOnlyExchange() throws MessagingException {
        InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
        NormalizedMessage in = exchange.createMessage();
        exchange.setInMessage(in);
        return exchange;
    }

    public InOnly createInOnlyExchange(EndpointResolver resolver) throws JBIException {
        InOnly exchange = this.createInOnlyExchange();
        this.configureEndpoint((MessageExchange)exchange, resolver);
        return exchange;
    }

    public InOut createInOutExchange() throws MessagingException {
        InOut exchange = this.getExchangeFactory().createInOutExchange();
        NormalizedMessage in = exchange.createMessage();
        exchange.setInMessage(in);
        return exchange;
    }

    public InOut createInOutExchange(EndpointResolver resolver) throws JBIException {
        InOut exchange = this.createInOutExchange();
        this.configureEndpoint((MessageExchange)exchange, resolver);
        return exchange;
    }

    public InOptionalOut createInOptionalOutExchange() throws MessagingException {
        InOptionalOut exchange = this.getExchangeFactory().createInOptionalOutExchange();
        NormalizedMessage in = exchange.createMessage();
        exchange.setInMessage(in);
        return exchange;
    }

    public InOptionalOut createInOptionalOutExchange(EndpointResolver resolver) throws JBIException {
        InOptionalOut exchange = this.createInOptionalOutExchange();
        this.configureEndpoint((MessageExchange)exchange, resolver);
        return exchange;
    }

    public RobustInOnly createRobustInOnlyExchange() throws MessagingException {
        RobustInOnly exchange = this.getExchangeFactory().createRobustInOnlyExchange();
        NormalizedMessage in = exchange.createMessage();
        exchange.setInMessage(in);
        return exchange;
    }

    public RobustInOnly createRobustInOnlyExchange(EndpointResolver resolver) throws JBIException {
        RobustInOnly exchange = this.getExchangeFactory().createRobustInOnlyExchange();
        this.configureEndpoint((MessageExchange)exchange, resolver);
        return exchange;
    }

    public Destination createDestination(String uri) throws MessagingException {
        return new DefaultDestination(this, uri);
    }

    public void send(MessageExchange exchange) throws MessagingException {
        this.getDeliveryChannel().send(exchange);
    }

    public void send(Message message) throws MessagingException {
        this.send(message.getExchange());
    }

    public boolean sendSync(MessageExchange exchange) throws MessagingException {
        return this.getDeliveryChannel().sendSync(exchange);
    }

    public boolean sendSync(MessageExchange exchange, long timeout) throws MessagingException {
        return this.getDeliveryChannel().sendSync(exchange, timeout);
    }

    public MessageExchange receive() throws MessagingException {
        return this.getDeliveryChannel().accept();
    }

    public MessageExchange receive(long timeout) throws MessagingException {
        return this.getDeliveryChannel().accept(timeout);
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public DeliveryChannel getDeliveryChannel() throws MessagingException {
        return this.getContext().getDeliveryChannel();
    }

    public MessageExchangeFactory getExchangeFactory() throws MessagingException {
        if (this.exchangeFactory == null && this.context != null) {
            this.exchangeFactory = this.getDeliveryChannel().createExchangeFactory();
        }
        return this.exchangeFactory;
    }

    public void done(MessageExchange exchange) throws MessagingException {
        exchange.setStatus(ExchangeStatus.DONE);
        this.getDeliveryChannel().send(exchange);
    }

    public void fail(MessageExchange exchange, Fault fault) throws MessagingException {
        exchange.setFault(fault);
        this.getDeliveryChannel().send(exchange);
    }

    public void fail(MessageExchange exchange, Exception error) throws MessagingException {
        if (error instanceof FaultException) {
            FaultException faultException = (FaultException)((Object)error);
            exchange.setFault(faultException.getFault());
        } else {
            exchange.setError(error);
        }
        this.getDeliveryChannel().send(exchange);
    }

    public Object request(Map inMessageProperties, Object content) throws JBIException {
        return this.request(null, null, inMessageProperties, content);
    }

    public void send(Map inMessageProperties, Object content) throws JBIException {
        this.send(null, null, inMessageProperties, content);
    }

    public boolean sendSync(Map inMessageProperties, Object content) throws JBIException {
        return this.sendSync(null, null, inMessageProperties, content);
    }

    public void send(EndpointResolver resolver, Map exchangeProperties, Map inMessageProperties, Object content) throws JBIException {
        InOnly exchange = this.createInOnlyExchange(resolver);
        this.populateMessage((MessageExchange)exchange, exchangeProperties, inMessageProperties, content);
        this.send((MessageExchange)exchange);
    }

    public boolean sendSync(EndpointResolver resolver, Map exchangeProperties, Map inMessageProperties, Object content) throws JBIException {
        InOnly exchange = this.createInOnlyExchange(resolver);
        this.populateMessage((MessageExchange)exchange, exchangeProperties, inMessageProperties, content);
        return this.sendSync((MessageExchange)exchange);
    }

    public Object request(EndpointResolver resolver, Map exchangeProperties, Map inMessageProperties, Object content) throws JBIException {
        InOut exchange = this.createInOutExchange(resolver);
        this.populateMessage((MessageExchange)exchange, exchangeProperties, inMessageProperties, content);
        boolean answer = this.sendSync((MessageExchange)exchange);
        if (!answer) {
            throw new JBIException("Exchange aborted");
        }
        Exception error = exchange.getError();
        if (error != null) {
            throw new JBIException((Throwable)error);
        }
        if (exchange.getFault() != null) {
            this.done((MessageExchange)exchange);
            throw FaultException.newInstance((MessageExchange)exchange);
        }
        NormalizedMessage outMessage = exchange.getOutMessage();
        if (outMessage == null) {
            throw new NoOutMessageAvailableException((MessageExchange)exchange);
        }
        Object result = this.getMarshaler().unmarshal((MessageExchange)exchange, outMessage);
        this.done((MessageExchange)exchange);
        return result;
    }

    public ServiceEndpoint resolveEndpointReference(String uri) {
        DocumentFragment epr = URIResolver.createWSAEPR(uri);
        return this.getContext().resolveEndpointReference(epr);
    }

    public EndpointResolver createResolverForService(QName service) {
        return new ServiceNameEndpointResolver(service);
    }

    public EndpointResolver createResolverInterface(QName interfaceName) {
        return new InterfaceNameEndpointResolver(interfaceName);
    }

    public EndpointResolver createResolverForExternalService(QName service) {
        return new ExternalServiceNameEndpointResolver(service);
    }

    public EndpointResolver createResolverForExternalInterface(QName interfaceName) {
        return new ExternalInterfaceNameEndpointResolver(interfaceName);
    }

    public EndpointResolver createResolverForExternalInterface(QName service, String endpoint) {
        return new ServiceAndEndpointNameResolver(service, endpoint);
    }

    public void close() throws JBIException {
    }

    public org.apache.servicemix.jbi.resolver.EndpointFilter getFilter() {
        return this.filter;
    }

    public void setFilter(org.apache.servicemix.jbi.resolver.EndpointFilter filter) {
        this.filter = filter;
    }

    public PojoMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(PojoMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    protected void configureEndpoint(MessageExchange exchange, EndpointResolver resolver) throws JBIException {
        if (resolver != null) {
            exchange.setEndpoint(resolver.resolveEndpoint(this.getContext(), exchange, (EndpointFilter)this.filter));
        }
    }

    protected void populateMessage(MessageExchange exchange, Map exchangeProperties, Map inMessageProperties, Object content) throws MessagingException {
        NormalizedMessage in = exchange.getMessage("in");
        this.populateExchangeProperties(exchange, exchangeProperties);
        this.populateMessageProperties(in, inMessageProperties);
        this.getMarshaler().marshal(exchange, in, content);
    }

    protected void populateExchangeProperties(MessageExchange exchange, Map properties) {
        if (properties != null) {
            for (Map.Entry entry : properties.entrySet()) {
                exchange.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
    }

    protected void populateMessageProperties(NormalizedMessage message, Map properties) {
        if (properties != null) {
            for (Map.Entry entry : properties.entrySet()) {
                message.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
    }
}

