/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.JBIException;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.util.ComponentSupport;

public abstract class OutBinding
extends ComponentSupport
implements Runnable,
MessageExchangeListener {
    private static final Log LOG = LogFactory.getLog(OutBinding.class);
    private AtomicBoolean stop = new AtomicBoolean(true);
    private Thread runnable;

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            try {
                NormalizedMessage message = this.getInMessage(exchange);
                this.process(exchange, message);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Exchange failed", (Throwable)e);
                }
                this.fail(exchange, e);
            }
        }
    }

    public void run() {
        block5: {
            try {
                DeliveryChannel deliveryChannel = this.getDeliveryChannel();
                while (!this.stop.get()) {
                    MessageExchange exchange = deliveryChannel.accept();
                    if (exchange == null) continue;
                    try {
                        this.onMessageExchange(exchange);
                    }
                    catch (MessagingException e) {
                        LOG.error((Object)"MessageExchange processing failed", (Throwable)e);
                    }
                }
            }
            catch (MessagingException e) {
                if (this.stop.get()) break block5;
                LOG.error((Object)"run failed", (Throwable)e);
            }
        }
    }

    public void shutDown() throws JBIException {
    }

    public void stop() throws JBIException {
        this.stop.compareAndSet(false, true);
        if (this.runnable != null) {
            this.runnable.interrupt();
            try {
                this.runnable.join();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Unable to stop component polling thread", (Throwable)e);
            }
            this.runnable = null;
        }
    }

    public void start() throws JBIException {
        if (this.stop.compareAndSet(true, false)) {
            this.runnable = new Thread(this);
            this.runnable.setDaemon(true);
            this.runnable.start();
        }
    }

    protected abstract void process(MessageExchange var1, NormalizedMessage var2) throws Exception;
}

