/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.DomWriter;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jbi.messaging.DefaultMarshaler;
import org.w3c.dom.Document;

public class XStreamMarshaler
extends DefaultMarshaler {
    private XStream xStream;
    private SourceTransformer transformer = new SourceTransformer();
    private boolean useDOM;

    public void marshal(MessageExchange exchange, NormalizedMessage message, Object body) throws MessagingException {
        if (this.useDOM) {
            try {
                Document document = this.transformer.createDocument();
                this.getXStream().marshal(body, (HierarchicalStreamWriter)new DomWriter(document));
                message.setContent((Source)new DOMSource(document));
            }
            catch (ParserConfigurationException e) {
                throw new MessagingException("Failed to marshal: " + body + " to DOM document: " + e, (Throwable)e);
            }
        } else {
            String xml = this.getXStream().toXML(body);
            message.setContent((Source)new StringSource(xml));
        }
    }

    public Object unmarshal(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        Source content = message.getContent();
        if (content != null) {
            if (content instanceof StreamSource) {
                StreamSource source = (StreamSource)content;
                return this.getXStream().fromXML(source.getReader());
            }
            Document document = null;
            if (content instanceof DOMSource) {
                DOMSource domSource = (DOMSource)content;
                document = (Document)domSource.getNode();
            } else {
                DOMResult result = new DOMResult();
                try {
                    this.transformer.toResult(content, (Result)result);
                }
                catch (TransformerException e) {
                    throw new MessagingException("Failed to transform content: " + content + " to DOMResult: " + e, (Throwable)e);
                }
                document = (Document)result.getNode();
            }
            return this.getXStream().unmarshal((HierarchicalStreamReader)new DomReader(document));
        }
        return super.unmarshal(exchange, message);
    }

    public XStream getXStream() {
        if (this.xStream == null) {
            this.xStream = this.createXStream();
        }
        return this.xStream;
    }

    public void setXStream(XStream xStream) {
        this.xStream = xStream;
    }

    public SourceTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(SourceTransformer transformer) {
        this.transformer = transformer;
    }

    public boolean isUseDOM() {
        return this.useDOM;
    }

    public void setUseDOM(boolean useDOM) {
        this.useDOM = useDOM;
    }

    protected XStream createXStream() {
        XStream answer = new XStream();
        try {
            answer.alias("invoke", Class.forName("org.logicblaze.lingo.LingoInvocation"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return answer;
    }
}

