/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.container;

import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import java.util.EventListener;
import java.util.MissingResourceException;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import javax.jbi.management.LifeCycleMBean;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.event.EventListenerList;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.util.ComponentAdaptor;
import org.apache.servicemix.components.util.ComponentAdaptorMEListener;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.components.util.PojoLifecycleAdaptor;
import org.apache.servicemix.components.util.PojoSupport;
import org.apache.servicemix.executors.ExecutorFactory;
import org.apache.servicemix.executors.impl.ExecutorFactoryImpl;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.jbi.api.Container;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.container.ComponentEnvironment;
import org.apache.servicemix.jbi.container.EnvironmentContext;
import org.apache.servicemix.jbi.event.ComponentListener;
import org.apache.servicemix.jbi.event.ContainerAware;
import org.apache.servicemix.jbi.event.DeploymentListener;
import org.apache.servicemix.jbi.event.EndpointListener;
import org.apache.servicemix.jbi.event.ExchangeEvent;
import org.apache.servicemix.jbi.event.ExchangeListener;
import org.apache.servicemix.jbi.event.ServiceAssemblyListener;
import org.apache.servicemix.jbi.event.ServiceUnitListener;
import org.apache.servicemix.jbi.framework.AdminCommandsService;
import org.apache.servicemix.jbi.framework.AutoDeploymentService;
import org.apache.servicemix.jbi.framework.ClientFactory;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.framework.DeploymentService;
import org.apache.servicemix.jbi.framework.InstallationService;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.listener.MessageExchangeListener;
import org.apache.servicemix.jbi.management.BaseLifeCycle;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.management.ManagementContext;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.nmr.Broker;
import org.apache.servicemix.jbi.nmr.DefaultBroker;
import org.apache.servicemix.jbi.nmr.flow.Flow;
import org.w3c.dom.DocumentFragment;

public class JBIContainer
extends BaseLifeCycle
implements Container {
    public static final String DEFAULT_NAME = "ServiceMix";
    private static final Log LOG = LogFactory.getLog(JBIContainer.class);
    protected Broker broker = new DefaultBroker();
    protected ServiceUnitManager serviceManager;
    protected ManagementContext managementContext = new ManagementContext();
    protected EnvironmentContext environmentContext = new EnvironmentContext();
    protected InstallationService installationService = new InstallationService();
    protected DeploymentService deploymentService = new DeploymentService();
    protected AutoDeploymentService autoDeployService = new AutoDeploymentService();
    protected AdminCommandsService adminCommandsService = new AdminCommandsService();
    protected BaseSystemService[] services;
    protected ClientFactory clientFactory = new ClientFactory();
    protected Registry registry = new Registry();
    protected boolean autoEnlistInTransaction;
    protected boolean persistent;
    protected boolean embedded;
    protected boolean notifyStatistics;
    protected EventListenerList listeners = new EventListenerList();
    protected EventListener[] configuredListeners;
    protected boolean useShutdownHook = true;
    protected boolean useNewTransactionModel;
    protected transient Thread shutdownHook;
    protected ExecutorFactory executorFactory;
    private String name = "ServiceMix";
    private InitialContext namingContext;
    private MBeanServer mbeanServer;
    private TransactionManager transactionManager;
    private String rootDir;
    private String generatedRootDirPrefix = "target/rootDirs/rootDir";
    private boolean generateRootDir;
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean containerInitialized = new AtomicBoolean(false);
    private IdGenerator idGenerator = new IdGenerator();
    private long forceShutdown;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return "ServiceMix JBI Container";
    }

    public String getFlowName() {
        String flowNames = this.getDefaultBroker().getFlowNames();
        if (flowNames == null) {
            return null;
        }
        String[] flows = flowNames.split(",");
        if (flows.length > 1) {
            throw new IllegalStateException("Multiple flows have been defined");
        }
        return flows[0];
    }

    public void setFlowName(String flowName) {
        this.getDefaultBroker().setFlowNames(flowName);
    }

    public String getFlowNames() {
        return this.getDefaultBroker().getFlowNames();
    }

    public void setFlowNames(String flowNames) {
        this.getDefaultBroker().setFlowNames(flowNames);
    }

    public String getSubscriptionFlowName() {
        return this.getDefaultBroker().getSubscriptionFlowName();
    }

    public void setSubscriptionFlowName(String subscriptionFlowName) {
        this.getDefaultBroker().setSubscriptionFlowName(subscriptionFlowName);
    }

    public void setFlow(Flow flow) {
        this.getDefaultBroker().setFlows(new Flow[]{flow});
    }

    public Flow getFlow() {
        Flow[] flows = this.getDefaultBroker().getFlows();
        if (flows == null || flows.length == 0) {
            return null;
        }
        if (flows.length > 1) {
            throw new IllegalStateException("Multiple flows have been defined");
        }
        return flows[0];
    }

    public void setFlows(Flow[] flows) {
        this.getDefaultBroker().setFlows(flows);
    }

    public Flow[] getFlows() {
        return this.getDefaultBroker().getFlows();
    }

    public boolean isUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    public boolean isUseNewTransactionModel() {
        return this.useNewTransactionModel;
    }

    public void setUseNewTransactionModel(boolean useNewTransactionModel) {
        this.useNewTransactionModel = useNewTransactionModel;
    }

    public BaseSystemService[] getServices() {
        return this.services;
    }

    public void setServices(BaseSystemService[] services) {
        this.services = services;
    }

    public ManagementContext getManagementContext() {
        return this.managementContext;
    }

    public EnvironmentContext getEnvironmentContext() {
        return this.environmentContext;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public DefaultBroker getDefaultBroker() {
        if (!(this.broker instanceof DefaultBroker)) {
            throw new IllegalStateException("Broker is not a DefaultBroker");
        }
        return (DefaultBroker)this.broker;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
    }

    public boolean isCreateMBeanServer() {
        return this.managementContext.isCreateMBeanServer();
    }

    public void setCreateMBeanServer(boolean enableJMX) {
        this.managementContext.setCreateMBeanServer(enableJMX);
    }

    public boolean isUseMBeanServer() {
        return this.managementContext.isUseMBeanServer();
    }

    public void setUseMBeanServer(boolean useMBeanServer) {
        this.managementContext.setUseMBeanServer(useMBeanServer);
    }

    public boolean isCreateJmxConnector() {
        return this.managementContext.isCreateJmxConnector();
    }

    public void setCreateJmxConnector(boolean createJmxConnector) {
        this.managementContext.setCreateJmxConnector(createJmxConnector);
    }

    public boolean isMonitorInstallationDirectory() {
        return this.autoDeployService.isMonitorInstallationDirectory();
    }

    public void setMonitorInstallationDirectory(boolean monitorInstallationDirectory) {
        this.autoDeployService.setMonitorInstallationDirectory(monitorInstallationDirectory);
    }

    public boolean isMonitorDeploymentDirectory() {
        return this.autoDeployService.isMonitorDeploymentDirectory();
    }

    public void setMonitorDeploymentDirectory(boolean monitorDeploymentDirectory) {
        this.autoDeployService.setMonitorDeploymentDirectory(monitorDeploymentDirectory);
    }

    public String getInstallationDirPath() {
        File dir = this.environmentContext.getInstallationDir();
        return dir != null ? dir.getAbsolutePath() : "";
    }

    public void setInstallationDirPath(String installationDir) {
        if (installationDir != null && installationDir.length() > 0) {
            this.environmentContext.setInstallationDir(new File(installationDir));
        }
    }

    public String getDeploymentDirPath() {
        File dir = this.environmentContext.getDeploymentDir();
        return dir != null ? dir.getAbsolutePath() : "";
    }

    public void setDeploymentDirPath(String deploymentDir) {
        if (deploymentDir != null && deploymentDir.length() > 0) {
            this.environmentContext.setDeploymentDir(new File(deploymentDir));
        }
    }

    public int getMonitorInterval() {
        return this.autoDeployService.getMonitorInterval();
    }

    public void setMonitorInterval(int monitorInterval) {
        this.autoDeployService.setMonitorInterval(monitorInterval);
    }

    public String getDeploymentExtensions() {
        return this.autoDeployService.getExtensions();
    }

    public void setDeploymentExtensions(String deploymentExtensions) {
        this.autoDeployService.setExtensions(deploymentExtensions);
    }

    public void installArchive(String url) throws DeploymentException {
        this.installationService.install(url, null, true);
    }

    public void updateExternalArchive(String location, boolean autoStart) throws DeploymentException {
        this.autoDeployService.updateExternalArchive(location, autoStart);
    }

    public void updateExternalArchive(String location) throws DeploymentException {
        this.updateExternalArchive(location, true);
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public InstallationService getInstallationService() {
        return this.installationService;
    }

    public AutoDeploymentService getAutoDeploymentService() {
        return this.autoDeployService;
    }

    public AdminCommandsService getAdminCommandsService() {
        return this.adminCommandsService;
    }

    public ClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public String getGeneratedRootDirPrefix() {
        return this.generatedRootDirPrefix;
    }

    public void setGeneratedRootDirPrefix(String generatedRootDirPrefix) {
        this.generatedRootDirPrefix = generatedRootDirPrefix;
    }

    public boolean isGenerateRootDir() {
        return this.generateRootDir;
    }

    public long getForceShutdown() {
        return this.forceShutdown;
    }

    public void setForceShutdown(long forceShutdown) {
        this.forceShutdown = forceShutdown;
    }

    public void setGenerateRootDir(boolean generateRootDir) {
        this.generateRootDir = generateRootDir;
    }

    public void init() throws JBIException {
        if (this.containerInitialized.compareAndSet(false, true)) {
            LOG.info((Object)("ServiceMix " + EnvironmentContext.getVersion() + " JBI Container (" + this.getName() + ") is starting"));
            LOG.info((Object)"For help or more information please see: http://servicemix.apache.org/");
            this.addShutdownHook();
            if (this.executorFactory == null) {
                this.executorFactory = this.createExecutorFactory();
            }
            if (this.namingContext == null) {
                try {
                    this.namingContext = new InitialContext();
                }
                catch (NamingException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn((Object)"Failed to set InitialContext", (Throwable)e);
                    }
                    LOG.warn((Object)"Failed to set InitialContext");
                }
            }
            this.managementContext.init(this, this.getMBeanServer());
            this.mbeanServer = this.managementContext.getMBeanServer();
            this.environmentContext.init(this, this.getRootDir());
            this.clientFactory.init(this);
            if (this.services != null) {
                for (int i = 0; i < this.services.length; ++i) {
                    this.services[i].init(this);
                }
            }
            this.registry.init(this);
            this.broker.init(this);
            this.installationService.init(this);
            this.deploymentService.init(this);
            this.autoDeployService.init(this);
            this.adminCommandsService.init(this);
            try {
                this.managementContext.registerMBean(ManagementContext.getContainerObjectName(this.managementContext.getJmxDomainName(), this.getName()), this, LifeCycleMBean.class);
            }
            catch (JMException e) {
                throw new JBIException((Throwable)e);
            }
            if (this.configuredListeners != null) {
                for (int i = 0; i < this.configuredListeners.length; ++i) {
                    EventListener listener = this.configuredListeners[i];
                    this.addListener(listener);
                }
            }
        }
    }

    public void start() throws JBIException {
        this.checkInitialized();
        if (this.started.compareAndSet(false, true)) {
            this.managementContext.start();
            this.environmentContext.start();
            this.clientFactory.start();
            if (this.services != null) {
                for (int i = 0; i < this.services.length; ++i) {
                    this.services[i].start();
                }
            }
            this.broker.start();
            this.registry.start();
            this.installationService.start();
            this.deploymentService.start();
            this.autoDeployService.start();
            this.adminCommandsService.start();
            super.start();
            LOG.info((Object)("ServiceMix JBI Container (" + this.getName() + ") started"));
        }
    }

    public void stop() throws JBIException {
        this.checkInitialized();
        if (this.started.compareAndSet(true, false)) {
            LOG.info((Object)("ServiceMix JBI Container (" + this.getName() + ") stopping"));
            this.adminCommandsService.stop();
            this.autoDeployService.stop();
            this.deploymentService.stop();
            this.installationService.stop();
            this.registry.stop();
            this.broker.stop();
            if (this.services != null) {
                for (int i = this.services.length - 1; i >= 0; --i) {
                    this.services[i].stop();
                }
            }
            this.clientFactory.stop();
            this.environmentContext.stop();
            this.managementContext.stop();
            super.stop();
        }
    }

    public void shutDown() throws JBIException {
        if (this.containerInitialized.compareAndSet(true, false)) {
            LOG.info((Object)("Shutting down ServiceMix JBI Container (" + this.getName() + ") stopped"));
            this.removeShutdownHook();
            this.adminCommandsService.shutDown();
            this.autoDeployService.shutDown();
            this.deploymentService.shutDown();
            this.installationService.shutDown();
            this.shutdownRegistry();
            this.broker.shutDown();
            this.shutdownServices();
            this.clientFactory.shutDown();
            this.environmentContext.shutDown();
            super.shutDown();
            this.managementContext.unregisterMBean(this);
            this.managementContext.shutDown();
            LOG.info((Object)("ServiceMix JBI Container (" + this.getName() + ") stopped"));
        }
    }

    private void shutdownServices() throws JBIException {
        if (this.services != null) {
            for (int i = this.services.length - 1; i >= 0; --i) {
                this.services[i].shutDown();
            }
        }
    }

    private void shutdownRegistry() throws JBIException {
        FutureTask<Boolean> shutdown = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                JBIContainer.this.registry.shutDown();
                return true;
            }
        });
        Thread daemonShutDownThread = new Thread(shutdown);
        daemonShutDownThread.setDaemon(true);
        daemonShutDownThread.start();
        try {
            if (this.forceShutdown > 0L) {
                LOG.info((Object)("Waiting another " + this.forceShutdown + " ms for complete shutdown of the components and service assemblies"));
                shutdown.get(this.forceShutdown, TimeUnit.MILLISECONDS);
            } else {
                LOG.info((Object)"Waiting for complete shutdown of the components and service assemblies");
                shutdown.get();
            }
            LOG.info((Object)"Components and service assemblies have been shut down");
        }
        catch (Exception e) {
            this.forceShutdown(e);
        }
    }

    protected void forceShutdown(Exception e) {
        LOG.warn((Object)("Unable to shutdown components and service assemblies normally: " + e), (Throwable)e);
        LOG.warn((Object)"Forcing shutdown by cancelling all pending exchanges");
        this.registry.cancelPendingExchanges();
    }

    protected void addShutdownHook() {
        if (this.useShutdownHook) {
            this.shutdownHook = new Thread("ServiceMix ShutdownHook"){

                public void run() {
                    JBIContainer.this.containerShutdown();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    protected void removeShutdownHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception e) {
                LOG.debug((Object)("Caught exception, must be shutting down: " + e));
            }
        }
    }

    protected void containerShutdown() {
        try {
            this.shutDown();
        }
        catch (Throwable e) {
            System.err.println("Failed to shut down: " + e);
        }
    }

    public synchronized MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public synchronized void setMBeanServer(MBeanServer mbs) {
        this.mbeanServer = mbs;
    }

    public synchronized InitialContext getNamingContext() {
        return this.namingContext;
    }

    public synchronized void setNamingContext(InitialContext ic) {
        this.namingContext = ic;
    }

    public synchronized Object getTransactionManager() {
        if (this.transactionManager == null && this.namingContext != null) {
            try {
                this.transactionManager = (TransactionManager)this.namingContext.lookup("java:appserver/TransactionManager");
            }
            catch (NamingException e) {
                LOG.debug((Object)("No transaction manager found from naming context: " + e.getMessage()));
                try {
                    this.transactionManager = (TransactionManager)this.namingContext.lookup("javax.transaction.TransactionManager");
                }
                catch (NamingException e1) {
                    LOG.debug((Object)("No transaction manager found from naming context: " + e1.getMessage()));
                }
            }
        }
        return this.transactionManager;
    }

    public synchronized void setTransactionManager(Object tm) {
        this.transactionManager = (TransactionManager)tm;
    }

    public synchronized String getRootDir() {
        if (this.rootDir == null) {
            this.rootDir = this.isGenerateRootDir() ? this.createRootDir() : "." + File.separator + "rootDir";
            LOG.debug((Object)("Defaulting to rootDir: " + this.rootDir));
        }
        return this.rootDir;
    }

    public synchronized void setRootDir(String root) {
        this.rootDir = root;
    }

    public void sendExchange(MessageExchangeImpl exchange) throws MessagingException {
        try {
            this.broker.sendExchangePacket(exchange);
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (JBIException e) {
            throw new MessagingException((Throwable)e);
        }
    }

    public void registerExternalEndpoint(ComponentNameSpace cns, ServiceEndpoint externalEndpoint) throws JBIException {
        this.registry.registerExternalEndpoint(cns, externalEndpoint);
    }

    public void deregisterExternalEndpoint(ComponentNameSpace cns, ServiceEndpoint externalEndpoint) throws JBIException {
        this.registry.deregisterExternalEndpoint(cns, externalEndpoint);
    }

    public ServiceEndpoint resolveEndpointReference(ComponentContextImpl context, DocumentFragment epr) {
        return this.registry.resolveEndpointReference(epr);
    }

    public ServiceEndpoint getEndpoint(ComponentContextImpl context, QName service, String endpointName) {
        return this.registry.getEndpoint(service, endpointName);
    }

    public ServiceEndpoint[] getEndpoints(ComponentContextImpl context, QName interfaceName) {
        return this.registry.getEndpointsForInterface(interfaceName);
    }

    public ServiceEndpoint[] getEndpointsForService(ComponentContextImpl context, QName serviceName) {
        return this.registry.getEndpointsForService(serviceName);
    }

    public ServiceEndpoint[] getExternalEndpoints(ComponentContextImpl context, QName interfaceName) {
        return this.registry.getExternalEndpoints(interfaceName);
    }

    public ServiceEndpoint[] getExternalEndpointsForService(ComponentContextImpl context, QName serviceName) {
        return this.registry.getExternalEndpointsForService(serviceName);
    }

    public Logger getLogger(String suffix, String resourceBundleName) throws MissingResourceException, JBIException {
        try {
            return Logger.getLogger(suffix, resourceBundleName);
        }
        catch (IllegalArgumentException e) {
            throw new JBIException("A logger can not be created using resource bundle " + resourceBundleName);
        }
    }

    public void deactivateComponent(String componentName) throws JBIException {
        ComponentMBeanImpl component = this.registry.getComponent(componentName);
        if (component == null) {
            throw new JBIException("Could not find component " + componentName);
        }
        component.doShutDown();
        component.unregisterMbeans(this.managementContext);
        this.registry.deregisterComponent(component);
        this.environmentContext.unreregister(component);
        component.dispose();
        LOG.info((Object)("Deactivating component " + componentName));
    }

    public void deleteComponent(String id) throws JBIException {
        this.deactivateComponent(id);
        this.environmentContext.removeComponentRootDirectory(id);
    }

    public ComponentMBeanImpl getComponent(String componentName) {
        return this.registry.getComponent(componentName);
    }

    public Collection getLocalComponentConnectors() {
        return this.registry.getComponents();
    }

    public Component activateComponent(ActivationSpec activationSpec) throws JBIException {
        Object bean;
        String id;
        if (activationSpec.getId() == null) {
            if (activationSpec.getComponentName() == null) {
                activationSpec.setId(this.createComponentID());
            } else {
                activationSpec.setId(activationSpec.getComponentName());
            }
        }
        if ((id = activationSpec.getId()) == null) {
            throw new IllegalArgumentException("A Registration must have an ID");
        }
        if (activationSpec.getEndpoint() == null && activationSpec.getService() != null) {
            activationSpec.setEndpoint(id);
        }
        if (activationSpec.getComponentName() == null) {
            activationSpec.setComponentName(id);
        }
        if ((bean = activationSpec.getComponent()) == null) {
            throw new IllegalArgumentException("A Registration must have a component associated with it");
        }
        if (bean instanceof Component) {
            Component component = (Component)bean;
            if (component instanceof ComponentSupport) {
                this.defaultComponentServiceAndEndpoint((ComponentSupport)component, activationSpec);
            }
            this.activateComponent(component, activationSpec);
            return component;
        }
        if (bean instanceof ComponentLifeCycle) {
            ComponentLifeCycle lifeCycle = (ComponentLifeCycle)bean;
            if (bean instanceof PojoSupport) {
                this.defaultComponentServiceAndEndpoint((PojoSupport)bean, activationSpec);
            }
            Component adaptor = this.createComponentAdaptor(lifeCycle, activationSpec);
            this.activateComponent(adaptor, activationSpec);
            return adaptor;
        }
        if (bean instanceof MessageExchangeListener) {
            MessageExchangeListener listener = (MessageExchangeListener)bean;
            Component adaptor = this.createComponentAdaptor(listener, activationSpec);
            this.activateComponent(adaptor, activationSpec);
            return adaptor;
        }
        throw new IllegalArgumentException("Component name: " + id + " is bound to an object which is not a JBI component, it is of type: " + bean.getClass().getName());
    }

    public ObjectName activateComponent(Component component, String componentName) throws JBIException {
        ActivationSpec activationSpec = new ActivationSpec();
        ComponentNameSpace cns = new ComponentNameSpace(this.getName(), componentName);
        activationSpec.setComponent(component);
        activationSpec.setComponentName(cns.getName());
        return this.activateComponent(component, activationSpec);
    }

    public ObjectName activateComponent(Component component, ActivationSpec activationSpec) throws JBIException {
        return this.activateComponent(component, "POJO Component", activationSpec, true, false, false, null);
    }

    public ObjectName activateComponent(File installDir, Component component, String description, ComponentContextImpl context, boolean binding, boolean service, String[] sharedLibraries) throws JBIException {
        ComponentNameSpace cns = context.getComponentNameSpace();
        ActivationSpec activationSpec = new ActivationSpec();
        activationSpec.setComponent(component);
        activationSpec.setComponentName(cns.getName());
        return this.activateComponent(installDir, component, description, context, activationSpec, false, binding, service, sharedLibraries);
    }

    public ObjectName activateComponent(Component component, String description, ActivationSpec activationSpec, boolean pojo, boolean binding, boolean service, String[] sharedLibraries) throws JBIException {
        ComponentNameSpace cns = new ComponentNameSpace(this.getName(), activationSpec.getComponentName());
        if (this.registry.getComponent(cns) != null) {
            throw new JBIException("A component is already registered for " + cns);
        }
        ComponentContextImpl context = new ComponentContextImpl(this, cns);
        return this.activateComponent(new File("."), component, description, context, activationSpec, pojo, binding, service, sharedLibraries);
    }

    public ObjectName activateComponent(File installationDir, Component component, String description, ComponentContextImpl context, ActivationSpec activationSpec, boolean pojo, boolean binding, boolean service, String[] sharedLibraries) throws JBIException {
        ComponentMBeanImpl lcc;
        ObjectName result = null;
        ComponentNameSpace cns = new ComponentNameSpace(this.getName(), activationSpec.getComponentName());
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("Activating component for: " + cns + " with service: " + activationSpec.getService() + " component: " + component));
        }
        if ((lcc = this.registry.registerComponent(cns, description, component, binding, service, sharedLibraries)) != null) {
            lcc.setPojo(pojo);
            ComponentEnvironment env = this.environmentContext.registerComponent(context.getEnvironment(), lcc);
            if (env.getInstallRoot() == null) {
                env.setInstallRoot(installationDir);
            }
            context.activate(component, env, activationSpec);
            lcc.setContext(context);
            lcc.setActivationSpec(activationSpec);
            if (lcc.isPojo()) {
                lcc.init();
            } else {
                lcc.doShutDown();
            }
            result = lcc.registerMBeans(this.managementContext);
            if (lcc.isPojo() && this.started.get()) {
                lcc.start();
            }
        }
        return result;
    }

    protected void defaultComponentServiceAndEndpoint(PojoSupport component, ActivationSpec activationSpec) {
        if (activationSpec.getService() != null) {
            component.setService(activationSpec.getService());
        }
        if (activationSpec.getEndpoint() != null) {
            component.setEndpoint(activationSpec.getEndpoint());
        }
    }

    protected ExecutorFactory createExecutorFactory() throws JBIException {
        return new ExecutorFactoryImpl();
    }

    protected Component createComponentAdaptor(ComponentLifeCycle lifeCycle, ActivationSpec activationSpec) {
        ComponentAdaptor answer = null;
        answer = lifeCycle instanceof MessageExchangeListener ? new ComponentAdaptorMEListener(lifeCycle, activationSpec.getService(), activationSpec.getEndpoint(), (MessageExchangeListener)lifeCycle) : new ComponentAdaptor(lifeCycle, activationSpec.getService(), activationSpec.getEndpoint());
        answer.setServiceManager(this.serviceManager);
        return answer;
    }

    protected Component createComponentAdaptor(MessageExchangeListener listener, ActivationSpec activationSpec) {
        PojoLifecycleAdaptor lifecCycle = new PojoLifecycleAdaptor(listener, activationSpec.getService(), activationSpec.getEndpoint());
        return new ComponentAdaptorMEListener(lifecCycle, listener);
    }

    protected String createComponentID() {
        return this.idGenerator.generateId();
    }

    protected void checkInitialized() throws JBIException {
        if (!this.containerInitialized.get()) {
            throw new JBIException("The Container is not initialized - please call init(...)");
        }
    }

    public boolean isAutoEnlistInTransaction() {
        return this.autoEnlistInTransaction;
    }

    public void setAutoEnlistInTransaction(boolean autoEnlistInTransaction) {
        this.autoEnlistInTransaction = autoEnlistInTransaction;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void addListener(EventListener listener) {
        LOG.debug((Object)("Adding listener: " + listener.getClass()));
        if (listener instanceof ContainerAware) {
            ContainerAware containerAware = (ContainerAware)((Object)listener);
            containerAware.setContainer(this);
        }
        if (listener instanceof ExchangeListener) {
            this.listeners.add(ExchangeListener.class, (ExchangeListener)listener);
        }
        if (listener instanceof ComponentListener) {
            this.listeners.add(ComponentListener.class, (ComponentListener)listener);
        }
        if (listener instanceof ServiceAssemblyListener) {
            this.listeners.add(ServiceAssemblyListener.class, (ServiceAssemblyListener)listener);
        }
        if (listener instanceof ServiceUnitListener) {
            this.listeners.add(ServiceUnitListener.class, (ServiceUnitListener)listener);
        }
        if (listener instanceof EndpointListener) {
            this.listeners.add(EndpointListener.class, (EndpointListener)listener);
        }
        if (listener instanceof DeploymentListener) {
            this.listeners.add(DeploymentListener.class, (DeploymentListener)listener);
        }
    }

    public void removeListener(EventListener listener) {
        LOG.debug((Object)("Removing listener: " + listener.getClass()));
        if (listener instanceof ExchangeListener) {
            this.listeners.remove(ExchangeListener.class, (ExchangeListener)listener);
        }
        if (listener instanceof ComponentListener) {
            this.listeners.remove(ComponentListener.class, (ComponentListener)listener);
        }
        if (listener instanceof ServiceAssemblyListener) {
            this.listeners.remove(ServiceAssemblyListener.class, (ServiceAssemblyListener)listener);
        }
        if (listener instanceof ServiceUnitListener) {
            this.listeners.remove(ServiceUnitListener.class, (ServiceUnitListener)listener);
        }
        if (listener instanceof EndpointListener) {
            this.listeners.remove(EndpointListener.class, (EndpointListener)listener);
        }
        if (listener instanceof DeploymentListener) {
            this.listeners.remove(DeploymentListener.class, (DeploymentListener)listener);
        }
    }

    public Object[] getListeners(Class lc) {
        return this.listeners.getListeners(lc);
    }

    public void setListeners(EventListener[] listeners) {
        this.configuredListeners = listeners;
    }

    public void resendExchange(MessageExchange exchange) throws JBIException {
        if (!(exchange instanceof MessageExchangeImpl)) {
            throw new IllegalArgumentException("exchange should be a MessageExchangeImpl");
        }
        MessageExchangeImpl me = (MessageExchangeImpl)exchange;
        me.getPacket().setExchangeId(new IdGenerator().generateId());
        me.getPacket().setOut(null);
        me.getPacket().setFault(null);
        me.getPacket().setError(null);
        me.getPacket().setStatus(ExchangeStatus.ACTIVE);
        me.getPacket().setProperty("org.apache.servicemix.datestamp", Calendar.getInstance());
        ExchangeListener[] l = (ExchangeListener[])this.listeners.getListeners(ExchangeListener.class);
        ExchangeEvent event = new ExchangeEvent(me, 0);
        for (int i = 0; i < l.length; ++i) {
            try {
                l[i].exchangeSent(event);
                continue;
            }
            catch (Exception e) {
                LOG.warn((Object)("Error calling listener: " + e.getMessage()), (Throwable)e);
            }
        }
        me.handleSend(false);
        this.sendExchange(me.getMirror());
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setRmiPort(int portNum) {
        this.getManagementContext().setNamingPort(portNum);
    }

    public int getRmiPort() {
        return this.getManagementContext().getNamingPort();
    }

    public boolean isNotifyStatistics() {
        return this.notifyStatistics;
    }

    public void setNotifyStatistics(boolean notifyStatistics) {
        this.notifyStatistics = notifyStatistics;
    }

    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    public void setExecutorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    protected String createRootDir() {
        String prefix = this.getGeneratedRootDirPrefix();
        int i = 1;
        while (true) {
            File file;
            if (!(file = new File(prefix + i)).exists()) {
                file.mkdirs();
                return file.getAbsolutePath();
            }
            ++i;
        }
    }
}

