/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipFile;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.EnvironmentContext;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.deployment.Component;
import org.apache.servicemix.jbi.deployment.Descriptor;
import org.apache.servicemix.jbi.deployment.DescriptorFactory;
import org.apache.servicemix.jbi.deployment.ServiceAssembly;
import org.apache.servicemix.jbi.event.DeploymentEvent;
import org.apache.servicemix.jbi.event.DeploymentListener;
import org.apache.servicemix.jbi.framework.AutoDeploymentServiceMBean;
import org.apache.servicemix.jbi.framework.DeploymentService;
import org.apache.servicemix.jbi.framework.InstallationService;
import org.apache.servicemix.jbi.framework.ManagementSupport;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.util.XmlPersistenceSupport;
import org.apache.servicemix.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoDeploymentService
extends BaseSystemService
implements AutoDeploymentServiceMBean {
    private static final Log LOG = LogFactory.getLog(AutoDeploymentService.class);
    private static String filePrefix = "file:///";
    private EnvironmentContext environmentContext;
    private DeploymentService deploymentService;
    private InstallationService installationService;
    private boolean monitorInstallationDirectory = true;
    private boolean monitorDeploymentDirectory = true;
    private int monitorInterval = 10;
    private String extensions = ".zip,.jar";
    private AtomicBoolean started = new AtomicBoolean(false);
    private Timer statsTimer;
    private TimerTask timerTask;
    private Map<File, ArchiveEntry> pendingComponents = new ConcurrentHashMap<File, ArchiveEntry>();
    private Map<File, ArchiveEntry> pendingSAs = new ConcurrentHashMap<File, ArchiveEntry>();
    private Map<String, ArchiveEntry> installFileMap;
    private Map<String, ArchiveEntry> deployFileMap;

    public String getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String extensions) {
        this.extensions = extensions;
    }

    @Override
    public String getDescription() {
        return "automatically installs and deploys JBI Archives";
    }

    public boolean isMonitorInstallationDirectory() {
        return this.monitorInstallationDirectory;
    }

    public void setMonitorInstallationDirectory(boolean monitorInstallationDirectory) {
        this.monitorInstallationDirectory = monitorInstallationDirectory;
    }

    public boolean isMonitorDeploymentDirectory() {
        return this.monitorDeploymentDirectory;
    }

    public void setMonitorDeploymentDirectory(boolean monitorDeploymentDirectory) {
        this.monitorDeploymentDirectory = monitorDeploymentDirectory;
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    @Override
    public void start() throws JBIException {
        super.start();
        if (this.started.compareAndSet(false, true)) {
            this.scheduleDirectoryTimer();
        }
    }

    @Override
    public void stop() throws JBIException {
        if (this.started.compareAndSet(true, false)) {
            super.stop();
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
        }
    }

    @Override
    public void init(JBIContainer container) throws JBIException {
        super.init(container);
        this.environmentContext = container.getEnvironmentContext();
        this.installationService = container.getInstallationService();
        this.deploymentService = container.getDeploymentService();
        if (this.environmentContext.getTmpDir() != null) {
            FileUtil.deleteFile((File)this.environmentContext.getTmpDir());
        }
        this.initializeFileMaps();
    }

    @Override
    protected Class<AutoDeploymentServiceMBean> getServiceMBean() {
        return AutoDeploymentServiceMBean.class;
    }

    public ArchiveEntry updateExternalArchive(String location, boolean autoStart) throws DeploymentException {
        ArchiveEntry entry = new ArchiveEntry();
        entry.location = location;
        entry.lastModified = new Date();
        this.updateArchive(location, entry, autoStart);
        return entry;
    }

    public void updateArchive(String location, ArchiveEntry entry, boolean autoStart) throws DeploymentException {
        try {
            DeploymentListener[] listeners = (DeploymentListener[])this.container.getListeners(DeploymentListener.class);
            DeploymentEvent event = new DeploymentEvent(new File(location), 1);
            for (int i = 0; i < listeners.length; ++i) {
                if (!listeners[i].fileChanged(event)) continue;
                return;
            }
        }
        catch (IOException e) {
            throw this.failure("deploy", "Error when deploying: " + location, e);
        }
        File tmpDir = null;
        try {
            tmpDir = AutoDeploymentService.unpackLocation(this.environmentContext.getTmpDir(), location);
        }
        catch (Exception e) {
            throw this.failure("deploy", "Unable to unpack archive: " + location, e);
        }
        if (tmpDir == null) {
            throw this.failure("deploy", "Unable to find jbi descriptor: " + location);
        }
        Descriptor root = null;
        try {
            root = DescriptorFactory.buildDescriptor(tmpDir);
        }
        catch (Exception e) {
            throw this.failure("deploy", "Unable to build jbi descriptor: " + location, e);
        }
        if (root == null) {
            throw this.failure("deploy", "Unable to find jbi descriptor: " + location);
        }
        if (root != null) {
            if (root.getComponent() != null) {
                this.updateComponent(entry, autoStart, tmpDir, root);
            } else if (root.getSharedLibrary() != null) {
                this.updateSharedLibrary(entry, tmpDir, root);
            } else if (root.getServiceAssembly() != null) {
                this.updateServiceAssembly(entry, autoStart, tmpDir, root);
            }
        }
    }

    protected void updateComponent(ArchiveEntry entry, boolean autoStart, File tmpDir, Descriptor root) throws DeploymentException {
        Component comp = root.getComponent();
        String componentName = comp.getIdentification().getName();
        entry.type = "component";
        entry.name = componentName;
        try {
            if (this.container.getRegistry().getComponent(componentName) != null) {
                this.installationService.loadInstaller(componentName);
                this.installationService.unloadInstaller(componentName, true);
            }
            entry.dependencies = this.getSharedLibraryNames(comp);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Component dependencies: " + entry.dependencies));
            }
            String missings = null;
            boolean canInstall = true;
            for (String libraryName : entry.dependencies) {
                if (this.container.getRegistry().getSharedLibrary(libraryName) != null) continue;
                canInstall = false;
                if (missings != null) {
                    missings = missings + ", " + libraryName;
                    continue;
                }
                missings = libraryName;
            }
            if (canInstall) {
                this.installationService.install(tmpDir, null, root, autoStart);
                this.checkPendingSAs();
            } else {
                entry.pending = true;
                LOG.warn((Object)("Shared libraries " + missings + " are not installed yet: the component " + componentName + " installation is suspended and will be resumed once the listed shared libraries are installed"));
                this.pendingComponents.put(tmpDir, entry);
            }
        }
        catch (Exception e) {
            String errStr = "Failed to update Component: " + componentName;
            LOG.error((Object)errStr, (Throwable)e);
            throw new DeploymentException(errStr, (Throwable)e);
        }
    }

    protected void updateSharedLibrary(ArchiveEntry entry, File tmpDir, Descriptor root) throws DeploymentException {
        String libraryName = root.getSharedLibrary().getIdentification().getName();
        entry.type = "library";
        entry.name = libraryName;
        try {
            if (this.container.getRegistry().getSharedLibrary(libraryName) != null) {
                this.container.getRegistry().unregisterSharedLibrary(libraryName);
                this.environmentContext.removeSharedLibraryDirectory(libraryName);
            }
            this.installationService.doInstallSharedLibrary(tmpDir, root.getSharedLibrary());
            this.checkPendingComponents();
        }
        catch (Exception e) {
            String errStr = "Failed to update SharedLibrary: " + libraryName;
            LOG.error((Object)errStr, (Throwable)e);
            throw new DeploymentException(errStr, (Throwable)e);
        }
    }

    protected void updateServiceAssembly(ArchiveEntry entry, boolean autoStart, File tmpDir, Descriptor root) throws DeploymentException {
        ServiceAssembly sa = root.getServiceAssembly();
        String name = sa.getIdentification().getName();
        entry.type = "assembly";
        entry.name = name;
        try {
            if (this.deploymentService.isSaDeployed(name)) {
                this.deploymentService.shutDown(name);
                this.deploymentService.undeploy(name);
            }
            entry.dependencies = this.getComponentNames(sa);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SA dependencies: " + entry.dependencies));
            }
            String missings = null;
            boolean canDeploy = true;
            for (String componentName : entry.dependencies) {
                if (this.container.getComponent(componentName) != null) continue;
                canDeploy = false;
                if (missings != null) {
                    missings = missings + ", " + componentName;
                    continue;
                }
                missings = componentName;
            }
            if (canDeploy) {
                this.deploymentService.deployServiceAssembly(tmpDir, sa);
                if (autoStart) {
                    this.deploymentService.start(name);
                }
            } else {
                entry.pending = true;
                LOG.warn((Object)("Components " + missings + " are not installed yet: the service assembly " + name + " deployment is suspended and will be resumed once the listed components are installed"));
                this.pendingSAs.put(tmpDir, entry);
            }
        }
        catch (Exception e) {
            String errStr = "Failed to update Service Assembly: " + name;
            LOG.error((Object)errStr, (Throwable)e);
            throw new DeploymentException(errStr, (Throwable)e);
        }
    }

    protected DeploymentException failure(String task, String info) {
        return this.failure(task, info, null, null);
    }

    protected DeploymentException failure(String task, String info, Exception e) {
        return this.failure(task, info, e, null);
    }

    protected DeploymentException failure(String task, String info, Exception e, List componentResults) {
        ManagementSupport.Message msg = new ManagementSupport.Message();
        msg.setTask(task);
        msg.setResult("FAILED");
        msg.setType("ERROR");
        msg.setException(e);
        msg.setMessage(info);
        return new DeploymentException(ManagementSupport.createFrameworkMessage(msg, componentResults));
    }

    protected Set<String> getComponentNames(ServiceAssembly sa) {
        HashSet<String> names = new HashSet<String>();
        if (sa.getServiceUnits() != null && sa.getServiceUnits().length > 0) {
            for (int i = 0; i < sa.getServiceUnits().length; ++i) {
                names.add(sa.getServiceUnits()[i].getTarget().getComponentName());
            }
        }
        return names;
    }

    protected Set<String> getSharedLibraryNames(Component comp) {
        HashSet<String> names = new HashSet<String>();
        if (comp.getSharedLibraries() != null && comp.getSharedLibraries().length > 0) {
            for (int i = 0; i < comp.getSharedLibraries().length; ++i) {
                names.add(comp.getSharedLibraries()[i].getName());
            }
        }
        return names;
    }

    public void removeArchive(ArchiveEntry entry) throws DeploymentException {
        try {
            DeploymentListener[] listeners = (DeploymentListener[])this.container.getListeners(DeploymentListener.class);
            DeploymentEvent event = new DeploymentEvent(new File(entry.location), 2);
            for (int i = 0; i < listeners.length; ++i) {
                if (!listeners[i].fileRemoved(event)) continue;
                return;
            }
        }
        catch (IOException e) {
            throw this.failure("deploy", "Error when deploying: " + entry.location, e);
        }
        LOG.info((Object)("Attempting to remove archive at: " + entry.location));
        if ("component".equals(entry.type)) {
            LOG.info((Object)("Uninstalling component: " + entry.name));
            this.installationService.loadInstaller(entry.name);
            this.installationService.unloadInstaller(entry.name, true);
        }
        if ("library".equals(entry.type)) {
            LOG.info((Object)("Removing shared library: " + entry.name));
            this.installationService.uninstallSharedLibrary(entry.name);
        }
        if ("assembly".equals(entry.type)) {
            LOG.info((Object)("Undeploying service assembly " + entry.name));
            try {
                if (this.deploymentService.isSaDeployed(entry.name)) {
                    this.deploymentService.shutDown(entry.name);
                    this.deploymentService.undeploy(entry.name);
                }
            }
            catch (Exception e) {
                String errStr = "Failed to update service assembly: " + entry.name;
                LOG.error((Object)errStr, (Throwable)e);
                throw new DeploymentException(errStr, (Throwable)e);
            }
        }
    }

    private void checkPendingSAs() {
        ArchiveEntry entry;
        HashSet<File> deployedSas = new HashSet<File>();
        for (Map.Entry<File, ArchiveEntry> me : this.pendingSAs.entrySet()) {
            entry = me.getValue();
            boolean canDeploy = true;
            for (String componentName : entry.dependencies) {
                if (this.container.getComponent(componentName) != null) continue;
                canDeploy = false;
                break;
            }
            if (!canDeploy) continue;
            File tmp = me.getKey();
            deployedSas.add(tmp);
            try {
                Descriptor root = DescriptorFactory.buildDescriptor(tmp);
                this.deploymentService.deployServiceAssembly(tmp, root.getServiceAssembly());
                this.deploymentService.start(root.getServiceAssembly().getIdentification().getName());
            }
            catch (Exception e) {
                String errStr = "Failed to update Service Assembly: " + tmp.getName();
                LOG.error((Object)errStr, (Throwable)e);
            }
        }
        if (!deployedSas.isEmpty()) {
            for (File f : deployedSas) {
                entry = this.pendingSAs.remove(f);
                entry.pending = false;
            }
            this.persistState(this.environmentContext.getDeploymentDir(), this.deployFileMap);
            this.persistState(this.environmentContext.getInstallationDir(), this.installFileMap);
        }
    }

    private void checkPendingComponents() {
        ArchiveEntry entry;
        HashSet<File> installedComponents = new HashSet<File>();
        for (Map.Entry<File, ArchiveEntry> me : this.pendingComponents.entrySet()) {
            entry = me.getValue();
            boolean canInstall = true;
            for (String libraryName : entry.dependencies) {
                if (this.container.getRegistry().getSharedLibrary(libraryName) != null) continue;
                canInstall = false;
                break;
            }
            if (!canInstall) continue;
            File tmp = me.getKey();
            installedComponents.add(tmp);
            try {
                Descriptor root = DescriptorFactory.buildDescriptor(tmp);
                this.installationService.install(tmp, null, root, true);
            }
            catch (Exception e) {
                String errStr = "Failed to update Component: " + tmp.getName();
                LOG.error((Object)errStr, (Throwable)e);
            }
        }
        if (!installedComponents.isEmpty()) {
            for (File f : installedComponents) {
                entry = this.pendingComponents.remove(f);
                entry.pending = false;
            }
            this.persistState(this.environmentContext.getDeploymentDir(), this.deployFileMap);
            this.persistState(this.environmentContext.getInstallationDir(), this.installFileMap);
            this.checkPendingSAs();
        }
    }

    @Override
    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "monitorInstallationDirectory", "Periodically monitor the Installation directory");
        helper.addAttribute(this.getObjectToManage(), "monitorInterval", "Interval (secs) before monitoring");
        return AttributeInfoHelper.join(super.getAttributeInfos(), helper.getAttributeInfos());
    }

    protected static File unpackLocation(File tmpRoot, String location) throws DeploymentException {
        File tmpDir = null;
        File file = null;
        try {
            if (location.startsWith(filePrefix)) {
                String os = System.getProperty("os.name");
                if (os.startsWith("Windows")) {
                    location = location.replace('\\', '/');
                    location = location.replaceAll(" ", "%20");
                }
                URI uri = new URI(location);
                file = new File(uri);
            } else {
                file = new File(location);
            }
            if (file.isDirectory()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Deploying an exploded jar/zip, we will create a temporary jar for it.");
                }
                File newFile = new File(tmpRoot.getAbsolutePath() + "/exploded.jar");
                newFile.delete();
                FileUtil.zipDir((String)file.getAbsolutePath(), (String)newFile.getAbsolutePath());
                file = newFile;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Deployment will now work from " + file.getAbsolutePath()));
                }
            }
            if (!file.exists()) {
                try {
                    URL url = new URL(location);
                    String fileName = url.getFile();
                    if (fileName == null) {
                        throw new DeploymentException("Location: " + location + " is not an archive");
                    }
                    file = FileUtil.unpackArchive((URL)url, (File)tmpRoot);
                }
                catch (MalformedURLException e) {
                    throw new DeploymentException((Throwable)e);
                }
            }
            if (FileUtil.archiveContainsEntry((File)file, (String)"META-INF/jbi.xml")) {
                tmpDir = FileUtil.createUniqueDirectory((File)tmpRoot, (String)file.getName());
                FileUtil.unpackArchive((File)file, (File)tmpDir);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Unpacked archive " + location + " to " + tmpDir));
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
        catch (URISyntaxException ex) {
            throw new DeploymentException((Throwable)ex);
        }
        return tmpDir;
    }

    private void scheduleDirectoryTimer() {
        if (!this.container.isEmbedded() && (this.isMonitorInstallationDirectory() || this.isMonitorDeploymentDirectory())) {
            if (this.statsTimer == null) {
                this.statsTimer = new Timer(true);
            }
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
            this.timerTask = new TimerTask(){

                public void run() {
                    if (!AutoDeploymentService.this.isStarted()) {
                        return;
                    }
                    if (AutoDeploymentService.this.isMonitorInstallationDirectory()) {
                        AutoDeploymentService.this.monitorDirectory(AutoDeploymentService.this.environmentContext.getInstallationDir(), AutoDeploymentService.this.installFileMap);
                    }
                    if (AutoDeploymentService.this.isMonitorDeploymentDirectory()) {
                        AutoDeploymentService.this.monitorDirectory(AutoDeploymentService.this.environmentContext.getDeploymentDir(), AutoDeploymentService.this.deployFileMap);
                    }
                }
            };
            long interval = this.monitorInterval * 1000;
            this.statsTimer.scheduleAtFixedRate(this.timerTask, 0L, interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorDirectory(File root, Map<String, ArchiveEntry> fileMap) {
        ArrayList<String> tmpList = new ArrayList<String>();
        if (root != null && root.exists() && root.isDirectory()) {
            ArchiveEntry entry;
            File[] files = root.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    ArchiveEntry lastEntry;
                    File file = files[i];
                    tmpList.add(file.getName());
                    if (!this.isAllowedExtension(file.getName()) || !this.isAvailable(file) || (lastEntry = fileMap.get(file.getName())) != null && file.lastModified() <= lastEntry.lastModified.getTime()) continue;
                    try {
                        entry = new ArchiveEntry();
                        entry.location = file.getName();
                        entry.lastModified = new Date(file.lastModified());
                        fileMap.put(file.getName(), entry);
                        LOG.info((Object)("Directory: " + root.getName() + ": Archive changed: processing " + file.getName() + " ..."));
                        this.updateArchive(file.getAbsolutePath(), entry, true);
                        LOG.info((Object)("Directory: " + root.getName() + ": Finished installation of archive:  " + file.getName()));
                        continue;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Directory: " + root.getName() + ": Automatic install of " + file + " failed"), (Throwable)e);
                        continue;
                    }
                    finally {
                        this.persistState(root, fileMap);
                    }
                }
            }
            HashMap<String, ArchiveEntry> map = new HashMap<String, ArchiveEntry>(fileMap);
            for (String location : map.keySet()) {
                if (tmpList.contains(location)) continue;
                entry = fileMap.remove(location);
                try {
                    LOG.info((Object)("Location " + location + " no longer exists - removing ..."));
                    this.removeArchive(entry);
                }
                catch (DeploymentException e) {
                    LOG.error((Object)("Failed to removeArchive: " + location), (Throwable)e);
                }
            }
            if (!((Object)map).equals(fileMap)) {
                this.persistState(root, fileMap);
            }
        }
    }

    private boolean isAvailable(File file) {
        if (!FileUtil.isFileFullyAvailable((File)file)) {
            LOG.warn((Object)("File is still being copied, deployment deferred to next cycle: " + file.getName()));
            return false;
        }
        try {
            ZipFile zip = new ZipFile(file);
            zip.size();
            zip.close();
        }
        catch (IOException e) {
            LOG.warn((Object)("Unable to open deployment file, deployment deferred to next cycle: " + file.getName()));
            return false;
        }
        return true;
    }

    private boolean isAllowedExtension(String file) {
        String[] ext = this.extensions.split(",");
        for (int i = 0; i < ext.length; ++i) {
            if (!file.endsWith(ext[i])) continue;
            return true;
        }
        return false;
    }

    private void persistState(File root, Map<String, ArchiveEntry> map) {
        try {
            File file = new File(this.environmentContext.getJbiRootDir(), root.getName() + ".xml");
            XmlPersistenceSupport.write(file, map);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to persist file state to: " + root), (Throwable)e);
        }
    }

    private Map<String, ArchiveEntry> readState(File root) {
        Map<String, ArchiveEntry> result = new HashMap<String, ArchiveEntry>();
        try {
            File file = new File(this.environmentContext.getJbiRootDir(), root.getName() + ".xml");
            if (file.exists()) {
                result = (Map)XmlPersistenceSupport.read(file);
            } else {
                LOG.debug((Object)("State file doesn't exist: " + file.getPath()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to read file state from: " + root), (Throwable)e);
        }
        return result;
    }

    private void initializeFileMaps() {
        if (this.isMonitorInstallationDirectory() && !this.container.isEmbedded()) {
            try {
                this.installFileMap = this.readState(this.environmentContext.getInstallationDir());
                this.removePendingEntries(this.installFileMap);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to read installed state", (Throwable)e);
            }
        }
        if (this.isMonitorDeploymentDirectory() && !this.container.isEmbedded()) {
            try {
                this.deployFileMap = this.readState(this.environmentContext.getDeploymentDir());
                this.removePendingEntries(this.deployFileMap);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to read deployed state", (Throwable)e);
            }
        }
    }

    private void removePendingEntries(Map<String, ArchiveEntry> map) {
        HashSet<String> pendings = new HashSet<String>();
        for (Map.Entry<String, ArchiveEntry> e : map.entrySet()) {
            if (!e.getValue().pending) continue;
            pendings.add(e.getKey());
        }
        for (String s : pendings) {
            map.remove(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArchiveEntry {
        private String location;
        private Date lastModified;
        private String type;
        private String name;
        private boolean pending;
        private transient Set<String> dependencies;

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public Date getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(Date lastModified) {
            this.lastModified = lastModified;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isPending() {
            return this.pending;
        }

        public void setPending(boolean pending) {
            this.pending = pending;
        }

        public Set<String> getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(Set<String> dependencies) {
            this.dependencies = dependencies;
        }
    }
}

