/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.security.keystore.impl;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.security.keystore.KeystoreInstance;
import org.apache.servicemix.jbi.security.keystore.KeystoreIsLocked;
import org.apache.servicemix.jbi.security.keystore.KeystoreManager;

public class BaseKeystoreManager
implements KeystoreManager {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected KeystoreInstance[] keystores;

    public KeystoreInstance[] getKeystores() {
        return this.keystores;
    }

    public void setKeystores(KeystoreInstance[] keystores) {
        this.keystores = keystores;
    }

    public SSLSocketFactory createSSLFactory(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore) throws GeneralSecurityException {
        KeystoreInstance trustInstance;
        KeystoreInstance keyInstance = null;
        if (keyStore != null) {
            keyInstance = this.getKeystore(keyStore);
            if (keyInstance.isKeystoreLocked()) {
                throw new KeystoreIsLocked("Keystore '" + keyStore + "' is locked; please use the keystore page in the admin console to unlock it");
            }
            if (keyInstance.isKeyLocked(keyAlias)) {
                throw new KeystoreIsLocked("Key '" + keyAlias + "' in keystore '" + keyStore + "' is locked; please use the keystore page in the admin console to unlock it");
            }
        }
        KeystoreInstance keystoreInstance = trustInstance = trustStore == null ? null : this.getKeystore(trustStore);
        if (trustInstance != null && trustInstance.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + trustStore + "' is locked; please use the keystore page in the admin console to unlock it");
        }
        try {
            SSLContext context = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
            context.init(keyInstance == null ? null : keyInstance.getKeyManager(algorithm, keyAlias), trustInstance == null ? null : trustInstance.getTrustManager(algorithm), new SecureRandom());
            return context.getSocketFactory();
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to dynamically load", (Throwable)e);
            return null;
        }
    }

    public SSLServerSocketFactory createSSLServerFactory(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore) throws GeneralSecurityException {
        KeystoreInstance trustInstance;
        KeystoreInstance keyInstance = this.getKeystore(keyStore);
        if (keyInstance.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + keyStore + "' is locked; please use the keystore page in the admin console to unlock it");
        }
        if (keyInstance.isKeyLocked(keyAlias)) {
            throw new KeystoreIsLocked("Key '" + keyAlias + "' in keystore '" + keyStore + "' is locked; please use the keystore page in the admin console to unlock it");
        }
        KeystoreInstance keystoreInstance = trustInstance = trustStore == null ? null : this.getKeystore(trustStore);
        if (trustInstance != null && trustInstance.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + trustStore + "' is locked; please use the keystore page in the admin console to unlock it");
        }
        try {
            SSLContext context = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
            context.init(keyInstance == null ? null : keyInstance.getKeyManager(algorithm, keyAlias), trustInstance == null ? null : trustInstance.getTrustManager(algorithm), new SecureRandom());
            return context.getServerSocketFactory();
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to dynamically load", (Throwable)e);
            return null;
        }
    }

    public KeystoreInstance getKeystore(String name) {
        if (this.keystores != null) {
            for (int i = 0; i < this.keystores.length; ++i) {
                if (!name.equals(this.keystores[i].getName())) continue;
                return this.keystores[i];
            }
        }
        return null;
    }
}

