/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.audit.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.servicemix.jbi.audit.lucene.LuceneCallback;

public class LuceneIndexer {
    protected Directory directory;
    private File segmentFile;

    public Directory getDirectory() {
        return this.directory;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public void setDirectoryName(File directoryName) throws IOException {
        this.segmentFile = new File(directoryName, "segments");
        this.directory = FSDirectory.getDirectory((String)directoryName.toString(), (!this.segmentFile.exists() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(String id) throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            IndexReader ir = IndexReader.open((Directory)this.directory);
            try {
                ir.delete(new Term("org.apache.servicemix.exchangeid", id));
            }
            finally {
                ir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(String[] ids) throws IOException {
        if (ids != null && ids.length > 0) {
            Directory directory = this.directory;
            synchronized (directory) {
                IndexReader ir = IndexReader.open((Directory)this.directory);
                try {
                    for (int i = 0; i < ids.length; ++i) {
                        ir.delete(new Term("org.apache.servicemix.exchangeid", ids[i]));
                    }
                }
                finally {
                    ir.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Document lucDoc, String id) throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            IndexWriter writer = new IndexWriter(this.directory, (Analyzer)new SimpleAnalyzer(), !this.segmentFile.exists());
            try {
                writer.addDocument(lucDoc);
            }
            finally {
                writer.close();
            }
        }
    }

    public void update(Document lucDoc, String id) throws IOException {
        this.remove(id);
        this.add(lucDoc, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object search(LuceneCallback lc) throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            Object object;
            IndexReader ir = IndexReader.open((Directory)this.directory);
            IndexSearcher is = new IndexSearcher(ir);
            try {
                object = lc.doCallback(is);
            }
            catch (Throwable throwable) {
                is.close();
                ir.close();
                throw throwable;
            }
            is.close();
            ir.close();
            return object;
        }
    }
}

