/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.drools.dsl;

import org.apache.servicemix.components.drools.dsl.JaxenCondition;
import org.apache.servicemix.expression.JaxenXPathExpression;
import org.drools.rule.Rule;
import org.drools.smf.ConditionFactory;
import org.drools.smf.Configuration;
import org.drools.smf.FactoryException;
import org.drools.spi.Condition;
import org.drools.spi.RuleBaseContext;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class JaxenConditionFactory
implements ConditionFactory {
    public Condition[] newCondition(Rule rule, RuleBaseContext ruleBaseContext, Configuration configuration) throws FactoryException {
        String text = configuration.getText();
        if (text == null) {
            throw new FactoryException("No XPath provided!");
        }
        try {
            JaxenXPathExpression expression = new JaxenXPathExpression();
            expression.setXpath(text);
            expression.setNamespaceContext(this.createNamespaceContext(configuration));
            expression.afterPropertiesSet();
            return new Condition[]{new JaxenCondition(rule, expression)};
        }
        catch (Exception e) {
            throw new FactoryException((Throwable)e);
        }
    }

    protected NamespaceContext createNamespaceContext(Configuration configuration) {
        SimpleNamespaceContext answer = new SimpleNamespaceContext();
        String[] names = configuration.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name.equals("xmlns")) {
                answer.addNamespace("", configuration.getAttribute(name));
                continue;
            }
            if (!name.startsWith("xmlns:")) continue;
            String prefix = name.substring(6);
            String uri = configuration.getAttribute(name);
            answer.addNamespace(prefix, uri);
        }
        return answer;
    }
}

