/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.email;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.email.MailMarshalerSupport;
import org.apache.servicemix.components.email.MimeMailPoller;
import org.apache.servicemix.jbi.jaxp.StringSource;

public class MimeMailMarshaler
extends MailMarshalerSupport {
    private static Log log = LogFactory.getLog(MimeMailPoller.class);

    public void prepareExchange(MessageExchange exchange, NormalizedMessage normalizedMessage, MimeMessage mimeMessage) throws javax.mail.MessagingException {
        String html;
        String text;
        String sentDate;
        String replyTo;
        String cc;
        String to;
        String from;
        block13: {
            from = InternetAddress.toString((Address[])mimeMessage.getFrom());
            to = InternetAddress.toString((Address[])mimeMessage.getRecipients(Message.RecipientType.TO));
            cc = InternetAddress.toString((Address[])mimeMessage.getRecipients(Message.RecipientType.CC));
            replyTo = InternetAddress.toString((Address[])mimeMessage.getReplyTo());
            sentDate = this.getDateFormat().format(mimeMessage.getSentDate());
            text = null;
            html = null;
            MimeMultipart mp = null;
            Object content = null;
            Object subContent = null;
            MimeMultipart subMP = null;
            try {
                content = mimeMessage.getContent();
                if (content instanceof String) {
                    text = this.asString(content);
                    break block13;
                }
                if (content instanceof MimeMultipart) {
                    mp = (MimeMultipart)content;
                    int nbMP = mp.getCount();
                    for (int i = 0; i < nbMP; ++i) {
                        BodyPart part = mp.getBodyPart(i);
                        String disposition = part.getDisposition();
                        if (disposition != null && (disposition.equals("attachment") || disposition.equals("inline"))) {
                            DataHandler att = part.getDataHandler();
                            normalizedMessage.addAttachment(att.getName(), att);
                            continue;
                        }
                        MimeBodyPart mbp = (MimeBodyPart)part;
                        if (mbp.isMimeType("text/plain")) {
                            text = (String)mbp.getContent();
                            continue;
                        }
                        if (mbp.isMimeType("text/html")) {
                            html = (String)mbp.getContent();
                            continue;
                        }
                        if (mbp.isMimeType("multipart/related")) {
                            subContent = mbp.getContent();
                            if (!(subContent instanceof MimeMultipart)) continue;
                            subMP = (MimeMultipart)subContent;
                            int nbsubMP = subMP.getCount();
                            for (int j = 0; j < nbsubMP; ++j) {
                                MimeBodyPart subMBP = (MimeBodyPart)part;
                                normalizedMessage.setProperty("org.apache.servicemix.email.alternativeContent" + j, subMBP.getContent());
                            }
                            continue;
                        }
                        log.warn((Object)"Some mail contents can not be traited and is not include into message");
                    }
                    break block13;
                }
                log.warn((Object)"Some mail contents can not be traited and is not include into message");
            }
            catch (MessagingException e) {
                throw new javax.mail.MessagingException("Error while setting content on normalized message", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new javax.mail.MessagingException("Error while fetching content", (Exception)e);
            }
        }
        normalizedMessage.setProperty("org.apache.servicemix.email.from", (Object)from);
        normalizedMessage.setProperty("org.apache.servicemix.email.to", (Object)to);
        normalizedMessage.setProperty("org.apache.servicemix.email.cc", (Object)cc);
        normalizedMessage.setProperty("org.apache.servicemix.email.text", (Object)text);
        normalizedMessage.setProperty("org.apache.servicemix.email.replyTo", (Object)replyTo);
        normalizedMessage.setProperty("org.apache.servicemix.email.sentDate", (Object)sentDate);
        normalizedMessage.setProperty("org.apache.servicemix.email.html", html);
        try {
            normalizedMessage.setContent((Source)new StringSource(text));
        }
        catch (MessagingException e) {
            throw new javax.mail.MessagingException("Error while setting content on normalized message", (Exception)((Object)e));
        }
    }

    public void prepareMessage(MimeMessage mimeMessage, MessageExchange exchange, NormalizedMessage normalizedMessage) throws javax.mail.MessagingException {
        try {
            Set attNames;
            Iterator itAttNames;
            HashMap attachments;
            Address[] replyTo;
            Date sentDate;
            Address from;
            Address[] bcc;
            Address[] cc;
            Address[] to = this.getTo(exchange, normalizedMessage);
            if (to != null) {
                mimeMessage.setRecipients(Message.RecipientType.TO, to);
            }
            if ((cc = this.getCc(exchange, normalizedMessage)) != null) {
                mimeMessage.setRecipients(Message.RecipientType.CC, cc);
            }
            if ((bcc = this.getBcc(exchange, normalizedMessage)) != null) {
                mimeMessage.setRecipients(Message.RecipientType.BCC, bcc);
            }
            if ((from = this.getFrom(exchange, normalizedMessage)) != null) {
                mimeMessage.setFrom(from);
            }
            String text = this.getText(exchange, normalizedMessage);
            String html = this.getHtml(exchange, normalizedMessage);
            if (text != null && html == null) {
                mimeMessage.setText(text);
            } else if (text != null && html != null) {
                MimeMultipart content = new MimeMultipart("alternative");
                MimeBodyPart textBodyPart = new MimeBodyPart();
                MimeBodyPart htmlBodyPart = new MimeBodyPart();
                textBodyPart.setText(text);
                htmlBodyPart.setContent((Object)html, "text/html");
                content.addBodyPart((BodyPart)textBodyPart);
                content.addBodyPart((BodyPart)htmlBodyPart);
                mimeMessage.setContent((Multipart)content);
            }
            String subject = this.getSubject(exchange, normalizedMessage);
            if (subject != null) {
                mimeMessage.setSubject(subject);
            }
            if ((sentDate = this.getSentDate(exchange, normalizedMessage)) != null) {
                mimeMessage.setSentDate(sentDate);
            }
            if ((replyTo = this.getReplyTo(exchange, normalizedMessage)) != null) {
                mimeMessage.setReplyTo(replyTo);
            }
            if ((attachments = this.getAttachments(exchange, normalizedMessage)) != null && (itAttNames = (attNames = attachments.keySet()).iterator()).hasNext()) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setText(text);
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)messageBodyPart);
                while (itAttNames.hasNext()) {
                    String oneAttachmentName = (String)itAttNames.next();
                    messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)attachments.get(oneAttachmentName)));
                    messageBodyPart.setFileName(oneAttachmentName);
                    messageBodyPart.setDisposition("attachment");
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
                mimeMessage.setContent((Multipart)multipart);
            }
        }
        catch (MessagingException e) {
            throw new javax.mail.MessagingException(e.getMessage(), (Exception)((Object)e));
        }
        catch (TransformerException e) {
            throw new javax.mail.MessagingException(e.getMessage(), (Exception)e);
        }
    }

    protected Address getFrom(MessageExchange exchange, NormalizedMessage normalizedMessage) throws MessagingException, AddressException {
        return this.asAddress(this.getFrom().evaluate(exchange, normalizedMessage));
    }

    protected Address[] getTo(MessageExchange exchange, NormalizedMessage normalizedMessage) throws MessagingException, AddressException {
        return this.asAddressArray(this.getTo().evaluate(exchange, normalizedMessage));
    }

    protected Address[] getCc(MessageExchange exchange, NormalizedMessage normalizedMessage) throws MessagingException, AddressException {
        return this.asAddressArray(this.getCc().evaluate(exchange, normalizedMessage));
    }

    protected Address[] getBcc(MessageExchange exchange, NormalizedMessage normalizedMessage) throws MessagingException, AddressException {
        return this.asAddressArray(this.getBcc().evaluate(exchange, normalizedMessage));
    }

    protected Address[] getReplyTo(MessageExchange exchange, NormalizedMessage normalizedMessage) throws MessagingException, AddressException {
        return this.asAddressArray(this.getReplyTo().evaluate(exchange, normalizedMessage));
    }

    protected HashMap getAttachments(MessageExchange exchange, NormalizedMessage normalizedMessage) {
        HashMap<String, Object> attachments = new HashMap<String, Object>();
        String filePath = "";
        String oneAttachmentName2 = "";
        try {
            StringTokenizer st;
            String listAttachment = (String)this.getAttachments().evaluate(exchange, normalizedMessage);
            if (StringUtils.isNotBlank((String)listAttachment) && (st = new StringTokenizer(listAttachment, ",")) != null) {
                while (st.hasMoreTokens()) {
                    filePath = st.nextToken();
                    File file = new File(filePath);
                    attachments.put(file.getName(), new FileDataSource(file));
                }
            }
        }
        catch (MessagingException e) {
            log.warn((Object)("file not found for attachment : " + e.getMessage() + " : " + filePath));
        }
        Set attNames = normalizedMessage.getAttachmentNames();
        for (String oneAttachmentName2 : attNames) {
            DataSource oneAttchmentInputString = normalizedMessage.getAttachment(oneAttachmentName2).getDataSource();
            attachments.put(oneAttachmentName2, oneAttchmentInputString);
        }
        return attachments;
    }
}

