/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.components.util.PollingComponentSupport;
import org.apache.servicemix.jbi.util.FileUtil;

public class FilePoller
extends PollingComponentSupport {
    private static final Log log = LogFactory.getLog(FilePoller.class);
    private File archive;
    private File file;
    private FileFilter filter;
    private boolean deleteFile = true;
    private boolean recursive = true;
    private boolean autoCreateDirectory = true;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private Set workingSet = new CopyOnWriteArraySet();

    public void poll() throws Exception {
        this.pollFileOrDirectory(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public boolean isDeleteFile() {
        return this.deleteFile;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isAutoCreateDirectory() {
        return this.autoCreateDirectory;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public File getArchive() {
        return this.archive;
    }

    public void setArchive(File archive) {
        this.archive = archive;
    }

    public Set getWorkingSet() {
        return this.workingSet;
    }

    protected void init() throws JBIException {
        if (this.file == null) {
            throw new IllegalArgumentException("You must specify a file property");
        }
        if (this.isAutoCreateDirectory() && !this.file.exists()) {
            this.file.mkdirs();
        }
        if (this.archive != null) {
            if (!this.deleteFile) {
                throw new DeploymentException("Archive shouldn't be specified unless deleteFile='true'");
            }
            if (this.isAutoCreateDirectory() && !this.archive.exists()) {
                this.archive.mkdirs();
            }
            if (!this.archive.isDirectory()) {
                throw new DeploymentException("Archive should refer to a directory");
            }
        }
        super.init();
    }

    protected void pollFileOrDirectory(File fileOrDirectory) {
        this.pollFileOrDirectory(fileOrDirectory, true);
    }

    protected void pollFileOrDirectory(File fileOrDirectory, boolean processDir) {
        if (!fileOrDirectory.isDirectory()) {
            this.pollFile(fileOrDirectory);
        } else if (processDir) {
            log.debug((Object)("Polling directory " + fileOrDirectory));
            File[] files = fileOrDirectory.listFiles(this.getFilter());
            for (int i = 0; i < files.length; ++i) {
                this.pollFileOrDirectory(files[i], this.isRecursive());
            }
        } else {
            log.debug((Object)("Skipping directory " + fileOrDirectory));
        }
    }

    protected void pollFile(final File aFile) {
        if (this.workingSet.add(aFile)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scheduling file " + aFile + " for processing"));
            }
            this.getExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        FilePoller.this.processFileAndDelete(aFile);
                    }
                    finally {
                        FilePoller.this.workingSet.remove(aFile);
                    }
                }
            });
        }
    }

    protected void processFileAndDelete(File aFile) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing file " + aFile));
            }
            if (aFile.exists()) {
                this.processFile(aFile);
                if (this.isDeleteFile()) {
                    if (this.archive != null) {
                        FileUtil.moveFile((File)aFile, (File)this.archive);
                    } else if (!aFile.delete()) {
                        throw new IOException("Could not delete file " + aFile);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to process file: " + aFile + ". Reason: " + e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(File aFile) throws Exception {
        InputStream in = null;
        try {
            String name = aFile.getCanonicalPath();
            in = new BufferedInputStream(new FileInputStream(aFile));
            InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
            NormalizedMessage message = exchange.createMessage();
            exchange.setInMessage(message);
            this.marshaler.readMessage((MessageExchange)exchange, message, in, name);
            this.getDeliveryChannel().sendSync((MessageExchange)exchange);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

