/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.http.HttpClientMarshaler;
import org.apache.servicemix.components.http.InvalidStatusResponseException;
import org.apache.servicemix.components.util.TransformComponentSupport;
import org.mortbay.resource.Resource;
import org.springframework.core.io.ClassPathResource;

public class HttpsInvoker
extends TransformComponentSupport
implements MessageExchangeListener {
    protected HttpClientMarshaler marshaler = new HttpClientMarshaler();
    protected MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    protected HttpClient httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
    protected HostConfiguration hostConfiguration = new HostConfiguration();
    protected String url;
    protected boolean defaultInOut = true;
    private String keyPassword;
    private String keyStore;
    private String keyStorePassword;
    private String keyStoreType = "JKS";
    private String trustStore;
    private String trustStorePassword;
    private String trustStoreType = "JKS";
    private String protocol = "TLS";
    private String algorithm = "SunX509";

    protected void init() throws JBIException {
        super.init();
        try {
            URI uri = new URI(this.url);
            CommonsHttpSSLSocketFactory sf = new CommonsHttpSSLSocketFactory();
            Protocol protocol = new Protocol("https", (ProtocolSocketFactory)sf, 443);
            HttpHost host = new HttpHost(uri.getHost(), uri.getPort(), protocol);
            this.hostConfiguration.setHost(host);
        }
        catch (Exception e) {
            throw new JBIException("Unable to initialize HttpsInvoker", (Throwable)e);
        }
    }

    public void stop() throws JBIException {
        super.stop();
        this.connectionManager.shutdown();
    }

    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        String url;
        try {
            URI uri = new URI(this.url);
            uri = uri.relativize(new URI(this.hostConfiguration.getHostURL()));
            url = uri.toString();
        }
        catch (Exception e1) {
            url = this.url;
        }
        PostMethod method = new PostMethod(url);
        try {
            int response;
            this.marshaler.fromNMS(method, exchange, in);
            if (method.getRequestHeader("Content-Type") == null) {
                method.setRequestHeader("Content-Type", "text/html; charset=UTF-8");
            }
            if ((response = this.httpClient.executeMethod(this.hostConfiguration, (HttpMethod)method)) != 200 && response != 202) {
                throw new InvalidStatusResponseException(response);
            }
            if (this.defaultInOut) {
                this.marshaler.toNMS(out, (HttpMethod)method);
            }
            boolean bl = this.defaultInOut;
            return bl;
        }
        catch (Exception e) {
            throw new MessagingException("Error executing http request", (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isDefaultInOut() {
        return this.defaultInOut;
    }

    public void setDefaultInOut(boolean defaultInOut) {
        this.defaultInOut = defaultInOut;
    }

    public HttpClientMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(HttpClientMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    private class CommonsHttpSSLSocketFactory
    implements SecureProtocolSocketFactory {
        private SSLSocketFactory factory;

        public CommonsHttpSSLSocketFactory() throws Exception {
            URL url;
            String res;
            SSLContext context = SSLContext.getInstance(HttpsInvoker.this.protocol);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(HttpsInvoker.this.algorithm);
            if (HttpsInvoker.this.keyStore == null) {
                HttpsInvoker.this.keyStore = System.getProperty("javax.net.ssl.keyStore");
                if (HttpsInvoker.this.keyStore == null) {
                    throw new IllegalArgumentException("keyStore or system property javax.net.ssl.keyStore must be set");
                }
            }
            if (HttpsInvoker.this.keyStore.startsWith("classpath:")) {
                try {
                    res = HttpsInvoker.this.keyStore.substring(10);
                    url = new ClassPathResource(res).getURL();
                    HttpsInvoker.this.keyStore = url.toString();
                }
                catch (IOException e) {
                    throw new JBIException("Unable to find keyStore " + HttpsInvoker.this.keyStore, (Throwable)e);
                }
            }
            if (HttpsInvoker.this.keyStorePassword == null) {
                HttpsInvoker.this.keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
                if (HttpsInvoker.this.keyStorePassword == null) {
                    throw new IllegalArgumentException("keyStorePassword or system property javax.net.ssl.keyStorePassword must be set");
                }
            }
            if (HttpsInvoker.this.trustStore == null) {
                HttpsInvoker.this.trustStore = System.getProperty("javax.net.ssl.trustStore");
            }
            if (HttpsInvoker.this.trustStore != null && HttpsInvoker.this.trustStore.startsWith("classpath:")) {
                try {
                    res = HttpsInvoker.this.trustStore.substring(10);
                    url = new ClassPathResource(res).getURL();
                    HttpsInvoker.this.trustStore = url.toString();
                }
                catch (IOException e) {
                    throw new JBIException("Unable to find trustStore " + HttpsInvoker.this.trustStore, (Throwable)e);
                }
            }
            if (HttpsInvoker.this.trustStorePassword == null) {
                HttpsInvoker.this.trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                if (HttpsInvoker.this.keyStorePassword == null) {
                    throw new IllegalArgumentException("trustStorePassword or system property javax.net.ssl.trustStorePassword must be set");
                }
            }
            KeyStore ks = KeyStore.getInstance(HttpsInvoker.this.keyStoreType);
            ks.load(Resource.newResource((String)HttpsInvoker.this.keyStore).getInputStream(), HttpsInvoker.this.keyStorePassword.toCharArray());
            keyManagerFactory.init(ks, HttpsInvoker.this.keyPassword != null ? HttpsInvoker.this.keyPassword.toCharArray() : HttpsInvoker.this.keyStorePassword.toCharArray());
            if (HttpsInvoker.this.trustStore != null) {
                KeyStore ts = KeyStore.getInstance(HttpsInvoker.this.trustStoreType);
                ts.load(Resource.newResource((String)HttpsInvoker.this.trustStore).getInputStream(), HttpsInvoker.this.trustStorePassword.toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(HttpsInvoker.this.algorithm);
                trustManagerFactory.init(ts);
                context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            } else {
                context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
            }
            this.factory = context.getSocketFactory();
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.factory.createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
            return this.factory.createSocket(host, port, localAddress, localPort);
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            if (params == null) {
                throw new IllegalArgumentException("Parameters may not be null");
            }
            int timeout = params.getConnectionTimeout();
            if (timeout == 0) {
                return this.createSocket(host, port, localAddress, localPort);
            }
            Socket socket = this.factory.createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            socket.bind(localaddr);
            socket.connect(remoteaddr, timeout);
            return socket;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.factory.createSocket(host, port);
        }
    }
}

