/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.saaj;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.saaj.SaajMarshaler;
import org.apache.servicemix.components.util.TransformComponentSupport;

public class SaajBinding
extends TransformComponentSupport
implements MessageExchangeListener {
    private static final transient Log log = LogFactory.getLog(SaajBinding.class);
    private SaajMarshaler marshaler = new SaajMarshaler();
    private SOAPConnectionFactory connectionFactory;
    private Object soapEndpoint;
    private String soapAction;

    public SOAPConnectionFactory getConnectionFactory() throws SOAPException {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(SOAPConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Object getSoapEndpoint() {
        return this.soapEndpoint;
    }

    public void setSoapEndpoint(Object soapEndpoint) {
        this.soapEndpoint = soapEndpoint;
    }

    public SaajMarshaler getMarshaller() {
        return this.marshaler;
    }

    public void setMarshaller(SaajMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public SaajMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(SaajMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        SOAPConnection connection = this.getConnectionFactory().createConnection();
        try {
            SOAPMessage response;
            SOAPMessage inMessage = this.marshaler.createSOAPMessage(in);
            MimeHeaders mh = inMessage.getMimeHeaders();
            if (mh.getHeader("SOAPAction") == null) {
                if (this.soapAction != null && this.soapAction.length() > 0) {
                    mh.addHeader("SOAPAction", this.soapAction);
                } else {
                    mh.addHeader("SOAPAction", "\"\"");
                }
                inMessage.saveChanges();
            }
            if (log.isDebugEnabled()) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                inMessage.writeTo((OutputStream)buffer);
                log.debug((Object)new String(buffer.toByteArray()));
            }
            if ((response = connection.call(inMessage, this.soapEndpoint)) != null) {
                this.marshaler.toNMS(out, response);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                connection.close();
            }
            catch (SOAPException e) {
                log.warn((Object)("Failed to close connection: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    protected SOAPConnectionFactory createConnectionFactory() throws SOAPException {
        return SOAPConnectionFactory.newInstance();
    }

    protected SOAPConnection createConnection() throws SOAPException {
        return this.getConnectionFactory().createConnection();
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }
}

