/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.script;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.namespace.QName;
import org.apache.servicemix.components.util.TransformComponentSupport;
import org.apache.servicemix.jbi.messaging.NormalizedMessageImpl;
import org.springframework.core.io.Resource;

public class ScriptComponent
extends TransformComponentSupport {
    public static final QName SERVICE = new QName("http://servicemix.org/example/", "receiver");
    public static final String ENDPOINT = "receiver";
    private ScriptEngine engine;
    private String scriptEngineName;
    private CompiledScript compiledScript;
    private String scriptText;
    private Resource script;
    private String logResourceBundle;
    private boolean disableOutput;
    private Logger scriptLogger;
    private Map bindings = new HashMap();

    public ScriptComponent() {
        super(SERVICE, ENDPOINT);
    }

    public ScriptComponent(QName service, String endpoint) {
        super(service, endpoint);
    }

    public void start() throws JBIException {
        if (this.engine == null) {
            if (this.compiledScript != null) {
                this.engine = this.compiledScript.getEngine();
            } else {
                if (this.scriptEngineName != null) {
                    this.engine = this.createScriptEngine();
                }
                if (this.engine == null) {
                    throw new JBIException("Must be configured with either the 'compiledScript' or 'engine' property");
                }
            }
        }
        if (this.compiledScript == null) {
            this.checkScriptTextAvailable();
        }
        if (this.compiledScript == null && this.engine instanceof Compilable) {
            Compilable compilable = (Compilable)((Object)this.engine);
            this.compileScript(compilable);
        }
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }

    public void setEngine(ScriptEngine engine) {
        this.engine = engine;
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.compiledScript = compiledScript;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    public Resource getScript() {
        return this.script;
    }

    public void setScript(Resource script) {
        this.script = script;
    }

    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    public void setScriptEngineName(String scriptEngineName) {
        this.scriptEngineName = scriptEngineName;
    }

    public boolean isDisableOutput() {
        return this.disableOutput;
    }

    public void setDisableOutput(boolean disableOutput) {
        this.disableOutput = disableOutput;
    }

    public String getLogResourceBundle() {
        return this.logResourceBundle;
    }

    public Map getBindings() {
        return this.bindings;
    }

    public void setBindings(Map bindings) {
        this.bindings = bindings;
    }

    public void setLogResourceBundle(String logResourceBundle) {
        this.logResourceBundle = logResourceBundle;
    }

    public Logger getScriptLogger() throws MessagingException {
        if (this.scriptLogger == null) {
            this.scriptLogger = this.createScriptLogger();
        }
        return this.scriptLogger;
    }

    public void setScriptLogger(Logger scriptLogger) {
        this.scriptLogger = scriptLogger;
    }

    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        Bindings bindings = this.engine.createBindings();
        this.populateBindings(bindings, exchange, in, out);
        try {
            this.runScript(bindings);
            return !this.isDisableOutput();
        }
        catch (ScriptException e) {
            throw new MessagingException("Failed to run compiledScript. Reason: " + e, (Throwable)e);
        }
    }

    protected void populateBindings(Bindings bindings, MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        bindings.put("componentContext", (Object)this.getContext());
        bindings.put("deliveryChannel", (Object)this.getDeliveryChannel());
        bindings.put("exchange", (Object)exchange);
        bindings.put("inMessage", (Object)in);
        bindings.put("log", (Object)this.getScriptLogger());
        bindings.put("componentNamespace", (Object)bindings);
        bindings.put("bindings", (Object)this.bindings);
        InOnly outExchange = null;
        if (this.isInAndOut(exchange)) {
            bindings.put("outMessage", (Object)out);
        } else if (!this.isDisableOutput()) {
            outExchange = this.getExchangeFactory().createInOnlyExchange();
            if (out instanceof NormalizedMessageImpl) {
                bindings.put("outExchange", (Object)((NormalizedMessageImpl)out).getExchange());
            }
            bindings.put("outMessage", (Object)out);
        }
    }

    protected Logger createScriptLogger() throws MessagingException {
        if (this.logResourceBundle != null) {
            try {
                return this.getContext().getLogger(((Object)((Object)this)).getClass().getName(), this.logResourceBundle);
            }
            catch (JBIException e) {
                throw new MessagingException((Throwable)e);
            }
        }
        return Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected void runScript(Bindings bindings) throws ScriptException {
        if (this.compiledScript != null) {
            this.compiledScript.eval(bindings);
        } else {
            this.evaluteScript(bindings);
        }
    }

    protected void evaluteScript(Bindings bindings) throws ScriptException {
        this.engine.eval(this.scriptText, bindings);
    }

    protected void compileScript(Compilable compilable) throws JBIException {
        try {
            if (this.scriptText != null) {
                this.compiledScript = compilable.compile(this.scriptText);
            } else if (this.script != null) {
                this.compiledScript = compilable.compile(new InputStreamReader(this.script.getInputStream()));
            }
        }
        catch (ScriptException e) {
            throw new JBIException("Failed to parse compiledScript. Reason:  " + e, (Throwable)e);
        }
        catch (IOException e) {
            throw new JBIException("Failed to parse compiledScript. Reason:  " + e, (Throwable)e);
        }
    }

    protected ScriptEngine createScriptEngine() {
        ScriptEngineManager manager = new ScriptEngineManager();
        return manager.getEngineByName(this.scriptEngineName);
    }

    protected void checkScriptTextAvailable() throws JBIException {
        if (this.scriptText == null && this.script == null) {
            throw new JBIException("If no 'compiledScript' is specified you must specify the 'scriptText' or 'script'");
        }
    }
}

