/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal;

import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.woden.ErrorHandler;
import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLSource;
import org.apache.woden.internal.BaseWSDLReader;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.schema.ImportedSchemaImpl;
import org.apache.woden.internal.schema.InlinedSchemaImpl;
import org.apache.woden.internal.schema.SchemaConstants;
import org.apache.woden.internal.util.StringUtils;
import org.apache.woden.internal.util.om.OMUtils;
import org.apache.woden.internal.util.om.QNameUtils;
import org.apache.woden.internal.wsdl20.Constants;
import org.apache.woden.schema.Schema;
import org.apache.woden.types.NCName;
import org.apache.woden.wsdl20.enumeration.Direction;
import org.apache.woden.wsdl20.enumeration.MessageLabel;
import org.apache.woden.wsdl20.extensions.ExtensionDeserializer;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;
import org.apache.woden.wsdl20.xml.BindingElement;
import org.apache.woden.wsdl20.xml.BindingFaultElement;
import org.apache.woden.wsdl20.xml.BindingFaultReferenceElement;
import org.apache.woden.wsdl20.xml.BindingMessageReferenceElement;
import org.apache.woden.wsdl20.xml.BindingOperationElement;
import org.apache.woden.wsdl20.xml.ConfigurableElement;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.DocumentableElement;
import org.apache.woden.wsdl20.xml.DocumentationElement;
import org.apache.woden.wsdl20.xml.EndpointElement;
import org.apache.woden.wsdl20.xml.FeatureElement;
import org.apache.woden.wsdl20.xml.ImportElement;
import org.apache.woden.wsdl20.xml.IncludeElement;
import org.apache.woden.wsdl20.xml.InterfaceElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceOperationElement;
import org.apache.woden.wsdl20.xml.PropertyElement;
import org.apache.woden.wsdl20.xml.ServiceElement;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.xml.sax.InputSource;

public class OMWSDLReader
extends BaseWSDLReader {
    private Map fImportedSchemas = new Hashtable();
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$DescriptionElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$DocumentationElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$TypesElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$ServiceElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$EndpointElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$BindingElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$BindingOperationElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$BindingFaultElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$InterfaceElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$InterfaceOperationElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$InterfaceFaultElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$PropertyElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$FeatureElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$ImportElement;
    static /* synthetic */ Class class$org$apache$woden$wsdl20$xml$IncludeElement;

    public DescriptionElement readWSDL(String string) throws WSDLException {
        try {
            URL uRL = StringUtils.getURL(null, string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = this.getErrorReporter().getFormattedMessage("WSDL502", new Object[]{null, string});
            throw new WSDLException("PARSER_ERROR", string2, malformedURLException);
        }
        int n = string.indexOf(58);
        String string3 = n != -1 ? string : "file://" + string;
        OMElement oMElement = OMUtils.getElement(string3);
        return this.parseDescription(string3, oMElement, null);
    }

    private DescriptionElement parseDescription(String string, OMElement oMElement, Map hashMap) throws WSDLException {
        String string2;
        Object object;
        this.checkElementName(oMElement, Constants.Q_ELEM_DESCRIPTION);
        DescriptionElement descriptionElement = this.getFactory().newDescription();
        if (hashMap == null) {
            hashMap = new HashMap<String, DescriptionElement>();
        }
        if (this.getExtensionRegistry() != null) {
            descriptionElement.setExtensionRegistry(this.getExtensionRegistry());
        }
        if (this.getErrorReporter() != null) {
            descriptionElement.getExtensionRegistry().setErrorReporter(this.getErrorReporter());
        }
        descriptionElement.setDocumentBaseURI(this.getURI(string));
        String string3 = OMUtils.getAttribute(oMElement, "targetNamespace");
        if (string3 != null) {
            descriptionElement.setTargetNamespace(this.getURI(string3));
        }
        Iterator iterator = oMElement.getAllDeclaredNamespaces();
        while (iterator.hasNext()) {
            object = (OMNamespace)iterator.next();
            string2 = object.getPrefix();
            String string4 = object.getNamespaceURI();
            if (!"xmlns".equals(string2)) {
                descriptionElement.addNamespace(string2, this.getURI(string4));
                continue;
            }
            descriptionElement.addNamespace(null, this.getURI(string4));
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$DescriptionElement == null ? (class$org$apache$woden$wsdl20$xml$DescriptionElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.DescriptionElement")) : class$org$apache$woden$wsdl20$xml$DescriptionElement, descriptionElement, descriptionElement);
        object = oMElement.getChildElements();
        while (object.hasNext()) {
            string2 = (OMElement)object.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (OMElement)string2)) {
                this.parseDocumentation((OMElement)string2, descriptionElement, descriptionElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_TYPES, (OMElement)string2)) {
                this.parseTypes((OMElement)string2, descriptionElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_INTERFACE, (OMElement)string2)) {
                this.parseInterface((OMElement)string2, descriptionElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_BINDING, (OMElement)string2)) {
                this.parseBinding((OMElement)string2, descriptionElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_SERVICE, (OMElement)string2)) {
                this.parseService((OMElement)string2, descriptionElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_IMPORT, (OMElement)string2)) {
                if (string != null && !hashMap.containsKey(string)) {
                    hashMap.put(string, descriptionElement);
                }
                this.parseImport((OMElement)string2, descriptionElement, hashMap);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_INCLUDE, (OMElement)string2)) {
                if (string != null && !hashMap.containsKey(string)) {
                    hashMap.put(string, descriptionElement);
                }
                this.parseInclude((OMElement)string2, descriptionElement, hashMap);
                continue;
            }
            descriptionElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$DescriptionElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.DescriptionElement") : class$org$apache$woden$wsdl20$xml$DescriptionElement, descriptionElement, (OMElement)string2, descriptionElement));
        }
        return descriptionElement;
    }

    private DocumentationElement parseDocumentation(OMElement oMElement, DescriptionElement descriptionElement, DocumentableElement documentableElement) throws WSDLException {
        DocumentationElement documentationElement = documentableElement.addDocumentationElement();
        documentationElement.setContent(oMElement.getText());
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$DocumentationElement == null ? (class$org$apache$woden$wsdl20$xml$DocumentationElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.DocumentationElement")) : class$org$apache$woden$wsdl20$xml$DocumentationElement, documentationElement, descriptionElement);
        Iterator iterator = oMElement.getChildElements();
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            documentationElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$DocumentationElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.DocumentationElement") : class$org$apache$woden$wsdl20$xml$DocumentationElement, documentationElement, oMElement2, descriptionElement));
        }
        return documentationElement;
    }

    private TypesElement parseTypes(OMElement oMElement, DescriptionElement descriptionElement) throws WSDLException {
        TypesElement typesElement = descriptionElement.getTypesElement();
        typesElement.setTypeSystem("http://www.w3.org/2001/XMLSchema");
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$TypesElement == null ? (class$org$apache$woden$wsdl20$xml$TypesElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.TypesElement")) : class$org$apache$woden$wsdl20$xml$TypesElement, typesElement, descriptionElement);
        OMElement oMElement2 = oMElement.getFirstElement();
        if (oMElement2 != null) {
            QName qName = QNameUtils.newQName(oMElement2);
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                this.parseDocumentation(oMElement2, descriptionElement, typesElement);
            } else if (SchemaConstants.XSD_IMPORT_QNAME_LIST.contains(oMElement2)) {
                typesElement.addSchema(this.parseSchemaImport(oMElement2, descriptionElement));
            } else if (SchemaConstants.XSD_SCHEMA_QNAME_LIST.contains(qName)) {
                typesElement.addSchema(this.parseSchemaInline(oMElement2, descriptionElement));
            } else {
                typesElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$TypesElement == null ? (class$org$apache$woden$wsdl20$xml$TypesElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.TypesElement")) : class$org$apache$woden$wsdl20$xml$TypesElement, typesElement, oMElement2, descriptionElement));
            }
        }
        return typesElement;
    }

    private ServiceElement parseService(OMElement oMElement, DescriptionElement descriptionElement) throws WSDLException {
        String string;
        ServiceElement serviceElement = descriptionElement.addServiceElement();
        String string2 = OMUtils.getAttribute(oMElement, "name");
        if (string2 != null) {
            serviceElement.setName(new NCName(string2));
        }
        if ((string = OMUtils.getAttribute(oMElement, "interface")) != null) {
            try {
                QName qName = OMUtils.getQName(string, oMElement);
                serviceElement.setInterfaceName(qName);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", oMElement.getLocalName(), (short)2);
            }
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$ServiceElement == null ? (class$org$apache$woden$wsdl20$xml$ServiceElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.ServiceElement")) : class$org$apache$woden$wsdl20$xml$ServiceElement, serviceElement, descriptionElement);
        Iterator iterator = oMElement.getChildElements();
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                this.parseDocumentation(oMElement2, descriptionElement, serviceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_ENDPOINT, oMElement2)) {
                this.parseEndpoint(oMElement2, descriptionElement, serviceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, oMElement2)) {
                this.parseFeature(oMElement2, descriptionElement, serviceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, oMElement2)) {
                this.parseProperty(oMElement2, descriptionElement, serviceElement);
                continue;
            }
            serviceElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$ServiceElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.ServiceElement") : class$org$apache$woden$wsdl20$xml$ServiceElement, serviceElement, oMElement2, descriptionElement));
        }
        return serviceElement;
    }

    private EndpointElement parseEndpoint(OMElement oMElement, DescriptionElement descriptionElement, ServiceElement serviceElement) throws WSDLException {
        String string;
        String string2;
        Object object;
        EndpointElement endpointElement = serviceElement.addEndpointElement();
        endpointElement.setParentElement(serviceElement);
        String string3 = OMUtils.getAttribute(oMElement, "name");
        if (string3 != null) {
            object = new NCName(string3);
            endpointElement.setName((NCName)object);
        }
        if ((string2 = OMUtils.getAttribute(oMElement, "binding")) != null) {
            try {
                object = OMUtils.getQName(string2, oMElement);
                endpointElement.setBindingName((QName)object);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string2, QNameUtils.newQName(oMElement)}, (short)2);
            }
        }
        if ((string = OMUtils.getAttribute(oMElement, "address")) != null) {
            endpointElement.setAddress(this.getURI(string));
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$EndpointElement == null ? (class$org$apache$woden$wsdl20$xml$EndpointElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.EndpointElement")) : class$org$apache$woden$wsdl20$xml$EndpointElement, endpointElement, descriptionElement);
        Iterator iterator = oMElement.getChildElements();
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                this.parseDocumentation(oMElement2, descriptionElement, endpointElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, oMElement2)) {
                this.parseFeature(oMElement2, descriptionElement, endpointElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, oMElement2)) {
                this.parseProperty(oMElement2, descriptionElement, endpointElement);
                continue;
            }
            endpointElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$ServiceElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.ServiceElement") : class$org$apache$woden$wsdl20$xml$ServiceElement, endpointElement, oMElement2, descriptionElement));
        }
        return endpointElement;
    }

    private BindingElement parseBinding(OMElement oMElement, DescriptionElement descriptionElement) throws WSDLException {
        String string;
        BindingElement bindingElement = descriptionElement.addBindingElement();
        String string2 = OMUtils.getAttribute(oMElement, "name");
        if (string2 != null) {
            bindingElement.setName(new NCName(string2));
        }
        QName qName = null;
        String string3 = OMUtils.getAttribute(oMElement, "interface");
        if (string3 != null) {
            try {
                qName = OMUtils.getQName(string3, oMElement);
                bindingElement.setInterfaceName(qName);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string3, QNameUtils.newQName(oMElement)}, (short)2);
            }
        }
        if ((string = OMUtils.getAttribute(oMElement, "type")) != null) {
            bindingElement.setType(this.getURI(string));
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$BindingElement == null ? (class$org$apache$woden$wsdl20$xml$BindingElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingElement")) : class$org$apache$woden$wsdl20$xml$BindingElement, bindingElement, descriptionElement);
        Iterator iterator = oMElement.getChildElements();
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                this.parseDocumentation(oMElement2, descriptionElement, bindingElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FAULT, oMElement2)) {
                this.parseBindingFault(oMElement2, descriptionElement, bindingElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_OPERATION, oMElement2)) {
                this.parseBindingOperation(oMElement2, descriptionElement, bindingElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, oMElement2)) {
                this.parseFeature(oMElement2, descriptionElement, bindingElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, oMElement2)) {
                this.parseProperty(oMElement2, descriptionElement, bindingElement);
                continue;
            }
            bindingElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingElement") : class$org$apache$woden$wsdl20$xml$BindingElement, bindingElement, oMElement2, descriptionElement));
        }
        return bindingElement;
    }

    private BindingOperationElement parseBindingOperation(OMElement oMElement, DescriptionElement descriptionElement, BindingElement bindingElement) throws WSDLException {
        BindingOperationElement bindingOperationElement = bindingElement.addBindingOperationElement();
        bindingOperationElement.setParentElement(bindingElement);
        QName qName = null;
        String string = OMUtils.getAttribute(oMElement, "ref");
        if (string != null) {
            try {
                qName = OMUtils.getQName(string, oMElement);
                bindingOperationElement.setRef(qName);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string, QNameUtils.newQName(oMElement)}, (short)2);
            }
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$BindingOperationElement == null ? (class$org$apache$woden$wsdl20$xml$BindingOperationElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingOperationElement")) : class$org$apache$woden$wsdl20$xml$BindingOperationElement, bindingOperationElement, descriptionElement);
        Iterator iterator = oMElement.getChildElements();
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                this.parseDocumentation(oMElement2, descriptionElement, bindingOperationElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, oMElement2)) {
                this.parseFeature(oMElement2, descriptionElement, bindingOperationElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, oMElement2)) {
                this.parseProperty(oMElement2, descriptionElement, bindingOperationElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_INPUT, oMElement2)) {
                this.parseBindingMessageReference(oMElement2, descriptionElement, bindingOperationElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_OUTPUT, oMElement2)) {
                this.parseBindingMessageReference(oMElement2, descriptionElement, bindingOperationElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_INFAULT, oMElement2)) {
                this.parseBindingFaultReference(oMElement2, descriptionElement, bindingOperationElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_OUTFAULT, oMElement2)) {
                this.parseBindingFaultReference(oMElement2, descriptionElement, bindingOperationElement);
                continue;
            }
            bindingOperationElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingOperationElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingOperationElement") : class$org$apache$woden$wsdl20$xml$BindingOperationElement, bindingOperationElement, oMElement2, descriptionElement));
        }
        return bindingOperationElement;
    }

    private BindingFaultReferenceElement parseBindingFaultReference(OMElement oMElement, DescriptionElement descriptionElement, BindingOperationElement bindingOperationElement) throws WSDLException {
        String string;
        BindingFaultReferenceElement bindingFaultReferenceElement = bindingOperationElement.addBindingFaultReferenceElement();
        bindingFaultReferenceElement.setParentElement(bindingOperationElement);
        QName qName = null;
        String string2 = OMUtils.getAttribute(oMElement, "ref");
        if (string2 != null) {
            try {
                qName = OMUtils.getQName(string2, oMElement);
                bindingFaultReferenceElement.setRef(qName);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string2, QNameUtils.newQName(oMElement)}, (short)2);
            }
        }
        if ((string = OMUtils.getAttribute(oMElement, "messageLabel")) != null) {
            if (string.equals(MessageLabel.IN.toString())) {
                bindingFaultReferenceElement.setMessageLabel(MessageLabel.IN);
            } else if (string.equals(MessageLabel.OUT.toString())) {
                bindingFaultReferenceElement.setMessageLabel(MessageLabel.OUT);
            } else {
                bindingFaultReferenceElement.setMessageLabel(MessageLabel.invalidValue(string));
            }
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement == null ? (class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingFaultReferenceElement")) : class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement, bindingFaultReferenceElement, descriptionElement);
        Iterator iterator = oMElement.getChildElements();
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                this.parseDocumentation(oMElement2, descriptionElement, bindingFaultReferenceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, oMElement2)) {
                this.parseFeature(oMElement2, descriptionElement, bindingFaultReferenceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, oMElement2)) {
                this.parseProperty(oMElement2, descriptionElement, bindingFaultReferenceElement);
                continue;
            }
            bindingFaultReferenceElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingFaultReferenceElement") : class$org$apache$woden$wsdl20$xml$BindingFaultReferenceElement, bindingFaultReferenceElement, oMElement2, descriptionElement));
        }
        return bindingFaultReferenceElement;
    }

    private BindingMessageReferenceElement parseBindingMessageReference(OMElement oMElement, DescriptionElement descriptionElement, BindingOperationElement bindingOperationElement) throws WSDLException {
        BindingMessageReferenceElement bindingMessageReferenceElement = bindingOperationElement.addBindingMessageReferenceElement();
        bindingMessageReferenceElement.setParentElement(bindingOperationElement);
        if ("input".equals(oMElement.getLocalName())) {
            bindingMessageReferenceElement.setDirection(Direction.IN);
        } else if ("output".equals(oMElement.getLocalName())) {
            bindingMessageReferenceElement.setDirection(Direction.OUT);
        }
        String string = OMUtils.getAttribute(oMElement, "messageLabel");
        if (string != null) {
            if (string.equals(MessageLabel.IN.toString())) {
                bindingMessageReferenceElement.setMessageLabel(MessageLabel.IN);
            } else if (string.equals(MessageLabel.OUT.toString())) {
                bindingMessageReferenceElement.setMessageLabel(MessageLabel.OUT);
            } else {
                bindingMessageReferenceElement.setMessageLabel(MessageLabel.invalidValue(string));
            }
        } else if (bindingMessageReferenceElement.getDirection().equals(Direction.IN)) {
            bindingMessageReferenceElement.setMessageLabel(MessageLabel.IN);
        } else {
            bindingMessageReferenceElement.setMessageLabel(MessageLabel.OUT);
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement == null ? (class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingMessageReferenceElement")) : class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement, bindingMessageReferenceElement, descriptionElement);
        Iterator iterator = oMElement.getChildElements();
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                this.parseDocumentation(oMElement2, descriptionElement, bindingMessageReferenceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, oMElement2)) {
                this.parseFeature(oMElement2, descriptionElement, bindingMessageReferenceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, oMElement2)) {
                this.parseProperty(oMElement2, descriptionElement, bindingMessageReferenceElement);
                continue;
            }
            bindingMessageReferenceElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingMessageReferenceElement") : class$org$apache$woden$wsdl20$xml$BindingMessageReferenceElement, bindingMessageReferenceElement, oMElement2, descriptionElement));
        }
        return bindingMessageReferenceElement;
    }

    private BindingFaultElement parseBindingFault(OMElement oMElement, DescriptionElement descriptionElement, BindingElement bindingElement) throws WSDLException {
        BindingFaultElement bindingFaultElement = bindingElement.addBindingFaultElement();
        bindingFaultElement.setParentElement(bindingElement);
        QName qName = null;
        String string = OMUtils.getAttribute(oMElement, "ref");
        if (string != null) {
            try {
                qName = OMUtils.getQName(string, oMElement);
                bindingFaultElement.setRef(qName);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string, QNameUtils.newQName(oMElement)}, (short)2);
            }
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$BindingFaultElement == null ? (class$org$apache$woden$wsdl20$xml$BindingFaultElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingFaultElement")) : class$org$apache$woden$wsdl20$xml$BindingFaultElement, bindingFaultElement, descriptionElement);
        Iterator iterator = oMElement.getChildElements();
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                this.parseDocumentation(oMElement2, descriptionElement, bindingFaultElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, oMElement2)) {
                this.parseFeature(oMElement2, descriptionElement, bindingFaultElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, oMElement2)) {
                this.parseProperty(oMElement2, descriptionElement, bindingFaultElement);
                continue;
            }
            bindingFaultElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$BindingFaultElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.BindingFaultElement") : class$org$apache$woden$wsdl20$xml$BindingFaultElement, bindingFaultElement, oMElement2, descriptionElement));
        }
        return bindingFaultElement;
    }

    private InterfaceElement parseInterface(OMElement oMElement, DescriptionElement descriptionElement) throws WSDLException {
        Object object;
        Object object2;
        Object object3;
        String string;
        InterfaceElement interfaceElement = descriptionElement.addInterfaceElement();
        String string2 = OMUtils.getAttribute(oMElement, "name");
        if (string2 != null) {
            interfaceElement.setName(new NCName(string2));
        }
        if ((string = OMUtils.getAttribute(oMElement, "styleDefault")) != null) {
            object3 = StringUtils.parseNMTokens(string);
            object2 = null;
            object = object3.iterator();
            while (object.hasNext()) {
                object2 = (String)object.next();
                interfaceElement.addStyleDefaultURI(this.getURI((String)object2));
            }
        }
        if ((object3 = OMUtils.getAttribute(oMElement, "extends")) != null) {
            object2 = StringUtils.parseNMTokens((String)object3);
            object = null;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                interfaceElement.addExtendedInterfaceName(OMUtils.getQName((String)object, oMElement));
            }
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$InterfaceElement == null ? (class$org$apache$woden$wsdl20$xml$InterfaceElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceElement")) : class$org$apache$woden$wsdl20$xml$InterfaceElement, interfaceElement, descriptionElement);
        object2 = oMElement.getChildElements();
        while (object2.hasNext()) {
            object = (OMElement)object2.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, (OMElement)object)) {
                this.parseDocumentation((OMElement)object, descriptionElement, interfaceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FAULT, (OMElement)object)) {
                this.parseInterfaceFault((OMElement)object, descriptionElement, interfaceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_OPERATION, (OMElement)object)) {
                this.parseInterfaceOperation((OMElement)object, descriptionElement, interfaceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, (OMElement)object)) {
                this.parseFeature((OMElement)object, descriptionElement, interfaceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, (OMElement)object)) {
                this.parseProperty((OMElement)object, descriptionElement, interfaceElement);
                continue;
            }
            interfaceElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceElement") : class$org$apache$woden$wsdl20$xml$InterfaceElement, interfaceElement, (OMElement)object, descriptionElement));
        }
        return interfaceElement;
    }

    private InterfaceOperationElement parseInterfaceOperation(OMElement oMElement, DescriptionElement descriptionElement, InterfaceElement interfaceElement) throws WSDLException {
        OMElement oMElement2;
        Object object;
        Object object2;
        String string;
        InterfaceOperationElement interfaceOperationElement = interfaceElement.addInterfaceOperationElement();
        interfaceOperationElement.setParentElement(interfaceElement);
        String string2 = OMUtils.getAttribute(oMElement, "name");
        if (string2 != null) {
            interfaceOperationElement.setName(new NCName(string2));
        }
        if ((string = OMUtils.getAttribute(oMElement, "style")) != null) {
            object2 = StringUtils.parseNMTokens(string);
            object = null;
            oMElement2 = object2.iterator();
            while (oMElement2.hasNext()) {
                object = (String)oMElement2.next();
                interfaceOperationElement.addStyleURI(this.getURI((String)object));
            }
        }
        if ((object2 = OMUtils.getAttribute(oMElement, "pattern")) != null) {
            interfaceOperationElement.setPattern(this.getURI((String)object2));
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$InterfaceOperationElement == null ? (class$org$apache$woden$wsdl20$xml$InterfaceOperationElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceOperationElement")) : class$org$apache$woden$wsdl20$xml$InterfaceOperationElement, interfaceOperationElement, descriptionElement);
        object = oMElement.getChildElements();
        while (object.hasNext()) {
            oMElement2 = (OMElement)object.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                this.parseDocumentation(oMElement2, descriptionElement, interfaceOperationElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, oMElement2)) {
                this.parseFeature(oMElement2, descriptionElement, interfaceOperationElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, oMElement2)) {
                this.parseProperty(oMElement2, descriptionElement, interfaceOperationElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_INPUT, oMElement2)) {
                this.parseInterfaceMessageReference(oMElement2, descriptionElement, interfaceOperationElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_OUTPUT, oMElement2)) {
                this.parseInterfaceMessageReference(oMElement2, descriptionElement, interfaceOperationElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_INFAULT, oMElement2)) {
                this.parseInterfaceFaultReference(oMElement2, descriptionElement, interfaceOperationElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_OUTFAULT, oMElement2)) {
                this.parseInterfaceFaultReference(oMElement2, descriptionElement, interfaceOperationElement);
                continue;
            }
            interfaceOperationElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceOperationElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceOperationElement") : class$org$apache$woden$wsdl20$xml$InterfaceOperationElement, interfaceOperationElement, oMElement2, descriptionElement));
        }
        return interfaceOperationElement;
    }

    private InterfaceFaultReferenceElement parseInterfaceFaultReference(OMElement oMElement, DescriptionElement descriptionElement, InterfaceOperationElement interfaceOperationElement) throws WSDLException {
        Object object;
        InterfaceFaultReferenceElement interfaceFaultReferenceElement = interfaceOperationElement.addInterfaceFaultReferenceElement();
        interfaceFaultReferenceElement.setParentElement(interfaceOperationElement);
        if ("infault".equals(oMElement.getLocalName())) {
            interfaceFaultReferenceElement.setDirection(Direction.IN);
        } else if ("outfault".equals(oMElement.getLocalName())) {
            interfaceFaultReferenceElement.setDirection(Direction.OUT);
        }
        String string = OMUtils.getAttribute(oMElement, "ref");
        if (string != null) {
            try {
                object = OMUtils.getQName(string, oMElement);
                interfaceFaultReferenceElement.setRef((QName)object);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string, QNameUtils.newQName(oMElement)}, (short)2);
            }
        }
        if ((object = OMUtils.getAttribute(oMElement, "messageLabel")) != null) {
            if (((String)object).equals(MessageLabel.IN.toString())) {
                interfaceFaultReferenceElement.setMessageLabel(MessageLabel.IN);
            } else if (((String)object).equals(MessageLabel.OUT.toString())) {
                interfaceFaultReferenceElement.setMessageLabel(MessageLabel.OUT);
            } else {
                interfaceFaultReferenceElement.setMessageLabel(MessageLabel.invalidValue((String)object));
            }
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement == null ? (class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceFaultReferenceElement")) : class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement, interfaceFaultReferenceElement, descriptionElement);
        Iterator iterator = oMElement.getChildElements();
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                this.parseDocumentation(oMElement2, descriptionElement, interfaceFaultReferenceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, oMElement2)) {
                this.parseFeature(oMElement2, descriptionElement, interfaceFaultReferenceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, oMElement2)) {
                this.parseProperty(oMElement2, descriptionElement, interfaceFaultReferenceElement);
                continue;
            }
            interfaceFaultReferenceElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceFaultReferenceElement") : class$org$apache$woden$wsdl20$xml$InterfaceFaultReferenceElement, interfaceFaultReferenceElement, oMElement2, descriptionElement));
        }
        return interfaceFaultReferenceElement;
    }

    private InterfaceMessageReferenceElement parseInterfaceMessageReference(OMElement oMElement, DescriptionElement descriptionElement, InterfaceOperationElement interfaceOperationElement) throws WSDLException {
        Object object;
        InterfaceMessageReferenceElement interfaceMessageReferenceElement = interfaceOperationElement.addInterfaceMessageReferenceElement();
        interfaceMessageReferenceElement.setParentElement(interfaceOperationElement);
        if ("input".equals(oMElement.getLocalName())) {
            interfaceMessageReferenceElement.setDirection(Direction.IN);
        } else if ("output".equals(oMElement.getLocalName())) {
            interfaceMessageReferenceElement.setDirection(Direction.OUT);
        }
        String string = OMUtils.getAttribute(oMElement, "messageLabel");
        if (string != null) {
            if (string.equals(MessageLabel.IN.toString())) {
                interfaceMessageReferenceElement.setMessageLabel(MessageLabel.IN);
            } else if (string.equals(MessageLabel.OUT.toString())) {
                interfaceMessageReferenceElement.setMessageLabel(MessageLabel.OUT);
            } else {
                interfaceMessageReferenceElement.setMessageLabel(MessageLabel.invalidValue(string));
            }
        } else if (interfaceMessageReferenceElement.getDirection().equals(Direction.IN)) {
            interfaceMessageReferenceElement.setMessageLabel(MessageLabel.IN);
        } else {
            interfaceMessageReferenceElement.setMessageLabel(MessageLabel.OUT);
        }
        String string2 = OMUtils.getAttribute(oMElement, "element");
        if (string2 != null) {
            if (string2.equals("#any") || string2.equals("#none") || string2.equals("#other")) {
                interfaceMessageReferenceElement.setMessageContentModel(string2);
            } else {
                interfaceMessageReferenceElement.setMessageContentModel("#element");
                object = OMUtils.getQName(string2, oMElement);
                interfaceMessageReferenceElement.setElementName((QName)object);
            }
        } else {
            interfaceMessageReferenceElement.setMessageContentModel("#other");
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement == null ? (class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement")) : class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement, interfaceMessageReferenceElement, descriptionElement);
        object = oMElement.getChildElements();
        while (object.hasNext()) {
            OMElement oMElement2 = (OMElement)object.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                this.parseDocumentation(oMElement2, descriptionElement, interfaceMessageReferenceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, oMElement2)) {
                this.parseFeature(oMElement2, descriptionElement, interfaceMessageReferenceElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, oMElement2)) {
                this.parseProperty(oMElement2, descriptionElement, interfaceMessageReferenceElement);
                continue;
            }
            interfaceMessageReferenceElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement") : class$org$apache$woden$wsdl20$xml$InterfaceMessageReferenceElement, interfaceMessageReferenceElement, oMElement2, descriptionElement));
        }
        return interfaceMessageReferenceElement;
    }

    private InterfaceFaultElement parseInterfaceFault(OMElement oMElement, DescriptionElement descriptionElement, InterfaceElement interfaceElement) throws WSDLException {
        Object object;
        String string;
        InterfaceFaultElement interfaceFaultElement = interfaceElement.addInterfaceFaultElement();
        interfaceFaultElement.setParentElement(interfaceElement);
        String string2 = OMUtils.getAttribute(oMElement, "name");
        if (string2 != null) {
            interfaceFaultElement.setName(new NCName(string2));
        }
        if ((string = OMUtils.getAttribute(oMElement, "element")) != null) {
            try {
                object = OMUtils.getQName(string, oMElement);
                interfaceFaultElement.setElementName((QName)object);
            }
            catch (WSDLException wSDLException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{string, QNameUtils.newQName(oMElement)}, (short)2);
            }
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$InterfaceFaultElement == null ? (class$org$apache$woden$wsdl20$xml$InterfaceFaultElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceFaultElement")) : class$org$apache$woden$wsdl20$xml$InterfaceFaultElement, interfaceFaultElement, descriptionElement);
        object = oMElement.getChildElements();
        while (object.hasNext()) {
            OMElement oMElement2 = (OMElement)object.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                this.parseDocumentation(oMElement2, descriptionElement, interfaceFaultElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_FEATURE, oMElement2)) {
                this.parseFeature(oMElement2, descriptionElement, interfaceFaultElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_PROPERTY, oMElement2)) {
                this.parseProperty(oMElement2, descriptionElement, interfaceFaultElement);
                continue;
            }
            interfaceFaultElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$InterfaceFaultElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.InterfaceFaultElement") : class$org$apache$woden$wsdl20$xml$InterfaceFaultElement, interfaceFaultElement, oMElement2, descriptionElement));
        }
        return interfaceFaultElement;
    }

    private PropertyElement parseProperty(OMElement oMElement, DescriptionElement descriptionElement, ConfigurableElement configurableElement) throws WSDLException {
        PropertyElement propertyElement = configurableElement.addPropertyElement();
        propertyElement.setParentElement(configurableElement);
        String string = OMUtils.getAttribute(oMElement, "ref");
        if (string != null) {
            propertyElement.setRef(this.getURI(string));
        }
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$PropertyElement == null ? (class$org$apache$woden$wsdl20$xml$PropertyElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.PropertyElement")) : class$org$apache$woden$wsdl20$xml$PropertyElement, propertyElement, descriptionElement);
        Iterator iterator = oMElement.getChildElements();
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                this.parseDocumentation(oMElement2, descriptionElement, propertyElement);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_VALUE, oMElement2)) {
                Iterator iterator2 = oMElement2.getChildElements();
                propertyElement.setValue(iterator2);
                continue;
            }
            if (QNameUtils.matches(Constants.Q_ELEM_CONSTRAINT, oMElement2)) continue;
            propertyElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$PropertyElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.PropertyElement") : class$org$apache$woden$wsdl20$xml$PropertyElement, propertyElement, oMElement2, descriptionElement));
        }
        return propertyElement;
    }

    private Schema parseSchemaImport(OMElement oMElement, DescriptionElement descriptionElement) throws WSDLException {
        Object object;
        String string;
        ImportedSchemaImpl importedSchemaImpl = new ImportedSchemaImpl();
        String string2 = OMUtils.getAttribute(oMElement, "namespace");
        if (string2 != null) {
            importedSchemaImpl.setNamespace(this.getURI(string2));
        }
        if ((string = OMUtils.getAttribute(oMElement, "schemaLocation")) != null) {
            importedSchemaImpl.setSchemaLocation(this.getURI(string));
        }
        if (importedSchemaImpl.getNamespace() == null) {
            importedSchemaImpl.setReferenceable(false);
            return importedSchemaImpl;
        }
        if (importedSchemaImpl.getSchemaLocation() == null) {
            return importedSchemaImpl;
        }
        OMElement oMElement2 = null;
        OMElement oMElement3 = null;
        URI uRI = null;
        String string3 = null;
        URL uRL = null;
        try {
            uRI = descriptionElement.getDocumentBaseURI();
            System.out.println(uRI);
            System.out.println(uRI.toURL());
            object = uRI != null ? uRI.toURL() : null;
            string3 = importedSchemaImpl.getSchemaLocation().toString();
            uRL = StringUtils.getURL((URL)object, string3);
        }
        catch (MalformedURLException malformedURLException) {
            String string4 = uRI != null ? uRI.toString() : null;
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL502", new Object[]{string4, string3}, (short)2);
            importedSchemaImpl.setReferenceable(false);
            return importedSchemaImpl;
        }
        object = uRL.toString();
        XmlSchema xmlSchema = (XmlSchema)this.fImportedSchemas.get(object);
        if (xmlSchema == null) {
            oMElement2 = OMUtils.getElement((String)object);
            oMElement3 = oMElement2.getFirstElement();
            String string5 = null;
            try {
                string5 = oMElement3.toStringWithConsume();
            }
            catch (XMLStreamException xMLStreamException) {
                xMLStreamException.printStackTrace();
            }
            byte[] byArray = string5.getBytes();
            InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
            try {
                XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
                xmlSchema = xmlSchemaCollection.read(inputSource, null);
                this.fImportedSchemas.put(object, xmlSchema);
            }
            catch (XmlSchemaException xmlSchemaException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL522", new Object[]{object}, (short)1, (Exception)((Object)xmlSchemaException));
            }
        }
        if (xmlSchema != null) {
            importedSchemaImpl.setSchemaDefinition(xmlSchema);
        } else {
            importedSchemaImpl.setReferenceable(false);
        }
        return importedSchemaImpl;
    }

    private Schema parseSchemaInline(OMElement oMElement, DescriptionElement descriptionElement) throws WSDLException {
        InlinedSchemaImpl inlinedSchemaImpl = new InlinedSchemaImpl();
        inlinedSchemaImpl.setId(OMUtils.getAttribute(oMElement, "id"));
        String string = OMUtils.getAttribute(oMElement, "targetNamespace");
        if (string != null) {
            inlinedSchemaImpl.setNamespace(this.getURI(string));
        }
        String string2 = descriptionElement.getDocumentBaseURI() != null ? descriptionElement.getDocumentBaseURI().toString() : null;
        XmlSchema xmlSchema = null;
        try {
            InputSource inputSource = OMUtils.getInputSource(oMElement);
            XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
            xmlSchemaCollection.setBaseUri(string2);
            NamespaceMap namespaceMap = new NamespaceMap(descriptionElement.getNamespaces());
            xmlSchemaCollection.setNamespaceContext((NamespacePrefixList)namespaceMap);
            xmlSchema = xmlSchemaCollection.read(inputSource, null);
        }
        catch (XmlSchemaException xmlSchemaException) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL521", new Object[]{string2}, (short)1, (Exception)((Object)xmlSchemaException));
        }
        if (xmlSchema != null) {
            inlinedSchemaImpl.setSchemaDefinition(xmlSchema);
        } else {
            inlinedSchemaImpl.setReferenceable(false);
        }
        return inlinedSchemaImpl;
    }

    private FeatureElement parseFeature(OMElement oMElement, DescriptionElement descriptionElement, ConfigurableElement configurableElement) throws WSDLException {
        String string;
        FeatureElement featureElement = configurableElement.addFeatureElement();
        featureElement.setParentElement(configurableElement);
        String string2 = OMUtils.getAttribute(oMElement, "ref");
        if (string2 != null) {
            featureElement.setRef(this.getURI(string2));
        }
        featureElement.setRequired("true".equals(string = OMUtils.getAttribute(oMElement, "required")));
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$FeatureElement == null ? (class$org$apache$woden$wsdl20$xml$FeatureElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.FeatureElement")) : class$org$apache$woden$wsdl20$xml$FeatureElement, featureElement, descriptionElement);
        while (oMElement != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement)) {
                this.parseDocumentation(oMElement, descriptionElement, featureElement);
            } else {
                featureElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$FeatureElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.FeatureElement") : class$org$apache$woden$wsdl20$xml$FeatureElement, featureElement, oMElement, descriptionElement));
            }
            Iterator iterator = oMElement.getChildElements();
            while (iterator.hasNext()) {
                OMElement oMElement2 = (OMElement)iterator.next();
                if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, oMElement2)) {
                    this.parseDocumentation(oMElement2, descriptionElement, featureElement);
                    continue;
                }
                featureElement.addExtensionElement(this.parseExtensionElement(class$org$apache$woden$wsdl20$xml$FeatureElement == null ? OMWSDLReader.class$("org.apache.woden.wsdl20.xml.FeatureElement") : class$org$apache$woden$wsdl20$xml$FeatureElement, featureElement, oMElement2, descriptionElement));
            }
        }
        return featureElement;
    }

    private ImportElement parseImport(OMElement oMElement, DescriptionElement descriptionElement, Map map) throws WSDLException {
        ImportElement importElement = descriptionElement.addImportElement();
        String string = OMUtils.getAttribute(oMElement, "namespace");
        String string2 = OMUtils.getAttribute(oMElement, "location");
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$ImportElement == null ? (class$org$apache$woden$wsdl20$xml$ImportElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.ImportElement")) : class$org$apache$woden$wsdl20$xml$ImportElement, importElement, descriptionElement);
        if (string != null) {
            importElement.setNamespace(this.getURI(string));
        }
        if (string2 != null) {
            importElement.setLocation(this.getURI(string2));
            DescriptionElement descriptionElement2 = this.getWSDLFromLocation(string2, descriptionElement, map);
            importElement.setDescriptionElement(descriptionElement2);
        }
        return importElement;
    }

    private IncludeElement parseInclude(OMElement oMElement, DescriptionElement descriptionElement, Map map) throws WSDLException {
        IncludeElement includeElement = descriptionElement.addIncludeElement();
        String string = OMUtils.getAttribute(oMElement, "location");
        this.parseExtensionAttributes(oMElement, class$org$apache$woden$wsdl20$xml$IncludeElement == null ? (class$org$apache$woden$wsdl20$xml$IncludeElement = OMWSDLReader.class$("org.apache.woden.wsdl20.xml.IncludeElement")) : class$org$apache$woden$wsdl20$xml$IncludeElement, includeElement, descriptionElement);
        if (string != null) {
            includeElement.setLocation(this.getURI(string));
            DescriptionElement descriptionElement2 = this.getWSDLFromLocation(string, descriptionElement, map);
            includeElement.setDescriptionElement(descriptionElement2);
        }
        return includeElement;
    }

    private ExtensionElement parseExtensionElement(Class clazz, WSDLElement wSDLElement, OMElement oMElement, DescriptionElement descriptionElement) throws WSDLException {
        QName qName = QNameUtils.newQName(oMElement);
        String string = oMElement.getNamespace().getNamespaceURI();
        if (string == null || string.equals("http://www.w3.org/2006/01/wsdl")) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL520", new Object[]{qName, clazz.getName()}, (short)2);
            return null;
        }
        ExtensionRegistry extensionRegistry = descriptionElement.getExtensionRegistry();
        if (extensionRegistry == null) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL514", new Object[]{qName, clazz.getName()}, (short)2);
            return null;
        }
        ExtensionDeserializer extensionDeserializer = extensionRegistry.queryDeserializer(clazz, qName);
        return null;
    }

    private void parseExtensionAttributes(OMElement oMElement, Class clazz, WSDLElement wSDLElement, DescriptionElement descriptionElement) throws WSDLException {
    }

    public DescriptionElement readWSDL(String string, ErrorHandler errorHandler) throws WSDLException {
        if (errorHandler != null) {
            this.getErrorReporter().setErrorHandler(errorHandler);
        }
        return this.readWSDL(string);
    }

    public DescriptionElement readWSDL(WSDLSource wSDLSource) throws WSDLException {
        return null;
    }

    public DescriptionElement readWSDL(WSDLSource wSDLSource, ErrorHandler errorHandler) throws WSDLException {
        return null;
    }

    private URI getURI(String string) throws WSDLException {
        URI uRI = null;
        if (string != null) {
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL506", new Object[]{string}, (short)2, (Exception)uRISyntaxException);
            }
        }
        return uRI;
    }

    private void checkElementName(OMElement oMElement, QName qName) throws WSDLException {
        if (!QNameUtils.matches(qName, oMElement)) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL501", new Object[]{qName, QNameUtils.newQName(oMElement)}, (short)3);
        }
    }

    private DescriptionElement getWSDLFromLocation(String string, DescriptionElement descriptionElement, Map map) throws WSDLException {
        Object object;
        DescriptionElement descriptionElement2 = null;
        URL uRL = null;
        URI uRI = null;
        try {
            uRI = descriptionElement.getDocumentBaseURI();
            object = uRI != null ? uRI.toURL() : null;
            uRL = StringUtils.getURL((URL)object, string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = uRI != null ? uRI.toString() : null;
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL502", new Object[]{string2, string}, (short)2);
            return null;
        }
        object = uRL.toString();
        descriptionElement2 = (DescriptionElement)map.get(object);
        if (descriptionElement2 == null) {
            OMElement oMElement = OMUtils.getElement((String)object);
            if (!QNameUtils.matches(Constants.Q_ELEM_DESCRIPTION, oMElement)) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL501", new Object[]{Constants.Q_ELEM_DESCRIPTION, QNameUtils.newQName(oMElement)}, (short)2);
                return null;
            }
            descriptionElement2 = this.parseDescription((String)object, oMElement, map);
            if (!map.containsKey(object)) {
                map.put(object, descriptionElement2);
            }
        }
        return descriptionElement2;
    }

    public WSDLSource createWSDLSource() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

