/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.http;

import java.net.URI;
import org.apache.woden.internal.wsdl20.extensions.ComponentExtensionsImpl;
import org.apache.woden.internal.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.BindingOperation;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.extensions.InterfaceOperationExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingOperationExtensions;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.BooleanAttr;
import org.apache.woden.xml.StringAttr;
import org.apache.woden.xml.URIAttr;

public class HTTPBindingOperationExtensionsImpl
extends ComponentExtensionsImpl
implements HTTPBindingOperationExtensions {
    public URI getHttpLocation() {
        URIAttr uRIAttr = (URIAttr)((WSDLElement)((Object)this.fParent)).getExtensionAttribute(HTTPConstants.Q_ATTR_LOCATION);
        return uRIAttr != null ? uRIAttr.getURI() : null;
    }

    public Boolean isHttpLocationIgnoreUncited() {
        BooleanAttr booleanAttr = (BooleanAttr)((WSDLElement)((Object)this.fParent)).getExtensionAttribute(HTTPConstants.Q_ATTR_IGNORE_UNCITED);
        return booleanAttr != null ? booleanAttr.getBoolean() : new Boolean(false);
    }

    public String getHttpMethod() {
        StringAttr stringAttr = (StringAttr)((WSDLElement)((Object)this.fParent)).getExtensionAttribute(HTTPConstants.Q_ATTR_METHOD);
        if (stringAttr != null) {
            return stringAttr.getString();
        }
        return null;
    }

    public String getHttpInputSerialization() {
        StringAttr stringAttr = (StringAttr)((WSDLElement)((Object)this.fParent)).getExtensionAttribute(HTTPConstants.Q_ATTR_INPUT_SERIALIZATION);
        if (stringAttr != null) {
            return stringAttr.getString();
        }
        String string = this.determineHttpMethod();
        if (string.equals("GET") || string.equals("DELETE")) {
            return "application/x-www-form-urlencoded";
        }
        return "application/xml";
    }

    public String getHttpOutputSerialization() {
        StringAttr stringAttr = (StringAttr)((WSDLElement)((Object)this.fParent)).getExtensionAttribute(HTTPConstants.Q_ATTR_OUTPUT_SERIALIZATION);
        return stringAttr != null ? stringAttr.getString() : "application/xml";
    }

    public String getHttpFaultSerialization() {
        StringAttr stringAttr = (StringAttr)((WSDLElement)((Object)this.fParent)).getExtensionAttribute(HTTPConstants.Q_ATTR_FAULT_SERIALIZATION);
        return stringAttr != null ? stringAttr.getString() : "application/xml";
    }

    public String getHttpQueryParameterSeparator() {
        StringAttr stringAttr = (StringAttr)((WSDLElement)((Object)this.fParent)).getExtensionAttribute(HTTPConstants.Q_ATTR_QUERY_PARAMETER_SEPARATOR);
        return stringAttr != null ? stringAttr.getString() : null;
    }

    public String getHttpTransferCodingDefault() {
        StringAttr stringAttr = (StringAttr)((WSDLElement)((Object)this.fParent)).getExtensionAttribute(HTTPConstants.Q_ATTR_TRANSFER_CODING_DEFAULT);
        return stringAttr != null ? stringAttr.getString() : null;
    }

    private String determineHttpMethod() {
        InterfaceOperationExtensions interfaceOperationExtensions;
        String string = this.getHttpMethod();
        if (string != null) {
            return string;
        }
        Binding binding = (Binding)((BindingOperation)this.fParent).getParent();
        HTTPBindingExtensions hTTPBindingExtensions = (HTTPBindingExtensions)binding.getComponentExtensionsForNamespace(HTTPConstants.NS_URI_HTTP);
        String string2 = hTTPBindingExtensions.getHttpMethodDefault();
        if (string2 != null) {
            return string2;
        }
        InterfaceOperation interfaceOperation = ((BindingOperation)this.fParent).getInterfaceOperation();
        if (interfaceOperation != null && (interfaceOperationExtensions = (InterfaceOperationExtensions)interfaceOperation.getComponentExtensionsForNamespace(URI.create("http://www.w3.org/2006/01/wsdl-extensions"))) != null && interfaceOperationExtensions.isSafety()) {
            return "GET";
        }
        return "POST";
    }
}

