/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.validation;

import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.types.NCName;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.BindingFault;
import org.apache.woden.wsdl20.BindingFaultReference;
import org.apache.woden.wsdl20.BindingMessageReference;
import org.apache.woden.wsdl20.BindingOperation;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Feature;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.InterfaceFault;
import org.apache.woden.wsdl20.InterfaceFaultReference;
import org.apache.woden.wsdl20.InterfaceMessageReference;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.Property;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.enumeration.MessageLabel;

public class WSDLComponentValidator {
    public void validate(Description description, ErrorReporter errorReporter) throws WSDLException {
        this.validateInterfaces(description.getInterfaces(), description, errorReporter);
        this.validateBindings(description.getBindings(), description, errorReporter);
        this.validateServices(description.getServices(), description, errorReporter);
    }

    protected void validateInterfaces(Interface[] interfaceArray, Description description, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionInterface0030(interfaceArray, errorReporter);
        int n = interfaceArray.length;
        for (int i = 0; i < n; ++i) {
            Interface interface_ = interfaceArray[i];
            this.testAssertionInterface0027(interface_, errorReporter);
            InterfaceOperation[] interfaceOperationArray = interface_.getInterfaceOperations();
            this.testAssertionInterfaceOperation0035(interfaceOperationArray, errorReporter);
            int n2 = interfaceOperationArray.length;
            for (int j = 0; j < n2; ++j) {
                InterfaceOperation interfaceOperation = interfaceOperationArray[j];
                this.testAssertionMEP0037(interfaceOperation.getMessageExchangePattern(), errorReporter);
                this.testAssertionInterfaceOperation0029(interfaceOperation, interface_, errorReporter);
                InterfaceMessageReference[] interfaceMessageReferenceArray = interfaceOperation.getInterfaceMessageReferences();
                this.testAssertionInterfaceMessageReference0042(interfaceMessageReferenceArray, errorReporter);
                int n3 = interfaceMessageReferenceArray.length;
                for (int k = 0; k < n3; ++k) {
                    InterfaceMessageReference interfaceMessageReference = interfaceMessageReferenceArray[k];
                    this.testAssertionInterfaceMessageReference0041(interfaceMessageReference, errorReporter);
                    this.validateFeatures(interfaceMessageReference.getFeatures(), errorReporter);
                    this.validateProperties(interfaceMessageReference.getProperties(), description, errorReporter);
                }
                InterfaceFaultReference[] interfaceFaultReferenceArray = interfaceOperation.getInterfaceFaultReferences();
                this.testAssertionInterfaceFaultReference0045(interfaceFaultReferenceArray, errorReporter);
                int n4 = interfaceFaultReferenceArray.length;
                for (int k = 0; k < n4; ++k) {
                    InterfaceFaultReference interfaceFaultReference = interfaceFaultReferenceArray[k];
                    this.validateFeatures(interfaceFaultReference.getFeatures(), errorReporter);
                    this.validateProperties(interfaceFaultReference.getProperties(), description, errorReporter);
                }
                this.validateFeatures(interfaceOperation.getFeatures(), errorReporter);
                this.validateProperties(interfaceOperation.getProperties(), description, errorReporter);
            }
            InterfaceFault[] interfaceFaultArray = interface_.getInterfaceFaults();
            this.testAssertionInterfaceFault0032(interfaceFaultArray, errorReporter);
            int n5 = interfaceFaultArray.length;
            for (int j = 0; j < n5; ++j) {
                InterfaceFault interfaceFault = interfaceFaultArray[j];
                this.testAssertionInterfaceFault0028(interfaceFault, interface_, errorReporter);
                this.validateFeatures(interfaceFault.getFeatures(), errorReporter);
                this.validateProperties(interfaceFault.getProperties(), description, errorReporter);
            }
            this.validateFeatures(interface_.getFeatures(), errorReporter);
            this.validateProperties(interface_.getProperties(), description, errorReporter);
        }
    }

    protected void validateBindings(Binding[] bindingArray, Description description, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionBinding0057(bindingArray, errorReporter);
        int n = bindingArray.length;
        for (int i = 0; i < n; ++i) {
            Binding binding = bindingArray[i];
            this.testAssertionBinding0054(binding, errorReporter);
            this.testAssertionBinding0055(binding, errorReporter);
            this.testAssertionBinding0056(binding, errorReporter);
            this.validateBindingOperations(binding.getBindingOperations(), description, errorReporter);
            this.validateBindingFault(binding.getBindingFaults(), description, errorReporter);
            this.validateFeatures(binding.getFeatures(), errorReporter);
            this.validateProperties(binding.getProperties(), description, errorReporter);
        }
    }

    protected void validateBindingOperations(BindingOperation[] bindingOperationArray, Description description, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionBindingOperation0059(bindingOperationArray, errorReporter);
        int n = bindingOperationArray.length;
        for (int i = 0; i < n; ++i) {
            BindingOperation bindingOperation = bindingOperationArray[i];
            this.validateBindingMessageReferences(bindingOperation.getBindingMessageReferences(), description, errorReporter);
            this.validateBindingFaultReferences(bindingOperation.getBindingFaultReferences(), description, errorReporter);
            this.validateFeatures(bindingOperation.getFeatures(), errorReporter);
            this.validateProperties(bindingOperation.getProperties(), description, errorReporter);
        }
    }

    protected void validateBindingMessageReferences(BindingMessageReference[] bindingMessageReferenceArray, Description description, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionBindingMessageReference0060(bindingMessageReferenceArray, errorReporter);
        int n = bindingMessageReferenceArray.length;
        for (int i = 0; i < n; ++i) {
            BindingMessageReference bindingMessageReference = bindingMessageReferenceArray[i];
            this.validateFeatures(bindingMessageReference.getFeatures(), errorReporter);
            this.validateProperties(bindingMessageReference.getProperties(), description, errorReporter);
        }
    }

    protected void validateBindingFaultReferences(BindingFaultReference[] bindingFaultReferenceArray, Description description, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionBindingFaultReference0061(bindingFaultReferenceArray, errorReporter);
        int n = bindingFaultReferenceArray.length;
        for (int i = 0; i < n; ++i) {
            BindingFaultReference bindingFaultReference = bindingFaultReferenceArray[i];
            this.testAssertionBindingFaultReference0062(bindingFaultReference, errorReporter);
            this.validateFeatures(bindingFaultReference.getFeatures(), errorReporter);
            this.validateProperties(bindingFaultReference.getProperties(), description, errorReporter);
        }
    }

    protected void validateBindingFault(BindingFault[] bindingFaultArray, Description description, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionBindingFault0058(bindingFaultArray, errorReporter);
        int n = bindingFaultArray.length;
        for (int i = 0; i < n; ++i) {
            BindingFault bindingFault = bindingFaultArray[i];
            this.validateFeatures(bindingFault.getFeatures(), errorReporter);
            this.validateProperties(bindingFault.getProperties(), description, errorReporter);
        }
    }

    protected void validateServices(Service[] serviceArray, Description description, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionService0063(serviceArray, errorReporter);
        int n = serviceArray.length;
        for (int i = 0; i < n; ++i) {
            Service service = serviceArray[i];
            this.validateEndpoints(service.getEndpoints(), description, errorReporter);
            this.validateFeatures(service.getFeatures(), errorReporter);
            this.validateProperties(service.getProperties(), description, errorReporter);
        }
    }

    protected void validateEndpoints(Endpoint[] endpointArray, Description description, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionEndpoint0065(endpointArray, errorReporter);
        int n = endpointArray.length;
        for (int i = 0; i < n; ++i) {
            Endpoint endpoint = endpointArray[i];
            this.testAssertionEndpoint0064(endpoint, errorReporter);
            this.testAssertionEndpoint0066(endpoint, errorReporter);
            this.validateFeatures(endpoint.getFeatures(), errorReporter);
            this.validateProperties(endpoint.getProperties(), description, errorReporter);
        }
    }

    protected void validateProperties(Property[] propertyArray, Description description, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionProperty0050(propertyArray, errorReporter);
        int n = propertyArray.length;
        for (int i = 0; i < n; ++i) {
            Property property = propertyArray[i];
            this.testAssertionPropertyRef0048(property, errorReporter);
            this.testAssertionProperty0049(property, description, errorReporter);
            this.testAssertionProperty0049b(property, errorReporter);
        }
    }

    protected void validateFeatures(Feature[] featureArray, ErrorReporter errorReporter) throws WSDLException {
        this.testAssertionFeatureRef0047(featureArray, errorReporter);
        int n = featureArray.length;
        for (int i = 0; i < n; ++i) {
            this.testAssertionFeatureRef0046(featureArray[i], errorReporter);
        }
    }

    protected boolean testAssertionInterface0027(Interface interface_, ErrorReporter errorReporter) throws WSDLException {
        Interface[] interfaceArray = interface_.getExtendedInterfaces();
        Interface interface_2 = this.containsInterface(interface_, interfaceArray);
        if (interface_2 != null) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Interface-0027", new Object[]{interface_2.getName()}, (short)2);
            return false;
        }
        return true;
    }

    private Interface containsInterface(Interface interface_, Interface[] interfaceArray) {
        int n = interfaceArray.length;
        for (int i = 0; i < n; ++i) {
            if (interface_.equals(interfaceArray[i])) {
                return interfaceArray[i];
            }
            if (this.containsInterface(interface_, interfaceArray[i].getExtendedInterfaces()) == null) continue;
            return interfaceArray[i];
        }
        return null;
    }

    protected boolean testAssertionInterface0030(Interface[] interfaceArray, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = false;
        ArrayList<QName> arrayList = new ArrayList<QName>();
        int n = interfaceArray.length;
        for (int i = 0; i < n; ++i) {
            QName qName = interfaceArray[i].getName();
            if (arrayList.contains(qName)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Interface-0030", new Object[]{qName}, (short)2);
                bl = true;
                continue;
            }
            arrayList.add(qName);
        }
        return !bl;
    }

    protected boolean testAssertionMEP0037(URI uRI, ErrorReporter errorReporter) throws WSDLException {
        if (!uRI.isAbsolute()) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "MEP-0037", new Object[]{uRI}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionInterfaceOperation0029(InterfaceOperation interfaceOperation, Interface interface_, ErrorReporter errorReporter) throws WSDLException {
        if (!interfaceOperation.getName().getNamespaceURI().equals(interface_.getName().getNamespaceURI())) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "InterfaceOperation-0029", new Object[0], (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionInterfaceOperation0035(InterfaceOperation[] interfaceOperationArray, ErrorReporter errorReporter) throws WSDLException {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        int n = interfaceOperationArray.length;
        for (int i = 0; i < n; ++i) {
            QName qName = interfaceOperationArray[i].getName();
            if (arrayList.contains(qName)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "InterfaceOperation-0035", new Object[]{qName}, (short)2);
                return false;
            }
            arrayList.add(qName);
        }
        return true;
    }

    protected boolean testAssertionInterfaceFault0032(InterfaceFault[] interfaceFaultArray, ErrorReporter errorReporter) throws WSDLException {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        int n = interfaceFaultArray.length;
        for (int i = 0; i < n; ++i) {
            QName qName = interfaceFaultArray[i].getName();
            if (arrayList.contains(qName)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "InterfaceFault-0032", new Object[]{qName}, (short)2);
                return false;
            }
            arrayList.add(qName);
        }
        return true;
    }

    protected boolean testAssertionInterfaceFault0028(InterfaceFault interfaceFault, Interface interface_, ErrorReporter errorReporter) throws WSDLException {
        if (!interfaceFault.getName().getNamespaceURI().equals(interface_.getName().getNamespaceURI())) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "InterfaceFault-0028", new Object[0], (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionInterfaceMessageReference0041(InterfaceMessageReference interfaceMessageReference, ErrorReporter errorReporter) throws WSDLException {
        String string = interfaceMessageReference.getMessageContentModel();
        if ((string.equals("#any") || string.equals("#none")) && interfaceMessageReference.getElementDeclaration() != null) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "InterfaceMessageReference-0041", new Object[0], (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionInterfaceMessageReference0042(InterfaceMessageReference[] interfaceMessageReferenceArray, ErrorReporter errorReporter) throws WSDLException {
        ArrayList<MessageLabel> arrayList = new ArrayList<MessageLabel>();
        int n = interfaceMessageReferenceArray.length;
        for (int i = 0; i < n; ++i) {
            MessageLabel messageLabel = interfaceMessageReferenceArray[i].getMessageLabel();
            if (arrayList.contains(messageLabel)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "InterfaceMessageReference-0042", new Object[]{messageLabel}, (short)2);
                return false;
            }
            arrayList.add(messageLabel);
        }
        return true;
    }

    protected boolean testAssertionInterfaceFaultReference0045(InterfaceFaultReference[] interfaceFaultReferenceArray, ErrorReporter errorReporter) throws WSDLException {
        Hashtable<InterfaceFault, ArrayList<MessageLabel>> hashtable = new Hashtable<InterfaceFault, ArrayList<MessageLabel>>();
        int n = interfaceFaultReferenceArray.length;
        for (int i = 0; i < n; ++i) {
            InterfaceFault interfaceFault = interfaceFaultReferenceArray[i].getInterfaceFault();
            MessageLabel messageLabel = interfaceFaultReferenceArray[i].getMessageLabel();
            if (interfaceFault == null || messageLabel == null) continue;
            ArrayList<MessageLabel> arrayList = (ArrayList<MessageLabel>)hashtable.get(interfaceFault);
            if (arrayList != null && arrayList.contains(messageLabel)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "InterfaceFaultReference-0045", new Object[]{interfaceFault, messageLabel}, (short)2);
                return false;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<MessageLabel>();
            }
            arrayList.add(messageLabel);
            hashtable.put(interfaceFault, arrayList);
        }
        return true;
    }

    protected boolean testAssertionFeatureRef0046(Feature feature, ErrorReporter errorReporter) throws WSDLException {
        URI uRI = feature.getRef();
        if (uRI != null && !uRI.isAbsolute()) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "FeatureRef-0046", new Object[]{uRI}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionFeatureRef0047(Feature[] featureArray, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = true;
        ArrayList<URI> arrayList = new ArrayList<URI>();
        int n = featureArray.length;
        for (int i = 0; i < n; ++i) {
            URI uRI = featureArray[i].getRef();
            if (uRI == null) continue;
            if (arrayList.contains(uRI)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "FeatureRef-0047", new Object[]{uRI}, (short)2);
                bl = false;
                continue;
            }
            arrayList.add(uRI);
        }
        return bl;
    }

    protected boolean testAssertionPropertyRef0048(Property property, ErrorReporter errorReporter) throws WSDLException {
        URI uRI = property.getRef();
        if (uRI != null && !uRI.isAbsolute()) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "PropertyRef-0048", new Object[]{uRI}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionProperty0050(Property[] propertyArray, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = true;
        ArrayList<URI> arrayList = new ArrayList<URI>();
        int n = propertyArray.length;
        for (int i = 0; i < n; ++i) {
            URI uRI = propertyArray[i].getRef();
            if (uRI == null) continue;
            if (arrayList.contains(uRI)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Property-0050", new Object[]{uRI}, (short)2);
                bl = false;
                continue;
            }
            arrayList.add(uRI);
        }
        return bl;
    }

    protected boolean testAssertionProperty0049(Property property, Description description, ErrorReporter errorReporter) throws WSDLException {
        QName qName = property.toElement().getConstraintName();
        if (qName != null && description.getTypeDefinition(qName) == null) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Property-0049", new Object[]{qName}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionProperty0049b(Property property, ErrorReporter errorReporter) throws WSDLException {
        if (property.getValue() != null && !property.toElement().hasValueToken()) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Property-0049", new Object[0], (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionBinding0054(Binding binding, ErrorReporter errorReporter) throws WSDLException {
        BindingOperation[] bindingOperationArray = binding.getBindingOperations();
        BindingFault[] bindingFaultArray = binding.getBindingFaults();
        Interface interface_ = binding.getInterface();
        if ((bindingOperationArray != null && bindingOperationArray.length > 0 || bindingFaultArray != null && bindingFaultArray.length > 0) && interface_ == null) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Binding-0054", new Object[0], (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionBinding0055(Binding binding, ErrorReporter errorReporter) throws WSDLException {
        Interface[] interfaceArray;
        boolean bl = true;
        QName qName = binding.getName();
        String string = qName != null ? qName.getLocalPart() : null;
        Interface interface_ = binding.getInterface();
        if (interface_ == null) {
            return true;
        }
        BindingOperation[] bindingOperationArray = binding.getBindingOperations();
        int n = bindingOperationArray.length;
        ArrayList<InterfaceOperation> arrayList = new ArrayList<InterfaceOperation>();
        for (int i = 0; i < n; ++i) {
            InterfaceOperation interfaceOperation = bindingOperationArray[i].getInterfaceOperation();
            if (interfaceOperation == null) continue;
            arrayList.add(interfaceOperation);
        }
        if (!this.checkAllInterfaceOperationsHaveBinding(string, interface_, arrayList, errorReporter)) {
            bl = false;
        }
        if ((interfaceArray = interface_.getExtendedInterfaces()) != null) {
            int n2 = interfaceArray.length;
            for (int i = 0; i < n2; ++i) {
                if (this.checkAllInterfaceOperationsHaveBinding(string, interfaceArray[i], arrayList, errorReporter)) continue;
                bl = false;
            }
        }
        return bl;
    }

    private boolean checkAllInterfaceOperationsHaveBinding(String string, Interface interface_, List list, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = true;
        InterfaceOperation[] interfaceOperationArray = interface_.getInterfaceOperations();
        if (interfaceOperationArray == null) {
            return true;
        }
        int n = interfaceOperationArray.length;
        for (int i = 0; i < n; ++i) {
            if (list.contains(interfaceOperationArray[i])) continue;
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Binding-0055", new Object[]{string, interfaceOperationArray[i].getName()}, (short)2);
            bl = false;
        }
        return bl;
    }

    protected boolean testAssertionBinding0056(Binding binding, ErrorReporter errorReporter) throws WSDLException {
        URI uRI = binding.getType();
        if (uRI != null && !uRI.isAbsolute()) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Binding-0056", new Object[]{uRI}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionBinding0057(Binding[] bindingArray, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = false;
        ArrayList<QName> arrayList = new ArrayList<QName>();
        int n = bindingArray.length;
        for (int i = 0; i < n; ++i) {
            QName qName = bindingArray[i].getName();
            if (arrayList.contains(qName)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Binding-0057", new Object[]{qName}, (short)2);
                bl = true;
                continue;
            }
            arrayList.add(qName);
        }
        return !bl;
    }

    protected boolean testAssertionBindingFault0058(BindingFault[] bindingFaultArray, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = false;
        ArrayList<InterfaceFault> arrayList = new ArrayList<InterfaceFault>();
        int n = bindingFaultArray.length;
        for (int i = 0; i < n; ++i) {
            InterfaceFault interfaceFault = bindingFaultArray[i].getInterfaceFault();
            if (arrayList.contains(interfaceFault)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "BindingFault-0058", new Object[0], (short)2);
                bl = true;
                continue;
            }
            arrayList.add(interfaceFault);
        }
        return !bl;
    }

    protected boolean testAssertionBindingOperation0059(BindingOperation[] bindingOperationArray, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = false;
        ArrayList<InterfaceOperation> arrayList = new ArrayList<InterfaceOperation>();
        int n = bindingOperationArray.length;
        for (int i = 0; i < n; ++i) {
            InterfaceOperation interfaceOperation = bindingOperationArray[i].getInterfaceOperation();
            if (arrayList.contains(interfaceOperation)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "BindingOperation-0059", new Object[]{interfaceOperation.getName()}, (short)2);
                bl = true;
                continue;
            }
            arrayList.add(interfaceOperation);
        }
        return !bl;
    }

    protected boolean testAssertionBindingMessageReference0060(BindingMessageReference[] bindingMessageReferenceArray, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = false;
        ArrayList<InterfaceMessageReference> arrayList = new ArrayList<InterfaceMessageReference>();
        int n = bindingMessageReferenceArray.length;
        for (int i = 0; i < n; ++i) {
            InterfaceMessageReference interfaceMessageReference = bindingMessageReferenceArray[i].getInterfaceMessageReference();
            if (arrayList.contains(interfaceMessageReference)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "BindingMessageReference-0060", new Object[]{interfaceMessageReference.getMessageLabel()}, (short)2);
                bl = true;
                continue;
            }
            arrayList.add(interfaceMessageReference);
        }
        return !bl;
    }

    protected boolean testAssertionBindingFaultReference0061(BindingFaultReference[] bindingFaultReferenceArray, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = false;
        ArrayList<InterfaceFaultReference> arrayList = new ArrayList<InterfaceFaultReference>();
        int n = bindingFaultReferenceArray.length;
        for (int i = 0; i < n; ++i) {
            InterfaceFaultReference interfaceFaultReference = bindingFaultReferenceArray[i].getInterfaceFaultReference();
            if (arrayList.contains(interfaceFaultReference)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "BindingFaultReference-0061", new Object[]{interfaceFaultReference.getMessageLabel()}, (short)2);
                bl = true;
                continue;
            }
            arrayList.add(interfaceFaultReference);
        }
        return !bl;
    }

    protected boolean testAssertionBindingFaultReference0062(BindingFaultReference bindingFaultReference, ErrorReporter errorReporter) throws WSDLException {
        InterfaceFaultReference interfaceFaultReference = bindingFaultReference.getInterfaceFaultReference();
        if (interfaceFaultReference == null) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "BindingFaultReference-0062", new Object[0], (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionService0063(Service[] serviceArray, ErrorReporter errorReporter) throws WSDLException {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        int n = serviceArray.length;
        for (int i = 0; i < n; ++i) {
            QName qName = serviceArray[i].getName();
            if (arrayList.contains(qName)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Service-0063", new Object[]{qName}, (short)2);
                return false;
            }
            arrayList.add(qName);
        }
        return true;
    }

    protected boolean testAssertionEndpoint0065(Endpoint[] endpointArray, ErrorReporter errorReporter) throws WSDLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = endpointArray.length;
        for (int i = 0; i < n; ++i) {
            NCName nCName = endpointArray[i].getName();
            if (nCName == null) continue;
            String string = nCName.toString();
            if (arrayList.contains(string)) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Endpoint-0065", new Object[]{string}, (short)2);
                return false;
            }
            arrayList.add(string);
        }
        return true;
    }

    protected boolean testAssertionEndpoint0064(Endpoint endpoint, ErrorReporter errorReporter) throws WSDLException {
        URI uRI = endpoint.getAddress();
        if (uRI != null && !uRI.isAbsolute()) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Endpoint-0064", new Object[]{uRI}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionEndpoint0066(Endpoint endpoint, ErrorReporter errorReporter) throws WSDLException {
        Service service;
        Interface interface_;
        Binding binding = endpoint.getBinding();
        if (binding == null) {
            return true;
        }
        Interface interface_2 = binding.getInterface();
        WSDLComponent wSDLComponent = endpoint.getParent();
        if (wSDLComponent != null && (interface_ = (service = (Service)wSDLComponent).getInterface()) != null && interface_2 != null && !interface_.equals(interface_2)) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Endpoint-0066", new Object[]{binding, interface_2, interface_}, (short)2);
            return false;
        }
        return true;
    }
}

