/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.validation;

import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.schema.ImportedSchema;
import org.apache.woden.schema.InlinedSchema;
import org.apache.woden.schema.Schema;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.ImportElement;
import org.apache.woden.wsdl20.xml.InterfaceElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultElement;
import org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement;
import org.apache.woden.wsdl20.xml.InterfaceOperationElement;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;

public class WSDLDocumentValidator {
    public boolean validate(DescriptionElement descriptionElement, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = true;
        bl = this.testAssertionDescription0025(descriptionElement, errorReporter);
        ImportElement[] importElementArray = descriptionElement.getImportElements();
        int n = importElementArray.length;
        for (int i = 0; i < n; ++i) {
        }
        if (!this.validateTypes(descriptionElement.getTypesElement(), errorReporter)) {
            bl = false;
        }
        if (!this.validateInterfaces(descriptionElement, descriptionElement.getInterfaceElements(), errorReporter)) {
            bl = false;
        }
        return bl;
    }

    protected boolean validateTypes(TypesElement typesElement, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = true;
        if (typesElement == null) {
            return true;
        }
        ImportedSchema[] importedSchemaArray = typesElement.getImportedSchemas();
        int n = importedSchemaArray.length;
        for (int i = 0; i < n; ++i) {
            ImportedSchema importedSchema = importedSchemaArray[i];
            if (!this.testAssertionSchema0017(importedSchema, errorReporter)) {
                bl = false;
            }
            if (this.testAssertionSchema0052(importedSchema, errorReporter)) continue;
            bl = false;
        }
        InlinedSchema[] inlinedSchemaArray = typesElement.getInlinedSchemas();
        if (!this.testAssertionSchema0018(inlinedSchemaArray, errorReporter)) {
            bl = false;
        }
        int n2 = inlinedSchemaArray.length;
        for (int i = 0; i < n2; ++i) {
            InlinedSchema inlinedSchema = inlinedSchemaArray[i];
            if (this.testAssertionSchema0019(inlinedSchema, errorReporter)) continue;
            bl = false;
        }
        return bl;
    }

    protected boolean validateInterfaces(DescriptionElement descriptionElement, InterfaceElement[] interfaceElementArray, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = true;
        int n = interfaceElementArray.length;
        for (int i = 0; i < n; ++i) {
            InterfaceElement interfaceElement = interfaceElementArray[i];
            if (!this.testAssertionInterface0031(interfaceElement, errorReporter)) {
                bl = false;
            }
            InterfaceFaultElement[] interfaceFaultElementArray = interfaceElement.getInterfaceFaultElements();
            int n2 = interfaceFaultElementArray.length;
            for (int j = 0; j < n2; ++j) {
                InterfaceFaultElement interfaceFaultElement = interfaceFaultElementArray[j];
                if (!this.testAssertionSchema0020b(descriptionElement, interfaceFaultElement, errorReporter)) {
                    bl = false;
                }
                if (this.testAssertionSchema0016(descriptionElement, interfaceFaultElement.getElementName().getNamespaceURI(), errorReporter)) continue;
                bl = false;
            }
            InterfaceOperationElement[] interfaceOperationElementArray = interfaceElement.getInterfaceOperationElements();
            int n3 = interfaceOperationElementArray.length;
            for (int j = 0; j < n3; ++j) {
                InterfaceOperationElement interfaceOperationElement = interfaceOperationElementArray[j];
                InterfaceMessageReferenceElement[] interfaceMessageReferenceElementArray = interfaceOperationElement.getInterfaceMessageReferenceElements();
                int n4 = interfaceMessageReferenceElementArray.length;
                for (int k = 0; k < n4; ++k) {
                    QName qName;
                    InterfaceMessageReferenceElement interfaceMessageReferenceElement = interfaceMessageReferenceElementArray[k];
                    if (!this.testAssertionSchema0020(descriptionElement, interfaceMessageReferenceElement, errorReporter)) {
                        bl = false;
                    }
                    if ((qName = interfaceMessageReferenceElement.getElementName()) == null || this.testAssertionSchema0016(descriptionElement, qName.getNamespaceURI(), errorReporter)) continue;
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected boolean testAssertionDescription0025(DescriptionElement descriptionElement, ErrorReporter errorReporter) throws WSDLException {
        URI uRI = descriptionElement.getTargetNamespace();
        if (!uRI.isAbsolute()) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Description-0025", new Object[]{uRI}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionSchema0017(ImportedSchema importedSchema, ErrorReporter errorReporter) throws WSDLException {
        XmlSchema xmlSchema = importedSchema.getSchemaDefinition();
        if (xmlSchema == null) {
            return true;
        }
        String string = xmlSchema.getTargetNamespace();
        if (string == null || string.equals("")) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-0017", new Object[]{importedSchema.getSchemaLocation()}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionSchema0052(ImportedSchema importedSchema, ErrorReporter errorReporter) throws WSDLException {
        XmlSchema xmlSchema = importedSchema.getSchemaDefinition();
        if (xmlSchema == null) {
            return true;
        }
        String string = xmlSchema.getTargetNamespace();
        String string2 = importedSchema.getNamespace().toString();
        if (string2 != null && !string2.equals(string)) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-0052", new Object[]{string2}, (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionSchema0019(InlinedSchema inlinedSchema, ErrorReporter errorReporter) throws WSDLException {
        URI uRI = inlinedSchema.getNamespace();
        if (uRI == null || uRI.toString().equals("")) {
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-0019", new Object[0], (short)2);
            return false;
        }
        return true;
    }

    protected boolean testAssertionSchema0018(InlinedSchema[] inlinedSchemaArray, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = true;
        int n = inlinedSchemaArray.length;
        Hashtable<String, List<InlinedSchema>> hashtable = new Hashtable<String, List<InlinedSchema>>();
        for (int i = 0; i < n; ++i) {
            List<InlinedSchema> list;
            InlinedSchema inlinedSchema = inlinedSchemaArray[i];
            URI uRI = inlinedSchema.getNamespace();
            if (uRI == null) continue;
            String string = uRI.toString();
            if (hashtable.containsKey(string)) {
                Iterator iterator;
                QName qName;
                list = (List)hashtable.get(string);
                XmlSchemaObjectTable xmlSchemaObjectTable = inlinedSchema.getSchemaDefinition().getElements();
                Iterator iterator2 = xmlSchemaObjectTable.getNames();
                while (iterator2.hasNext()) {
                    qName = (QName)iterator2.next();
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        if (((InlinedSchema)iterator.next()).getSchemaDefinition().getElementByName(qName) == null) continue;
                        errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-0018", new Object[]{qName, string}, (short)2);
                        bl = false;
                    }
                }
                qName = inlinedSchema.getSchemaDefinition().getSchemaTypes();
                iterator = qName.getNames();
                while (iterator.hasNext()) {
                    QName qName2 = (QName)iterator.next();
                    Iterator iterator3 = list.iterator();
                    while (iterator3.hasNext()) {
                        if (((InlinedSchema)iterator3.next()).getSchemaDefinition().getTypeByName(qName2) == null) continue;
                        errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-0018b", new Object[]{qName2, string}, (short)2);
                        bl = false;
                    }
                }
                list.add(inlinedSchema);
                continue;
            }
            list = new ArrayList();
            list.add(inlinedSchema);
            hashtable.put(string, list);
        }
        return bl;
    }

    protected boolean testAssertionInterface0031(InterfaceElement interfaceElement, ErrorReporter errorReporter) throws WSDLException {
        boolean bl = true;
        URI[] uRIArray = interfaceElement.getStyleDefault();
        int n = uRIArray.length;
        for (int i = 0; i < n; ++i) {
            if (uRIArray[i].isAbsolute()) continue;
            errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Interface-0031", new Object[]{uRIArray[i].toString()}, (short)2);
            bl = false;
        }
        return bl;
    }

    protected boolean testAssertionSchema0020(DescriptionElement descriptionElement, InterfaceMessageReferenceElement interfaceMessageReferenceElement, ErrorReporter errorReporter) throws WSDLException {
        XmlSchemaElement xmlSchemaElement = interfaceMessageReferenceElement.getElement();
        String string = interfaceMessageReferenceElement.getMessageContentModel();
        if (!(xmlSchemaElement != null || string != null && string.equals("#none"))) {
            QName qName = interfaceMessageReferenceElement.getElementName();
            if (descriptionElement.toComponent().getTypeDefinition(qName) != null) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-0020", new Object[]{interfaceMessageReferenceElement.getMessageLabel(), qName}, (short)2);
                return false;
            }
        }
        return true;
    }

    protected boolean testAssertionSchema0020b(DescriptionElement descriptionElement, InterfaceFaultElement interfaceFaultElement, ErrorReporter errorReporter) throws WSDLException {
        if (interfaceFaultElement.getElement() == null) {
            QName qName = interfaceFaultElement.getElementName();
            if (descriptionElement.toComponent().getTypeDefinition(qName) != null) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-0020b", new Object[]{interfaceFaultElement.getName(), qName}, (short)2);
                return false;
            }
        }
        return true;
    }

    protected boolean testAssertionSchema0016(DescriptionElement descriptionElement, String string, ErrorReporter errorReporter) throws WSDLException {
        if (string != null && !string.equals("http://www.w3.org/2001/XMLSchema")) {
            TypesElement typesElement = descriptionElement.getTypesElement();
            if (typesElement == null) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-0016", new Object[]{string}, (short)2);
                return false;
            }
            Schema[] schemaArray = typesElement.getSchemas();
            int n = schemaArray.length;
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                URI uRI = schemaArray[i].getNamespace();
                if (uRI == null || !uRI.toString().equals(string)) continue;
                bl = false;
                break;
            }
            if (bl) {
                errorReporter.reportError((ErrorLocator)new ErrorLocatorImpl(), "Schema-0016", new Object[]{string}, (short)2);
                return false;
            }
        }
        return true;
    }
}

