/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.xml;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.util.StringUtils;
import org.apache.woden.internal.util.dom.DOMUtils;
import org.apache.woden.internal.xml.XMLAttrImpl;
import org.apache.woden.xml.QNameListAttr;
import org.w3c.dom.Element;

public class QNameListAttrImpl
extends XMLAttrImpl
implements QNameListAttr {
    public QNameListAttrImpl() {
    }

    public QNameListAttrImpl(Element element, QName qName, String string, ErrorReporter errorReporter) throws WSDLException {
        super(element, qName, string, errorReporter);
    }

    public QName[] getQNames() {
        return (QName[])this.getContent();
    }

    protected Object convert(Element element, String string) throws WSDLException {
        if (string == null || "".equals(string)) {
            this.setValid(false);
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL509", new Object[]{string}, (short)2);
            return null;
        }
        List list = StringUtils.parseNMTokens(string);
        Iterator iterator = list.iterator();
        String string2 = null;
        QName qName = null;
        Vector<QName> vector = new Vector<QName>();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            try {
                qName = DOMUtils.getQName(string2, element);
            }
            catch (WSDLException wSDLException) {
                this.setValid(false);
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL510", new Object[]{string2, string}, (short)2, (Exception)wSDLException);
                continue;
            }
            vector.add(qName);
        }
        QName[] qNameArray = new QName[vector.size()];
        vector.toArray(qNameArray);
        return qNameArray;
    }
}

