/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.impl.index.IndexItem;

public class RedoStoreIndexItem
implements Externalizable {
    public static final Marshaller MARSHALLER = new Marshaller(){

        public Object readPayload(DataInput in) throws IOException {
            RedoStoreIndexItem item = new RedoStoreIndexItem();
            item.readExternal(in);
            return item;
        }

        public void writePayload(Object object, DataOutput out) throws IOException {
            RedoStoreIndexItem item = (RedoStoreIndexItem)object;
            item.writeExternal(out);
        }
    };
    private static final long serialVersionUID = -4865508871719676655L;
    private String indexName;
    private IndexItem indexItem;
    private long offset;

    public RedoStoreIndexItem() {
    }

    public RedoStoreIndexItem(String indexName, long offset, IndexItem item) {
        this.indexName = indexName;
        this.offset = offset;
        this.indexItem = item;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal((DataInput)in);
    }

    public void readExternal(DataInput in) throws IOException {
        this.offset = in.readLong();
        this.indexItem = new IndexItem();
        this.indexItem.read(in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeLong(this.offset);
        this.indexItem.write(out);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public IndexItem getIndexItem() {
        return this.indexItem;
    }

    public void setIndexItem(IndexItem item) {
        this.indexItem = item;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }
}

