/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OctetString;

public class OID
extends AbstractVariable
implements AssignableFromString {
    private static final long serialVersionUID = 7521667239352941172L;
    public static final int MAX_OID_LEN = 128;
    public static final int MAX_SUBID_VALUE = -1;
    private int[] value = new int[0];

    public OID() {
    }

    public OID(String string) {
        this.value = OID.parseDottedString(string);
    }

    public OID(int[] nArray) {
        this(nArray, 0, nArray.length);
    }

    public OID(int[] nArray, int[] nArray2) {
        this.value = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, this.value, 0, nArray.length);
        System.arraycopy(nArray2, 0, this.value, nArray.length, nArray2.length);
    }

    public OID(int[] nArray, int n, int n2) {
        this.setValue(nArray, n, n2);
    }

    public OID(OID oID) {
        this(oID.getValue());
    }

    private static int[] parseDottedString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n++] = (int)Long.parseLong(stringTokenizer.nextToken());
        }
        return nArray;
    }

    public final int getSyntax() {
        return 6;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.value.length; ++i) {
            n += this.value[i] * 31 ^ this.value.length - 1 - i;
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (object instanceof OID) {
            OID oID = (OID)object;
            if (oID.value.length != this.value.length) {
                return false;
            }
            for (int i = 0; i < this.value.length; ++i) {
                if (this.value[i] == oID.value[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public OID mask(OctetString octetString) {
        int[] nArray = new int[this.value.length];
        System.arraycopy(this.value, 0, nArray, 0, this.value.length);
        for (int i = 0; i < octetString.length() * 8 && i < nArray.length; ++i) {
            byte by = (byte)(128 >> i % 8);
            if ((octetString.get(i / 8) & by) != 0) continue;
            nArray[i] = 0;
        }
        return new OID(nArray);
    }

    public final int compareTo(Object object) {
        if (object instanceof OID) {
            OID oID = (OID)object;
            int n = Math.min(this.value.length, oID.value.length);
            int n2 = this.leftMostCompare(n, oID);
            if (n2 == 0) {
                return this.value.length - oID.value.length;
            }
            return n2;
        }
        throw new ClassCastException(object.getClass().getName());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10 * this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            if (i != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append((long)this.value[i] & 0xFFFFFFFFL);
        }
        return stringBuffer.toString();
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            byArray[i] = (byte)(this.value[i] & 0xFF);
        }
        return byArray;
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeOID(outputStream, (byte)6, this.value);
    }

    public int getBERLength() {
        int n = 1;
        for (int i = 2; i < this.value.length; ++i) {
            long l = (long)this.value[i] & 0xFFFFFFFFL;
            if (l < 128L) {
                ++n;
                continue;
            }
            if (l < 16384L) {
                n += 2;
                continue;
            }
            if (l < 0x200000L) {
                n += 3;
                continue;
            }
            if (l < 0x10000000L) {
                n += 4;
                continue;
            }
            n += 5;
        }
        return n + BER.getBERLengthOfLength(n) + 1;
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        int[] nArray = BER.decodeOID(bERInputStream, mutableByte);
        if (mutableByte.getValue() != 6) {
            throw new IOException("Wrong type encountered when decoding OID: " + mutableByte.getValue());
        }
        this.setValue(nArray);
    }

    public void setValue(String string) {
        this.value = OID.parseDottedString(string);
    }

    public final void setValue(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("OID value must not be set to null");
        }
        this.value = nArray;
    }

    private void setValue(int[] nArray, int n, int n2) {
        this.value = new int[n2];
        System.arraycopy(nArray, n, this.value, 0, n2);
    }

    public final int[] getValue() {
        return this.value;
    }

    public final int get(int n) {
        return this.value[n];
    }

    public final long getUnsigned(int n) {
        return (long)this.value[n] & 0xFFFFFFFFL;
    }

    public final void set(int n, int n2) {
        this.value[n] = n2;
    }

    public final void append(String string) {
        OID oID = new OID(string);
        this.append(oID);
    }

    public final void append(OID oID) {
        int[] nArray = new int[this.value.length + oID.value.length];
        System.arraycopy(this.value, 0, nArray, 0, this.value.length);
        System.arraycopy(oID.value, 0, nArray, this.value.length, oID.value.length);
        this.value = nArray;
    }

    public final void append(int n) {
        int[] nArray = new int[this.value.length + 1];
        System.arraycopy(this.value, 0, nArray, 0, this.value.length);
        nArray[this.value.length] = n;
        this.value = nArray;
    }

    public final void appendUnsigned(long l) {
        this.append((int)(l & 0xFFFFFFFFL));
    }

    public boolean isValid() {
        return this.size() >= 2 && this.size() <= 128 && ((long)this.value[0] & 0xFFFFFFFFL) <= 2L && ((long)this.value[1] & 0xFFFFFFFFL) < 40L;
    }

    public final int size() {
        return this.value.length;
    }

    public int leftMostCompare(int n, OID oID) {
        for (int i = 0; i < n; ++i) {
            if (this.value[i] == oID.value[i]) continue;
            if (((long)this.value[i] & 0xFFFFFFFFL) < ((long)oID.value[i] & 0xFFFFFFFFL)) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public int rightMostCompare(int n, OID oID) {
        int n2 = this.value.length - 1;
        int n3 = oID.value.length - 1;
        int n4 = n - 1;
        while (n4 >= 0) {
            if (this.value[n2] != oID.value[n3]) {
                if (this.value[n2] < oID.value[n3]) {
                    return -1;
                }
                return 1;
            }
            --n4;
            --n2;
            --n3;
        }
        return 0;
    }

    public boolean startsWith(OID oID) {
        if (oID.value.length > this.value.length) {
            return false;
        }
        int n = Math.min(this.value.length, oID.value.length);
        return this.leftMostCompare(n, oID) == 0;
    }

    public Object clone() {
        return new OID(this.value);
    }

    public final int last() {
        if (this.value.length > 0) {
            return this.value[this.value.length - 1];
        }
        throw new NoSuchElementException();
    }

    public final long lastUnsigned() {
        if (this.value.length > 0) {
            return (long)this.value[this.value.length - 1] & 0xFFFFFFFFL;
        }
        throw new NoSuchElementException();
    }

    public int removeLast() {
        if (this.value.length == 0) {
            return -1;
        }
        int[] nArray = new int[this.value.length - 1];
        System.arraycopy(this.value, 0, nArray, 0, this.value.length - 1);
        int n = this.value[this.value.length - 1];
        this.value = nArray;
        return n;
    }

    public void trim(int n) {
        if (n > 0) {
            if (n > this.value.length) {
                n = this.value.length;
            }
            int[] nArray = new int[this.value.length - n];
            System.arraycopy(this.value, 0, nArray, 0, this.value.length - n);
            this.value = nArray;
        }
    }

    public int toInt() {
        throw new UnsupportedOperationException();
    }

    public long toLong() {
        throw new UnsupportedOperationException();
    }

    public final OID toSubIndex(boolean bl) {
        if (bl) {
            return new OID(this.value);
        }
        OID oID = new OID(new int[]{this.size()});
        oID.append(this);
        return oID;
    }

    public final void fromSubIndex(OID oID, boolean bl) {
        int n = 1;
        if (bl) {
            n = 0;
        }
        this.setValue(oID.getValue(), n, oID.size() - n);
    }

    public final OID successor() {
        if (this.value.length == 128) {
            for (int i = 127; i >= 0; --i) {
                if (this.value[i] == -1) continue;
                int[] nArray = new int[i + 1];
                System.arraycopy(this.value, 0, nArray, 0, i + 1);
                int n = i;
                nArray[n] = nArray[n] + 1;
                return new OID(nArray);
            }
            return new OID();
        }
        int[] nArray = new int[this.value.length + 1];
        System.arraycopy(this.value, 0, nArray, 0, this.value.length);
        nArray[this.value.length] = 0;
        return new OID(nArray);
    }

    public final OID predecessor() {
        if (this.last() != 0) {
            int[] nArray = new int[128];
            System.arraycopy(this.value, 0, nArray, 0, this.value.length);
            Arrays.fill(nArray, this.value.length, nArray.length, -1);
            OID oID = new OID(nArray);
            oID.set(this.size() - 1, this.last() - 1);
            return oID;
        }
        OID oID = new OID(this);
        oID.removeLast();
        return oID;
    }

    public final OID nextPeer() {
        OID oID = new OID(this);
        if (oID.size() > 0 && this.last() != -1) {
            oID.set(oID.size() - 1, this.last() + 1);
        } else if (oID.size() > 1) {
            oID.trim(1);
            oID = this.nextPeer();
        }
        return oID;
    }

    public static final OID max(OID oID, OID oID2) {
        if (oID.compareTo(oID2) >= 0) {
            return oID;
        }
        return oID2;
    }

    public static final OID min(OID oID, OID oID2) {
        if (oID.compareTo(oID2) <= 0) {
            return oID;
        }
        return oID2;
    }
}

