/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.base.mvel.DroolsMVELFactory;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.common.InternalFactHandle;
import org.drools.rule.Declaration;
import org.drools.runtime.rule.AccumulateFunction;
import org.drools.spi.Accumulator;
import org.drools.spi.Tuple;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;

public class MVELAccumulatorFunctionExecutor
implements MVELCompileable,
Externalizable,
Accumulator {
    private static final long serialVersionUID = 510L;
    private final Object dummy = new Object();
    private MVELCompilationUnit unit;
    private AccumulateFunction function;
    private DroolsMVELFactory model;
    private Serializable expression;

    public MVELAccumulatorFunctionExecutor() {
    }

    public MVELAccumulatorFunctionExecutor(MVELCompilationUnit unit, AccumulateFunction function) {
        this.unit = unit;
        this.function = function;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.unit = (MVELCompilationUnit)in.readObject();
        this.function = (AccumulateFunction)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.unit);
        out.writeObject(this.function);
    }

    public void compile(ClassLoader classLoader) {
        this.expression = this.unit.getCompiledExpression(classLoader);
        this.model = this.unit.getFactory();
    }

    public Serializable createContext() {
        MVELAccumulatorFunctionContext context = new MVELAccumulatorFunctionContext();
        context.context = this.function.createContext();
        if (this.function.supportsReverse()) {
            context.reverseSupport = new HashMap<Integer, Object>();
        }
        return context;
    }

    public void init(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        this.function.init(((MVELAccumulatorFunctionContext)context).context);
    }

    public void accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        DroolsMVELFactory factory = (DroolsMVELFactory)workingMemoryContext;
        factory.setContext(leftTuple, null, handle.getObject(), workingMemory, null);
        Object value = MVEL.executeExpression((Object)this.expression, this.dummy, (VariableResolverFactory)factory);
        if (this.function.supportsReverse()) {
            ((MVELAccumulatorFunctionContext)context).reverseSupport.put(handle.getId(), value);
        }
        this.function.accumulate(((MVELAccumulatorFunctionContext)context).context, value);
    }

    public void reverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        Object value = ((MVELAccumulatorFunctionContext)context).reverseSupport.remove(handle.getId());
        this.function.reverse(((MVELAccumulatorFunctionContext)context).context, value);
    }

    public Object getResult(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        return this.function.getResult(((MVELAccumulatorFunctionContext)context).context);
    }

    public boolean supportsReverse() {
        return this.function.supportsReverse();
    }

    public Object createWorkingMemoryContext() {
        return this.model.clone();
    }

    private static class MVELAccumulatorFunctionContext
    implements Externalizable {
        public Serializable context;
        public Map<Integer, Object> reverseSupport;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = (Serializable)in.readObject();
            this.reverseSupport = (Map)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
            out.writeObject(this.reverseSupport);
        }
    }
}

