/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.processes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.compiler.xml.XmlDumper;
import org.drools.process.core.timer.Timer;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.NodeContainer;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.impl.ExtendedNodeImpl;
import org.drools.workflow.core.impl.NodeImpl;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeHandler
extends BaseAbstractHandler
implements Handler {
    protected static final String EOL = System.getProperty("line.separator");

    public AbstractNodeHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = false;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(NodeContainer.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(Node.class);
    }

    @Override
    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        Node node = this.createNode();
        String id = attrs.getValue("id");
        node.setId(new Long(id));
        String name = attrs.getValue("name");
        node.setName(name);
        nodeContainer.addNode(node);
        return node;
    }

    protected abstract Node createNode();

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Node node = (Node)parser.getCurrent();
        this.handleNode(node, element, uri, localName, parser);
        return node;
    }

    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        String color;
        String height;
        String width;
        String y;
        String x = element.getAttribute("x");
        if (x != null && x.length() != 0) {
            try {
                node.setMetaData("x", new Integer(x));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'x' attribute", parser.getLocator());
            }
        }
        if ((y = element.getAttribute("y")) != null && y.length() != 0) {
            try {
                node.setMetaData("y", new Integer(y));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'y' attribute", parser.getLocator());
            }
        }
        if ((width = element.getAttribute("width")) != null && width.length() != 0) {
            try {
                node.setMetaData("width", new Integer(width));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'width' attribute", parser.getLocator());
            }
        }
        if ((height = element.getAttribute("height")) != null && height.length() != 0) {
            try {
                node.setMetaData("height", new Integer(height));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'height' attribute", parser.getLocator());
            }
        }
        if ((color = element.getAttribute("color")) != null && color.length() != 0) {
            try {
                node.setMetaData("color", new Integer(color));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'color' attribute", parser.getLocator());
            }
        }
    }

    protected void handleAction(ExtendedNodeImpl node, Element element, String type) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node xmlNode = nodeList.item(i);
            String nodeName = xmlNode.getNodeName();
            if (!nodeName.equals(type)) continue;
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            NodeList subNodeList = xmlNode.getChildNodes();
            for (int j = 0; j < subNodeList.getLength(); ++j) {
                Element subXmlNode = (Element)subNodeList.item(j);
                DroolsAction action = AbstractNodeHandler.extractAction(subXmlNode);
                actions.add(action);
            }
            node.setActions(type, actions);
            return;
        }
    }

    public static DroolsAction extractAction(Element xmlNode) {
        String actionType = xmlNode.getAttribute("type");
        if ("expression".equals(actionType)) {
            String consequence = xmlNode.getTextContent();
            DroolsConsequenceAction action = new DroolsConsequenceAction(xmlNode.getAttribute("dialect"), consequence);
            return action;
        }
        throw new IllegalArgumentException("Unknown action type " + actionType);
    }

    public abstract void writeNode(Node var1, StringBuilder var2, boolean var3);

    protected void writeNode(String name, Node node, StringBuilder xmlDump, boolean includeMeta) {
        xmlDump.append("    <" + name + " id=\"" + node.getId() + "\" ");
        if (node.getName() != null) {
            xmlDump.append("name=\"" + XmlDumper.replaceIllegalChars(node.getName()) + "\" ");
        }
        if (includeMeta) {
            Integer x = (Integer)node.getMetaData("x");
            Integer y = (Integer)node.getMetaData("y");
            Integer width = (Integer)node.getMetaData("width");
            Integer height = (Integer)node.getMetaData("height");
            Integer color = (Integer)node.getMetaData("color");
            if (x != null && x != 0) {
                xmlDump.append("x=\"" + x + "\" ");
            }
            if (y != null && y != 0) {
                xmlDump.append("y=\"" + y + "\" ");
            }
            if (width != null && width != -1) {
                xmlDump.append("width=\"" + width + "\" ");
            }
            if (height != null && height != -1) {
                xmlDump.append("height=\"" + height + "\" ");
            }
            if (color != null && color != 0) {
                xmlDump.append("color=\"" + color + "\" ");
            }
        }
    }

    protected boolean containsMetaData(Node node) {
        for (Map.Entry<String, Object> entry : ((NodeImpl)node).getMetaData().entrySet()) {
            String name = entry.getKey();
            if ("x".equals(name) || "y".equals(name) || "width".equals(name) || "height".equals(name) || "color".equals(name) || !(entry.getValue() instanceof String)) continue;
            return true;
        }
        return false;
    }

    protected void writeMetaData(Node node, StringBuilder xmlDump) {
        for (Map.Entry<String, Object> entry : ((NodeImpl)node).getMetaData().entrySet()) {
            String name = entry.getKey();
            if ("x".equals(name) || "y".equals(name) || "width".equals(name) || "height".equals(name) || "color".equals(name) || !(entry.getValue() instanceof String)) continue;
            xmlDump.append("      <metaData name=\"" + name + "\">" + EOL);
            xmlDump.append("        <value>" + entry.getValue() + "</value>" + EOL);
            xmlDump.append("      </metaData>" + EOL);
        }
    }

    protected void writeActions(String type, List<DroolsAction> actions, StringBuilder xmlDump) {
        if (actions != null && actions.size() > 0) {
            xmlDump.append("      <" + type + ">" + EOL);
            for (DroolsAction action : actions) {
                AbstractNodeHandler.writeAction(action, xmlDump);
            }
            xmlDump.append("      </" + type + ">" + EOL);
        }
    }

    public static void writeAction(DroolsAction action, StringBuilder xmlDump) {
        if (action instanceof DroolsConsequenceAction) {
            String consequence;
            String dialect;
            DroolsConsequenceAction consequenceAction = (DroolsConsequenceAction)action;
            xmlDump.append("        <action type=\"expression\" ");
            String name = consequenceAction.getName();
            if (name != null) {
                xmlDump.append("name=\"" + name + "\" ");
            }
            if ((dialect = consequenceAction.getDialect()) != null) {
                xmlDump.append("dialect=\"" + dialect + "\" ");
            }
            if ((consequence = consequenceAction.getConsequence()) == null) {
                xmlDump.append("/>" + EOL);
            } else {
                xmlDump.append(">" + XmlDumper.replaceIllegalChars(consequence.trim()) + "</action>" + EOL);
            }
        } else {
            throw new IllegalArgumentException("Unknown action " + action);
        }
    }

    public void writeTimers(Map<Timer, DroolsAction> timers, StringBuilder xmlDump) {
        if (timers != null && !timers.isEmpty()) {
            xmlDump.append("      <timers>" + EOL);
            ArrayList<Timer> timerList = new ArrayList<Timer>(timers.keySet());
            Collections.sort(timerList, new Comparator<Timer>(){

                @Override
                public int compare(Timer o1, Timer o2) {
                    return (int)(o2.getId() - o1.getId());
                }
            });
            for (Timer timer : timerList) {
                xmlDump.append("        <timer id=\"" + timer.getId() + "\" ");
                if (timer.getDelay() != null) {
                    xmlDump.append("delay=\"" + timer.getDelay() + "\" ");
                }
                if (timer.getPeriod() != null) {
                    xmlDump.append("period=\"" + timer.getPeriod() + "\" ");
                }
                xmlDump.append(">" + EOL);
                AbstractNodeHandler.writeAction(timers.get(timer), xmlDump);
                xmlDump.append("        </timer>" + EOL);
            }
            xmlDump.append("      </timers>" + EOL);
        }
    }

    protected void endNode(StringBuilder xmlDump) {
        xmlDump.append("/>" + EOL);
    }

    protected void endNode(String name, StringBuilder xmlDump) {
        xmlDump.append("    </" + name + ">" + EOL);
    }
}

