/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.instance.timer;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.timer.TimerInstance;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.TimerService;
import org.drools.time.impl.IntervalTrigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerManager {
    private long timerId = 0L;
    private WorkingMemory workingMemory;
    private TimerService timerService;
    private Map<Long, TimerInstance> timers = new HashMap<Long, TimerInstance>();
    private Job processJob = new ProcessJob();

    public TimerManager(WorkingMemory workingMemory, TimerService timerService) {
        this.workingMemory = workingMemory;
        this.timerService = timerService;
    }

    public void registerTimer(TimerInstance timer, ProcessInstance processInstance) {
        timer.setId(++this.timerId);
        timer.setProcessInstanceId(processInstance.getId());
        timer.setActivated(new Date());
        ProcessJobContext ctx = new ProcessJobContext(timer, processInstance.getId(), this.workingMemory);
        JobHandle jobHandle = this.timerService.scheduleJob(this.processJob, ctx, new IntervalTrigger(this.timerService.getCurrentTime(), null, null, -1, timer.getDelay(), timer.getPeriod(), null, null));
        timer.setJobHandle(jobHandle);
        this.timers.put(timer.getId(), timer);
    }

    public void internalAddTimer(TimerInstance timer) {
        long delay;
        ProcessJobContext ctx = new ProcessJobContext(timer, timer.getProcessInstanceId(), this.workingMemory);
        Date lastTriggered = timer.getLastTriggered();
        if (lastTriggered == null) {
            Date activated = timer.getActivated();
            Date now = new Date();
            long timespan = now.getTime() - activated.getTime();
            delay = timer.getDelay() - timespan;
            if (delay < 0L) {
                delay = 0L;
            }
        } else {
            Date now = new Date();
            long timespan = now.getTime() - lastTriggered.getTime();
            delay = timespan - timer.getPeriod();
            if (delay < 0L) {
                delay = 0L;
            }
        }
        JobHandle jobHandle = this.timerService.scheduleJob(this.processJob, ctx, new IntervalTrigger(this.timerService.getCurrentTime(), null, null, -1, delay, timer.getPeriod(), null, null));
        timer.setJobHandle(jobHandle);
        this.timers.put(timer.getId(), timer);
    }

    public void cancelTimer(long timerId) {
        TimerInstance timer = this.timers.remove(timerId);
        if (timer != null) {
            this.timerService.removeJob(timer.getJobHandle());
        }
    }

    public void dispose() {
        for (TimerInstance timer : this.timers.values()) {
            this.timerService.removeJob(timer.getJobHandle());
        }
        this.timerService.shutdown();
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public Collection<TimerInstance> getTimers() {
        return this.timers.values();
    }

    public long internalGetTimerId() {
        return this.timerId;
    }

    public void internalSetTimerId(long timerId) {
        this.timerId = timerId;
    }

    public void setTimerService(TimerService timerService) {
        this.timerService = timerService;
    }

    public static class ProcessJobContext
    implements JobContext {
        private Long processInstanceId;
        private WorkingMemory workingMemory;
        private TimerInstance timer;
        private JobHandle jobHandle;

        public ProcessJobContext(TimerInstance timer, Long processInstanceId, WorkingMemory workingMemory) {
            this.timer = timer;
            this.processInstanceId = processInstanceId;
            this.workingMemory = workingMemory;
        }

        public Long getProcessInstanceId() {
            return this.processInstanceId;
        }

        public WorkingMemory getWorkingMemory() {
            return this.workingMemory;
        }

        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public TimerInstance getTimer() {
            return this.timer;
        }
    }

    public class ProcessJob
    implements Job {
        public void execute(JobContext c) {
            ProcessJobContext ctx = (ProcessJobContext)c;
            Long processInstanceId = ctx.getProcessInstanceId();
            WorkingMemory workingMemory = ctx.getWorkingMemory();
            if (processInstanceId == null) {
                throw new IllegalArgumentException("Could not find process instance for timer ");
            }
            ctx.getTimer().setLastTriggered(new Date());
            workingMemory.getSignalManager().signalEvent(processInstanceId, "timerTriggered", ctx.getTimer());
            if (ctx.getTimer().getPeriod() == 0L) {
                TimerManager.this.timers.remove(ctx.getTimer().getId());
            }
        }
    }
}

