/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Date;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.drools.SystemEventListenerFactory;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.InternalWorkingMemory;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.SessionPseudoClock;
import org.drools.time.TimerService;
import org.drools.time.Trigger;
import org.drools.time.impl.DefaultJobHandle;

public class PseudoClockScheduler
implements TimerService,
SessionPseudoClock,
Externalizable {
    private volatile long timer = 0L;
    private PriorityQueue<ScheduledJob> queue = new PriorityQueue();
    private transient InternalWorkingMemory session;

    public PseudoClockScheduler() {
        this(null);
    }

    public PseudoClockScheduler(InternalWorkingMemory session) {
        this.session = session;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.timer = in.readLong();
        PriorityQueue tmp = (PriorityQueue)in.readObject();
        if (tmp != null) {
            this.queue = tmp;
        }
        this.session = ((DroolsObjectInputStream)in).getWorkingMemory();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.timer);
        out.writeObject(this.queue.isEmpty() ? null : this.queue);
    }

    public synchronized long getCurrentTime() {
        return this.timer;
    }

    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        Date date = trigger.hasNextFireTime();
        if (date != null) {
            ScheduledJob callableJob = new ScheduledJob(job, ctx, trigger);
            this.queue.add(callableJob);
            return callableJob.getHandle();
        }
        return null;
    }

    public boolean removeJob(JobHandle jobHandle) {
        return this.queue.remove(((DefaultJobHandle)jobHandle).getScheduledJob());
    }

    public synchronized long advanceTime(long amount, TimeUnit unit) {
        this.timer += unit.toMillis(amount);
        this.runCallBacks();
        return this.timer;
    }

    public synchronized void setStartupTime(int i) {
        this.timer = i;
    }

    public synchronized InternalWorkingMemory getSession() {
        return this.session;
    }

    public synchronized void setSession(InternalWorkingMemory session) {
        this.session = session;
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCallBacks() {
        long fireTime;
        ScheduledJob item = this.queue.peek();
        while (item != null && (fireTime = item.getTrigger().hasNextFireTime().getTime()) <= this.timer) {
            this.queue.remove();
            item.getTrigger().nextFireTime();
            if (item.getTrigger().hasNextFireTime() != null) {
                this.queue.add(item);
            }
            long savedTimer = this.timer;
            try {
                this.timer = fireTime;
                item.call();
            }
            catch (Exception e) {
                SystemEventListenerFactory.getSystemEventListener().exception(e);
            }
            finally {
                this.timer = savedTimer;
            }
            item = this.queue.peek();
        }
    }

    public synchronized long getTimeToNextJob() {
        ScheduledJob item = this.queue.peek();
        return item != null ? item.getTrigger().hasNextFireTime().getTime() - this.timer : -1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ScheduledJob
    implements Comparable<ScheduledJob>,
    Callable<Void>,
    Serializable {
        private static final long serialVersionUID = 510L;
        private final Job job;
        private final Trigger trigger;
        private final JobContext ctx;

        public ScheduledJob(Job job, JobContext context, Trigger trigger) {
            this.job = job;
            this.ctx = context;
            this.trigger = trigger;
        }

        @Override
        public int compareTo(ScheduledJob o) {
            return this.trigger.hasNextFireTime().compareTo(o.getTrigger().hasNextFireTime());
        }

        @Override
        public Void call() throws Exception {
            this.job.execute(this.ctx);
            return null;
        }

        public Job getJob() {
            return this.job;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public JobContext getCtx() {
            return this.ctx;
        }

        public JobHandle getHandle() {
            return new DefaultJobHandle(this);
        }

        public String toString() {
            return "ScheduledJob( job=" + this.job + " trigger=" + this.trigger + " context=" + this.ctx + " )";
        }
    }
}

