/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.scriptengines.groovy;

import com.google.code.scriptengines.groovy.GroovyScriptEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyScriptEngineFactory
implements ScriptEngineFactory {
    private static String VERSION = "1.5.6";
    private static List names = new ArrayList(1);
    private static List extensions;
    private static List mimeTypes;

    public String getEngineName() {
        return "groovy";
    }

    public String getEngineVersion() {
        return InvokerHelper.getVersion();
    }

    public String getLanguageName() {
        return "groovy";
    }

    public String getLanguageVersion() {
        return VERSION;
    }

    public List getExtensions() {
        return extensions;
    }

    public List getMimeTypes() {
        return mimeTypes;
    }

    public List getNames() {
        return names;
    }

    public Object getParameter(String key) {
        if ("javax.script.name".equals(key)) {
            return "Groovy";
        }
        if ("javax.script.engine".equals(key)) {
            return "Groovy Script Engine";
        }
        if ("javax.script.engine_version".equals(key)) {
            return InvokerHelper.getVersion();
        }
        if ("javax.script.language".equals(key)) {
            return "Groovy";
        }
        if ("javax.script.language_version".equals(key)) {
            return VERSION;
        }
        if ("THREADING".equals(key)) {
            return "MULTITHREADED";
        }
        throw new IllegalArgumentException("Invalid key");
    }

    public ScriptEngine getScriptEngine() {
        return new GroovyScriptEngine();
    }

    public String getMethodCallSyntax(String obj, String method, String[] args) {
        StringBuilder buf = new StringBuilder();
        buf.append(obj).append(".").append(method).append("(");
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(args[i]);
        }
        buf.append(")");
        return buf.toString();
    }

    public String getOutputStatement(String toDisplay) {
        StringBuilder buf = new StringBuilder();
        buf.append("println(\"");
        int len = toDisplay.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\"': {
                    buf.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append("\")");
        return buf.toString();
    }

    public String getProgram(String[] statements) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < statements.length; ++i) {
            ret.append(statements[i]);
            ret.append('\n');
        }
        return ret.toString();
    }

    static {
        names.add("groovy");
        names = Collections.unmodifiableList(names);
        extensions = names;
        mimeTypes = new ArrayList(0);
        mimeTypes = Collections.unmodifiableList(mimeTypes);
    }
}

