/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OsgiComponentResolver
implements ComponentResolver {
    private static final transient Log LOG = LogFactory.getLog(OsgiComponentResolver.class);
    private final BundleContext bundleContext;

    public OsgiComponentResolver(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Component resolveComponent(String name, CamelContext context) throws Exception {
        Object bean = null;
        try {
            bean = context.getRegistry().lookup(name);
            if (bean != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found component: " + name + " in registry: " + bean));
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Ignored error looking up bean: " + name + ". Error: " + e));
        }
        if (bean instanceof Component) {
            return (Component)bean;
        }
        return this.getComponent(name, context);
    }

    protected Component getComponent(String name, CamelContext context) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Finding Component: " + name));
        }
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(ComponentResolver.class.getName(), "(component=" + name + ")");
            if (refs != null && refs.length > 0) {
                ComponentResolver resolver = (ComponentResolver)this.bundleContext.getService(refs[0]);
                return resolver.resolveComponent(name, context);
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

