/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.core.xml.AbstractCamelEndpointFactoryBean;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderDefinition;
import org.apache.camel.core.xml.scan.PatternBasedPackageScanFilter;
import org.apache.camel.management.DefaultManagementAgent;
import org.apache.camel.management.DefaultManagementLifecycleStrategy;
import org.apache.camel.management.DefaultManagementStrategy;
import org.apache.camel.management.ManagedManagementStrategy;
import org.apache.camel.model.ContextScanDefinition;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PackageScanDefinition;
import org.apache.camel.model.RouteBuilderDefinition;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteContextRefDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.ThreadPoolProfileDefinition;
import org.apache.camel.model.config.PropertiesDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExecutorServiceStrategy;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementNamingStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelContextFactoryBean<T extends CamelContext>
extends IdentifiedType
implements RouteContainer {
    private static final Log LOG = LogFactory.getLog(AbstractCamelContextFactoryBean.class);
    @XmlTransient
    private List<RoutesBuilder> builders = new ArrayList<RoutesBuilder>();
    @XmlTransient
    private ClassLoader contextClassLoaderOnStart = Thread.currentThread().getContextClassLoader();

    public Object getObject() throws Exception {
        return this.getContext();
    }

    public Class getObjectType() {
        return CamelContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public ClassLoader getContextClassLoaderOnStart() {
        return this.contextClassLoaderOnStart;
    }

    public void afterPropertiesSet() throws Exception {
        Map lifecycleStrategies;
        Map interceptStrategies;
        ShutdownStrategy shutdownStrategy;
        Map endpointStrategies;
        Map eventNotifiers;
        EventFactory eventFactory;
        ManagementNamingStrategy managementNamingStrategy;
        ManagementStrategy managementStrategy;
        Delayer delayer;
        HandleFault handleFault;
        UuidGenerator uuidGenerator;
        Debugger debugger;
        ProcessorFactory processorFactory;
        ExecutorServiceStrategy executorServiceStrategy;
        FactoryFinderResolver factoryFinderResolver;
        ClassResolver classResolver;
        PackageScanClassResolver packageResolver;
        if (ObjectHelper.isEmpty((Object)this.getId())) {
            throw new IllegalArgumentException("Id must be set");
        }
        if (this.getProperties() != null) {
            this.getContext().setProperties(this.getProperties().asMap());
        }
        if (this.getLazyLoadTypeConverters() != null) {
            this.getContext().setLazyLoadTypeConverters(this.getLazyLoadTypeConverters());
        }
        if ((packageResolver = this.getBeanForType(PackageScanClassResolver.class)) != null) {
            LOG.info((Object)("Using custom PackageScanClassResolver: " + packageResolver));
            this.getContext().setPackageScanClassResolver(packageResolver);
        }
        if ((classResolver = this.getBeanForType(ClassResolver.class)) != null) {
            LOG.info((Object)("Using custom ClassResolver: " + classResolver));
            this.getContext().setClassResolver(classResolver);
        }
        if ((factoryFinderResolver = this.getBeanForType(FactoryFinderResolver.class)) != null) {
            LOG.info((Object)("Using custom FactoryFinderResolver: " + factoryFinderResolver));
            this.getContext().setFactoryFinderResolver(factoryFinderResolver);
        }
        if ((executorServiceStrategy = this.getBeanForType(ExecutorServiceStrategy.class)) != null) {
            LOG.info((Object)("Using custom ExecutorServiceStrategy: " + executorServiceStrategy));
            this.getContext().setExecutorServiceStrategy(executorServiceStrategy);
        }
        if ((processorFactory = this.getBeanForType(ProcessorFactory.class)) != null) {
            LOG.info((Object)("Using custom ProcessorFactory: " + processorFactory));
            this.getContext().setProcessorFactory(processorFactory);
        }
        if ((debugger = this.getBeanForType(Debugger.class)) != null) {
            LOG.info((Object)("Using custom Debugger: " + debugger));
            this.getContext().setDebugger(debugger);
        }
        if ((uuidGenerator = this.getBeanForType(UuidGenerator.class)) != null) {
            LOG.info((Object)("Using custom UuidGenerator: " + uuidGenerator));
            this.getContext().setUuidGenerator(uuidGenerator);
        }
        this.initCustomRegistry(this.getContext());
        this.initPropertyPlaceholder();
        this.initJMXAgent();
        Tracer tracer = this.getBeanForType(Tracer.class);
        if (tracer != null) {
            TraceFormatter formatter = this.getBeanForType(TraceFormatter.class);
            if (formatter != null) {
                tracer.setFormatter(formatter);
            }
            LOG.info((Object)("Using custom Tracer: " + tracer));
            this.getContext().addInterceptStrategy((InterceptStrategy)tracer);
        }
        if ((handleFault = this.getBeanForType(HandleFault.class)) != null) {
            LOG.info((Object)("Using custom HandleFault: " + handleFault));
            this.getContext().addInterceptStrategy((InterceptStrategy)handleFault);
        }
        if ((delayer = this.getBeanForType(Delayer.class)) != null) {
            LOG.info((Object)("Using custom Delayer: " + delayer));
            this.getContext().addInterceptStrategy((InterceptStrategy)delayer);
        }
        InflightRepository inflightRepository = this.getBeanForType(InflightRepository.class);
        if (delayer != null) {
            LOG.info((Object)("Using custom InflightRepository: " + inflightRepository));
            this.getContext().setInflightRepository(inflightRepository);
        }
        if ((managementStrategy = this.getBeanForType(ManagementStrategy.class)) != null) {
            LOG.info((Object)("Using custom ManagementStrategy: " + managementStrategy));
            this.getContext().setManagementStrategy(managementStrategy);
        }
        if ((managementNamingStrategy = this.getBeanForType(ManagementNamingStrategy.class)) != null) {
            LOG.info((Object)("Using custom ManagementNamingStrategy: " + managementNamingStrategy));
            this.getContext().getManagementStrategy().setManagementNamingStrategy(managementNamingStrategy);
        }
        if ((eventFactory = this.getBeanForType(EventFactory.class)) != null) {
            LOG.info((Object)("Using custom EventFactory: " + eventFactory));
            this.getContext().getManagementStrategy().setEventFactory(eventFactory);
        }
        if ((eventNotifiers = this.getContext().getRegistry().lookupByType(EventNotifier.class)) != null && !eventNotifiers.isEmpty()) {
            for (Map.Entry entry : eventNotifiers.entrySet()) {
                EventNotifier notifier = (EventNotifier)entry.getValue();
                if (this.getContext().getManagementStrategy().getEventNotifiers().contains(notifier)) continue;
                LOG.info((Object)("Using custom EventNotifier with id: " + (String)entry.getKey() + " and implementation: " + notifier));
                this.getContext().getManagementStrategy().addEventNotifier(notifier);
            }
        }
        if ((endpointStrategies = this.getContext().getRegistry().lookupByType(EndpointStrategy.class)) != null && !endpointStrategies.isEmpty()) {
            for (Map.Entry entry : endpointStrategies.entrySet()) {
                EndpointStrategy strategy = (EndpointStrategy)entry.getValue();
                LOG.info((Object)("Using custom EndpointStrategy with id: " + (String)entry.getKey() + " and implementation: " + strategy));
                this.getContext().addRegisterEndpointCallback(strategy);
            }
        }
        if ((shutdownStrategy = this.getBeanForType(ShutdownStrategy.class)) != null) {
            LOG.info((Object)("Using custom ShutdownStrategy: " + shutdownStrategy));
            this.getContext().setShutdownStrategy(shutdownStrategy);
        }
        if ((interceptStrategies = this.getContext().getRegistry().lookupByType(InterceptStrategy.class)) != null && !interceptStrategies.isEmpty()) {
            for (Map.Entry entry : interceptStrategies.entrySet()) {
                InterceptStrategy strategy = (InterceptStrategy)entry.getValue();
                if (this.getContext().getInterceptStrategies().contains(strategy)) continue;
                LOG.info((Object)("Using custom InterceptStrategy with id: " + (String)entry.getKey() + " and implementation: " + strategy));
                this.getContext().addInterceptStrategy(strategy);
            }
        }
        if ((lifecycleStrategies = this.getContext().getRegistry().lookupByType(LifecycleStrategy.class)) != null && !lifecycleStrategies.isEmpty()) {
            for (Map.Entry entry : lifecycleStrategies.entrySet()) {
                LifecycleStrategy strategy = (LifecycleStrategy)entry.getValue();
                if (this.getContext().getLifecycleStrategies().contains(strategy)) continue;
                LOG.info((Object)("Using custom LifecycleStrategy with id: " + (String)entry.getKey() + " and implementation: " + strategy));
                this.getContext().addLifecycleStrategy(strategy);
            }
        }
        this.initThreadPoolProfiles(this.getContext());
        this.initBeanPostProcessor(this.getContext());
        this.initCamelContext(this.getContext());
        this.initRouteRefs();
        this.prepareRoutes();
        this.getContext().addRouteDefinitions(this.getRoutes());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found JAXB created routes: " + this.getRoutes()));
        }
        this.findRouteBuilders();
        this.installRoutes();
    }

    private void prepareRoutes() {
        for (RouteDefinition route : this.getRoutes()) {
            RouteDefinitionHelper.prepareRoute((RouteDefinition)route, this.getOnExceptions(), this.getIntercepts(), this.getInterceptFroms(), this.getInterceptSendToEndpoints(), this.getOnCompletions());
            route.markPrepared();
        }
    }

    protected abstract void initCustomRegistry(T var1);

    private void initJMXAgent() throws Exception {
        CamelJMXAgentDefinition camelJMXAgent = this.getCamelJMXAgent();
        boolean disabled = false;
        if (camelJMXAgent != null) {
            disabled = CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getDisabled());
        }
        if (disabled) {
            LOG.info((Object)"JMXAgent disabled");
            this.getContext().getLifecycleStrategies().clear();
            this.getContext().setManagementStrategy((ManagementStrategy)new DefaultManagementStrategy());
        } else if (camelJMXAgent != null) {
            LOG.info((Object)("JMXAgent enabled: " + (Object)((Object)camelJMXAgent)));
            DefaultManagementAgent agent = new DefaultManagementAgent(this.getContext());
            agent.setConnectorPort(CamelContextHelper.parseInteger(this.getContext(), (String)camelJMXAgent.getConnectorPort()));
            agent.setCreateConnector(CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getCreateConnector()));
            agent.setMBeanObjectDomainName(CamelContextHelper.parseText(this.getContext(), (String)camelJMXAgent.getMbeanObjectDomainName()));
            agent.setMBeanServerDefaultDomain(CamelContextHelper.parseText(this.getContext(), (String)camelJMXAgent.getMbeanServerDefaultDomain()));
            agent.setRegistryPort(CamelContextHelper.parseInteger(this.getContext(), (String)camelJMXAgent.getRegistryPort()));
            agent.setServiceUrlPath(CamelContextHelper.parseText(this.getContext(), (String)camelJMXAgent.getServiceUrlPath()));
            agent.setUsePlatformMBeanServer(CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getUsePlatformMBeanServer()));
            agent.setOnlyRegisterProcessorWithCustomId(CamelContextHelper.parseBoolean(this.getContext(), (String)camelJMXAgent.getOnlyRegisterProcessorWithCustomId()));
            ManagedManagementStrategy managementStrategy = new ManagedManagementStrategy((ManagementAgent)agent);
            this.getContext().setManagementStrategy((ManagementStrategy)managementStrategy);
            this.getContext().getLifecycleStrategies().clear();
            this.getContext().addLifecycleStrategy((LifecycleStrategy)new DefaultManagementLifecycleStrategy(this.getContext()));
            boolean onlyId = agent.getOnlyRegisterProcessorWithCustomId() != null && agent.getOnlyRegisterProcessorWithCustomId() != false;
            this.getContext().getManagementStrategy().onlyManageProcessorWithCustomId(onlyId);
            this.getContext().getManagementStrategy().setStatisticsLevel(camelJMXAgent.getStatisticsLevel());
        }
    }

    private void initPropertyPlaceholder() throws Exception {
        if (this.getCamelPropertyPlaceholder() != null) {
            CamelPropertyPlaceholderDefinition def = this.getCamelPropertyPlaceholder();
            PropertiesComponent pc = new PropertiesComponent();
            pc.setLocation(def.getLocation());
            if (ObjectHelper.isNotEmpty((Object)def.getPropertiesResolverRef())) {
                PropertiesResolver resolver = (PropertiesResolver)CamelContextHelper.mandatoryLookup(this.getContext(), (String)def.getPropertiesResolverRef(), PropertiesResolver.class);
                pc.setPropertiesResolver(resolver);
            }
            if (ObjectHelper.isNotEmpty((Object)def.getPropertiesParserRef())) {
                PropertiesParser parser = (PropertiesParser)CamelContextHelper.mandatoryLookup(this.getContext(), (String)def.getPropertiesParserRef(), PropertiesParser.class);
                pc.setPropertiesParser(parser);
            }
            this.getContext().addComponent("properties", (Component)pc);
        }
    }

    private void initRouteRefs() throws Exception {
        if (this.getRouteRefs() != null) {
            for (RouteContextRefDefinition ref : this.getRouteRefs()) {
                List defs = ref.lookupRoutes(this.getContext());
                for (RouteDefinition def : defs) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Adding route from " + ref + " -> " + def));
                    }
                    this.getRoutes().add(0, def);
                }
            }
        }
    }

    protected abstract <S> S getBeanForType(Class<S> var1);

    public void destroy() throws Exception {
        this.getContext().stop();
    }

    public T getContext() {
        return this.getContext(true);
    }

    public abstract T getContext(boolean var1);

    public abstract List<RouteDefinition> getRoutes();

    public abstract List<? extends AbstractCamelEndpointFactoryBean> getEndpoints();

    public abstract List<InterceptDefinition> getIntercepts();

    public abstract List<InterceptFromDefinition> getInterceptFroms();

    public abstract List<InterceptSendToEndpointDefinition> getInterceptSendToEndpoints();

    public abstract PropertiesDefinition getProperties();

    public abstract String[] getPackages();

    public abstract PackageScanDefinition getPackageScan();

    public abstract void setPackageScan(PackageScanDefinition var1);

    public abstract ContextScanDefinition getContextScan();

    public abstract void setContextScan(ContextScanDefinition var1);

    public abstract CamelPropertyPlaceholderDefinition getCamelPropertyPlaceholder();

    public abstract String getTrace();

    public abstract String getStreamCache();

    public abstract String getDelayer();

    public abstract String getHandleFault();

    public abstract String getAutoStartup();

    public abstract Boolean getLazyLoadTypeConverters();

    public abstract CamelJMXAgentDefinition getCamelJMXAgent();

    public abstract List<RouteBuilderDefinition> getBuilderRefs();

    public abstract List<RouteContextRefDefinition> getRouteRefs();

    public abstract String getErrorHandlerRef();

    public abstract DataFormatsDefinition getDataFormats();

    public abstract List<OnExceptionDefinition> getOnExceptions();

    public abstract List<OnCompletionDefinition> getOnCompletions();

    public abstract ShutdownRoute getShutdownRoute();

    public abstract ShutdownRunningTask getShutdownRunningTask();

    public abstract List<ThreadPoolProfileDefinition> getThreadPoolProfiles();

    public abstract String getDependsOn();

    protected void initCamelContext(T ctx) throws Exception {
        if (this.getStreamCache() != null) {
            ctx.setStreamCaching(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getStreamCache()));
        }
        if (this.getTrace() != null) {
            ctx.setTracing(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getTrace()));
        }
        if (this.getDelayer() != null) {
            ctx.setDelayer(CamelContextHelper.parseLong(this.getContext(), (String)this.getDelayer()));
        }
        if (this.getHandleFault() != null) {
            ctx.setHandleFault(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getHandleFault()));
        }
        if (this.getErrorHandlerRef() != null) {
            ctx.setErrorHandlerBuilder((ErrorHandlerBuilder)new ErrorHandlerBuilderRef(this.getErrorHandlerRef()));
        }
        if (this.getAutoStartup() != null) {
            ctx.setAutoStartup(CamelContextHelper.parseBoolean(this.getContext(), (String)this.getAutoStartup()));
        }
        if (this.getShutdownRoute() != null) {
            ctx.setShutdownRoute(this.getShutdownRoute());
        }
        if (this.getShutdownRunningTask() != null) {
            ctx.setShutdownRunningTask(this.getShutdownRunningTask());
        }
        if (this.getDataFormats() != null) {
            ctx.setDataFormats(this.getDataFormats().asMap());
        }
    }

    private void initThreadPoolProfiles(T context) {
        HashSet<Object> defaultIds = new HashSet<Object>();
        Map profiles = context.getRegistry().lookupByType(ThreadPoolProfile.class);
        if (profiles != null && !profiles.isEmpty()) {
            for (Map.Entry entry : profiles.entrySet()) {
                ThreadPoolProfile profile = (ThreadPoolProfile)entry.getValue();
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info((Object)("Using custom default ThreadPoolProfile with id: " + (String)entry.getKey() + " and implementation: " + profile));
                    context.getExecutorServiceStrategy().setDefaultThreadPoolProfile(profile);
                    defaultIds.add(entry.getKey());
                    continue;
                }
                context.getExecutorServiceStrategy().registerThreadPoolProfile(profile);
            }
        }
        if (this.getThreadPoolProfiles() != null && !this.getThreadPoolProfiles().isEmpty()) {
            for (ThreadPoolProfileDefinition profile : this.getThreadPoolProfiles()) {
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info((Object)("Using custom default ThreadPoolProfile with id: " + profile.getId() + " and implementation: " + profile));
                    context.getExecutorServiceStrategy().setDefaultThreadPoolProfile((ThreadPoolProfile)profile);
                    defaultIds.add(profile.getId());
                    continue;
                }
                context.getExecutorServiceStrategy().registerThreadPoolProfile((ThreadPoolProfile)profile);
            }
        }
        if (defaultIds.size() > 1) {
            throw new IllegalArgumentException("Only exactly one default ThreadPoolProfile is allowed, was " + defaultIds.size() + " ids: " + defaultIds);
        }
    }

    protected abstract void initBeanPostProcessor(T var1);

    protected void installRoutes() throws Exception {
        ArrayList<RouteBuilder> builders = new ArrayList<RouteBuilder>();
        if (this.getBuilderRefs() != null) {
            for (RouteBuilderDefinition builderRef : this.getBuilderRefs()) {
                RouteBuilder builder = builderRef.createRouteBuilder(this.getContext());
                if (builder != null) {
                    builders.add(builder);
                    continue;
                }
                RoutesBuilder routes = builderRef.createRoutes(this.getContext());
                if (routes != null) {
                    this.builders.add(routes);
                    continue;
                }
                throw new CamelException("Cannot find any routes with this RouteBuilder reference: " + builderRef);
            }
        }
        for (RoutesBuilder routeBuilder : this.builders) {
            this.getContext().addRoutes(routeBuilder);
        }
        for (RouteBuilder builder : builders) {
            this.postProcessBeforeInit(builder);
            this.getContext().addRoutes((RoutesBuilder)builder);
        }
    }

    protected abstract void postProcessBeforeInit(RouteBuilder var1);

    protected void findRouteBuilders() throws Exception {
        ContextScanDefinition contextScanDef;
        this.addPackageElementContentsToScanDefinition();
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (packageScanDef != null && packageScanDef.getPackages().size() > 0) {
            PatternBasedPackageScanFilter filter = new PatternBasedPackageScanFilter();
            for (String include : packageScanDef.getIncludes()) {
                include = this.getContext().resolvePropertyPlaceholders(include);
                filter.addIncludePattern(include);
            }
            for (String exclude : packageScanDef.getExcludes()) {
                exclude = this.getContext().resolvePropertyPlaceholders(exclude);
                filter.addExcludePattern(exclude);
            }
            String[] normalized = this.normalizePackages(this.getContext(), packageScanDef.getPackages());
            this.findRouteBuildersByPackageScan(normalized, filter, this.builders);
        }
        if ((contextScanDef = this.getContextScan()) != null) {
            PatternBasedPackageScanFilter filter = new PatternBasedPackageScanFilter();
            for (String include : contextScanDef.getIncludes()) {
                include = this.getContext().resolvePropertyPlaceholders(include);
                filter.addIncludePattern(include);
            }
            for (String exclude : contextScanDef.getExcludes()) {
                exclude = this.getContext().resolvePropertyPlaceholders(exclude);
                filter.addExcludePattern(exclude);
            }
            this.findRouteBuildersByContextScan(filter, this.builders);
        }
    }

    protected abstract void findRouteBuildersByPackageScan(String[] var1, PackageScanFilter var2, List<RoutesBuilder> var3) throws Exception;

    protected abstract void findRouteBuildersByContextScan(PackageScanFilter var1, List<RoutesBuilder> var2) throws Exception;

    private void addPackageElementContentsToScanDefinition() {
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (this.getPackages() != null && this.getPackages().length > 0) {
            if (packageScanDef == null) {
                packageScanDef = new PackageScanDefinition();
                this.setPackageScan(packageScanDef);
            }
            for (String pkg : this.getPackages()) {
                packageScanDef.getPackages().add(pkg);
            }
        }
    }

    private String[] normalizePackages(T context, List<String> unnormalized) throws Exception {
        ArrayList<String> packages = new ArrayList<String>();
        for (String name : unnormalized) {
            name = context.resolvePropertyPlaceholders(name);
            if (!ObjectHelper.isNotEmpty((Object)(name = ObjectHelper.normalizeClassName((String)name)))) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Using package: " + name + " to scan for RouteBuilder classes"));
            }
            packages.add(name);
        }
        return packages.toArray(new String[packages.size()]);
    }
}

