/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.mail.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.mail.utils.MailConnectionConfiguration;
import org.apache.servicemix.mail.utils.MailContentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MailUtils {
    private static final Log log = LogFactory.getLog(MailUtils.class);
    public static final String KEY_BODY_TEXT = "text";
    public static final String KEY_BODY_HTML = "html";
    public static final String SSL_FACTORY = "org.apache.servicemix.mail.security.CustomSSLSocketFactory";
    public static final int DEFAULT_PORT_SMTP = 25;
    public static final int DEFAULT_PORT_SMTPS = 465;
    public static final int DEFAULT_PORT_POP3 = 110;
    public static final int DEFAULT_PORT_POP3S = 995;
    public static final int DEFAULT_PORT_NNTP = 119;
    public static final int DEFAULT_PORT_IMAP = 143;
    public static final int DEFAULT_PORT_IMAPS = 993;
    public static final String PROTOCOL_SMTP = "smtp";
    public static final String PROTOCOL_SMTPS = "smtps";
    public static final String PROTOCOL_POP = "pop";
    public static final String PROTOCOL_POP3 = "pop3";
    public static final String PROTOCOL_POP3S = "pop3s";
    public static final String PROTOCOL_NNTP = "nntp";
    public static final String PROTOCOL_IMAP = "imap";
    public static final String PROTOCOL_IMAPS = "imaps";
    private static final String MAIL_PREFIX = "mail.";
    private static final String DEFAULT_INBOX = "INBOX";
    private static final String URI_PASSWORD_PART = "password=";
    private static final String URI_USER_PART = "user=";
    public static final String CONNECTION_TIMEOUT = "10000";

    private MailUtils() {
    }

    public static int getDefaultPortForProtocol(String protocol) {
        int port = 25;
        if (protocol != null) {
            port = protocol.equalsIgnoreCase(PROTOCOL_IMAP) ? 143 : (protocol.equalsIgnoreCase(PROTOCOL_IMAPS) ? 993 : (protocol.equalsIgnoreCase(PROTOCOL_NNTP) ? 119 : (protocol.equalsIgnoreCase(PROTOCOL_POP) || protocol.equalsIgnoreCase(PROTOCOL_POP3) ? 110 : (protocol.equalsIgnoreCase(PROTOCOL_POP3S) ? 995 : (protocol.equalsIgnoreCase(PROTOCOL_SMTP) ? 25 : (protocol.equalsIgnoreCase(PROTOCOL_SMTPS) ? 465 : 25))))));
        }
        return port;
    }

    public static MailConnectionConfiguration configure(String uriString) throws ParseException {
        int endIndex;
        int beginIndex;
        int port;
        String scheme;
        MailConnectionConfiguration config = new MailConnectionConfiguration();
        if (uriString == null || uriString.length() <= 0) {
            throw new ParseException("The given connection uri (" + uriString + ") is invalid.");
        }
        URI uri = URI.create(uriString);
        String value = uri.getHost();
        if (value != null) {
            config.setHost(value);
        }
        if ((scheme = uri.getScheme()) != null) {
            config.setProtocol(scheme);
        } else {
            config.setProtocol(PROTOCOL_SMTP);
        }
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            config.setUsername(userInfo);
        }
        if ((port = uri.getPort()) >= 0) {
            config.setPort(port);
        } else {
            config.setPort(MailUtils.getDefaultPortForProtocol(config.getProtocol()));
        }
        if (uri.getPath() != null && uri.getPath().length() > 0) {
            if (uri.getPath().startsWith("/")) {
                config.setFolderName(uri.getPath().substring(1));
            } else {
                config.setFolderName(uri.getPath());
            }
        } else {
            config.setFolderName(DEFAULT_INBOX);
        }
        if (uri.getQuery() != null && uri.getQuery().indexOf(URI_PASSWORD_PART) != -1) {
            beginIndex = uri.getQuery().indexOf(URI_PASSWORD_PART) + URI_PASSWORD_PART.length();
            endIndex = uri.getQuery().indexOf(59, beginIndex + 1) != -1 ? uri.getQuery().indexOf(59, beginIndex + 1) : uri.getQuery().length();
            config.setPassword(uri.getQuery().substring(beginIndex, endIndex));
        } else {
            config.setPassword("");
        }
        if (userInfo == null) {
            if (uri.getQuery() != null && uri.getQuery().indexOf(URI_USER_PART) != -1) {
                beginIndex = uri.getQuery().indexOf(URI_USER_PART) + URI_USER_PART.length();
                endIndex = uri.getQuery().indexOf(59, beginIndex + 1) != -1 ? uri.getQuery().indexOf(59, beginIndex + 1) : uri.getQuery().length();
                config.setUsername(uri.getQuery().substring(beginIndex, endIndex));
            } else {
                config.setUsername("");
            }
        }
        return config;
    }

    public static Properties getPropertiesForProtocol(MailConnectionConfiguration config, String customTrustManagers) {
        Properties mailConnectionProperties = (Properties)System.getProperties().clone();
        mailConnectionProperties.put(MAIL_PREFIX + config.getProtocol() + ".connectiontimeout", CONNECTION_TIMEOUT);
        mailConnectionProperties.put(MAIL_PREFIX + config.getProtocol() + ".timeout", CONNECTION_TIMEOUT);
        mailConnectionProperties.put(MAIL_PREFIX + config.getProtocol() + ".host", config.getHost());
        mailConnectionProperties.put(MAIL_PREFIX + config.getProtocol() + ".port", "" + config.getPort());
        mailConnectionProperties.put(MAIL_PREFIX + config.getProtocol() + ".user", config.getUsername());
        mailConnectionProperties.put(MAIL_PREFIX + config.getProtocol() + ".rsetbeforequit", "true");
        mailConnectionProperties.put(MAIL_PREFIX + config.getProtocol() + ".auth", "true");
        mailConnectionProperties.put("mail.transport.protocol", config.getProtocol());
        mailConnectionProperties.put("mail.store.protocol", config.getProtocol());
        mailConnectionProperties.put("mail.host", config.getHost());
        mailConnectionProperties.put("mail.user", config.getUsername());
        if (customTrustManagers != null && customTrustManagers.trim().length() > 0 && config.isSecureProtocol()) {
            mailConnectionProperties.put(MAIL_PREFIX + config.getProtocol() + ".socketFactory.class", SSL_FACTORY);
            mailConnectionProperties.put(MAIL_PREFIX + config.getProtocol() + ".socketFactory.fallback", "false");
            mailConnectionProperties.put(MAIL_PREFIX + config.getProtocol() + ".socketFactory.port", "" + config.getPort());
            System.getProperties().put("custom-trust-managers", customTrustManagers);
        }
        return mailConnectionProperties;
    }

    public static Object extractBodyFromMail(Message message) {
        try {
            return message.getContent();
        }
        catch (UnsupportedEncodingException e) {
            return "Unable to decode the mail because charset is not supported: " + e.getMessage();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to extract body due to: " + e.getMessage() + ". Message: " + message, e);
        }
    }

    public static void extractHeadersFromMail(NormalizedMessage nmsg, MimeMessage mailMsg) throws javax.mail.MessagingException {
        Enumeration headers = mailMsg.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            if (nmsg.getProperty(header.getName()) != null) {
                try {
                    nmsg.setProperty(header.getName(), nmsg.getProperty(header.getName() + ";" + MimeUtility.decodeText((String)header.getValue())));
                }
                catch (UnsupportedEncodingException e) {
                    nmsg.setProperty(header.getName(), nmsg.getProperty(header.getName() + ";" + header.getValue()));
                }
            } else {
                try {
                    nmsg.setProperty(header.getName(), (Object)MimeUtility.decodeText((String)header.getValue()));
                }
                catch (UnsupportedEncodingException e) {
                    nmsg.setProperty(header.getName(), (Object)header.getValue());
                }
            }
            try {
                log.debug((Object)("Setting property: " + header.getName() + " = " + MimeUtility.decodeText((String)header.getValue())));
            }
            catch (UnsupportedEncodingException e) {
                log.debug((Object)("Setting property: " + header.getName() + " = " + header.getValue()));
            }
        }
        if (mailMsg.getContentType() != null) {
            if (mailMsg.isMimeType(MailContentType.TEXT_PLAIN.getMimeType())) {
                nmsg.setProperty("org.apache.servicemix.mail.type", (Object)MailContentType.TEXT_PLAIN.getMimeType());
            } else if (mailMsg.isMimeType(MailContentType.TEXT_HTML.getMimeType())) {
                nmsg.setProperty("org.apache.servicemix.mail.type", (Object)MailContentType.TEXT_HTML.getMimeType());
            } else if (mailMsg.isMimeType(MailContentType.TEXT_XML.getMimeType())) {
                nmsg.setProperty("org.apache.servicemix.mail.type", (Object)MailContentType.TEXT_XML.getMimeType());
            } else if (mailMsg.isMimeType(MailContentType.MULTIPART_ALTERNATIVE.getMimeType())) {
                nmsg.setProperty("org.apache.servicemix.mail.type", (Object)MailContentType.MULTIPART_ALTERNATIVE.getMimeType());
            } else if (mailMsg.isMimeType(MailContentType.MULTIPART_MIXED.getMimeType())) {
                nmsg.setProperty("org.apache.servicemix.mail.type", (Object)MailContentType.MULTIPART_MIXED.getMimeType());
            } else if (mailMsg.isMimeType(MailContentType.MULTIPART.getMimeType())) {
                nmsg.setProperty("org.apache.servicemix.mail.type", (Object)MailContentType.MULTIPART.getMimeType());
            } else {
                nmsg.setProperty("org.apache.servicemix.mail.type", (Object)MailContentType.UNKNOWN.getMimeType());
            }
        }
        if (nmsg.getProperty("Bcc") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.bcc", nmsg.getProperty("Bcc"));
        }
        if (nmsg.getProperty("Cc") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.cc", nmsg.getProperty("Cc"));
        }
        if (nmsg.getProperty("From") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.from", nmsg.getProperty("From"));
        }
        if (nmsg.getProperty("Reply-To") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.replyto", nmsg.getProperty("Reply-To"));
        }
        if (nmsg.getProperty("Date") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.sentdate", nmsg.getProperty("Date"));
        }
        if (nmsg.getProperty("Subject") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.subject", nmsg.getProperty("Subject"));
        }
        if (nmsg.getProperty("To") != null) {
            nmsg.setProperty("org.apache.servicemix.mail.to", nmsg.getProperty("To"));
        }
    }

    public static void extractAttachmentsFromMultipart(Multipart mp, NormalizedMessage nmsg) throws javax.mail.MessagingException, MessagingException, IOException {
        for (int i = 0; i < mp.getCount(); ++i) {
            MimeBodyPart part = (MimeBodyPart)mp.getBodyPart(i);
            if (part.isMimeType(MailContentType.MULTIPART.getMimeType())) {
                try {
                    Multipart mup = (Multipart)part.getContent();
                    MailUtils.extractAttachmentsFromMultipart(mup, nmsg);
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)"Unable to decode the mail because charset is not supported.", (Throwable)e);
                }
                continue;
            }
            if (i < 1) continue;
            String disposition = part.getDisposition();
            if (disposition != null && disposition.equalsIgnoreCase("attachment")) {
                String name = part.getFileName();
                if (name != null) {
                    try {
                        name = MimeUtility.decodeText((String)name);
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                    nmsg.addAttachment(name, part.getDataHandler());
                    continue;
                }
                if (part.getDataHandler() == null) continue;
                nmsg.addAttachment(disposition, part.getDataHandler());
                continue;
            }
            if (disposition == null || !disposition.equalsIgnoreCase("inline")) continue;
            String contentID = part.getContentID();
            if (contentID != null) {
                contentID = contentID.replace('<', ' ');
                contentID = contentID.replace('>', ' ');
                contentID = contentID.trim();
            } else {
                contentID = part.getFileName();
            }
            contentID = "cid:" + contentID;
            String name = part.getFileName();
            if (name != null) {
                try {
                    name = MimeUtility.decodeText((String)name);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                nmsg.addAttachment(contentID, part.getDataHandler());
                nmsg.setProperty(contentID, (Object)name);
                continue;
            }
            if (part.getDataHandler() == null) continue;
            nmsg.addAttachment(contentID, part.getDataHandler());
            nmsg.setProperty(contentID, (Object)contentID);
        }
    }

    public static Map<String, String> extractBodyFromMultipart(Multipart mp, NormalizedMessage nmsg) throws javax.mail.MessagingException, IOException {
        HashMap<String, String> content = new HashMap<String, String>();
        for (int i = 0; i < mp.getCount(); ++i) {
            BodyPart part = mp.getBodyPart(i);
            String disposition = part.getDisposition();
            if (disposition != null) continue;
            if (part.isMimeType(MailContentType.MULTIPART.getMimeType())) {
                try {
                    Multipart mup = (Multipart)part.getContent();
                    Map<String, String> res = MailUtils.extractBodyFromMultipart(mup, nmsg);
                    for (String key : res.keySet()) {
                        if (content.containsKey(key)) {
                            content.put(key, (String)content.get(key) + '\n' + res.get(key));
                            continue;
                        }
                        content.put(key, res.get(key));
                    }
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)"Unable to decode the mail because charset is not supported.", (Throwable)e);
                    continue;
                }
            }
            if (part.isMimeType(MailContentType.TEXT_PLAIN.getMimeType())) {
                try {
                    content.put(KEY_BODY_TEXT, (String)part.getContent());
                }
                catch (UnsupportedEncodingException e) {
                    content.put(KEY_BODY_TEXT, "<no-content />");
                    log.error((Object)"Unable to decode the mail because charset is not supported.", (Throwable)e);
                }
                continue;
            }
            if (!part.isMimeType(MailContentType.TEXT_HTML.getMimeType()) && !part.isMimeType(MailContentType.TEXT_XML.getMimeType())) continue;
            try {
                content.put(KEY_BODY_HTML, (String)part.getContent());
                continue;
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Unable to decode the mail because charset is not supported.", (Throwable)e);
            }
        }
        if (content.size() == 2 && !nmsg.getProperty("org.apache.servicemix.mail.type").toString().equalsIgnoreCase(MailContentType.MULTIPART_ALTERNATIVE.getMimeType())) {
            nmsg.setProperty("org.apache.servicemix.mail.type", (Object)MailContentType.MULTIPART_ALTERNATIVE.getKey());
        }
        return content;
    }

    public static void parsePart(MimeBodyPart mbp, NormalizedMessage nmsg) throws MessagingException, javax.mail.MessagingException, IOException {
        Object subContent = mbp.getContent();
        log.debug((Object)("Parsing: " + subContent.getClass().getName()));
        if (subContent instanceof InputStream) {
            String cid = mbp.getContentID();
            if (cid != null) {
                cid = cid.replaceAll("<", "").replaceAll(">", "").toLowerCase();
            }
            log.debug((Object)("Adding special attachment: " + (mbp.getFileName() != null ? mbp.getFileName() : cid)));
            byte[] data = new byte[mbp.getSize()];
            InputStream stream = (InputStream)subContent;
            stream.read(data);
            ByteArrayDataSource bads = new ByteArrayDataSource(data, mbp.getContentType());
            bads.setName(mbp.getFileName() != null ? mbp.getFileName() : cid);
            nmsg.addAttachment(bads.getName(), new DataHandler((DataSource)bads));
            if (cid != null) {
                nmsg.setProperty(cid, (Object)mbp.getFileName());
            }
        }
    }

    public static void extractBodyFromMail(NormalizedMessage nmsg, MimeMessage mailMsg) throws javax.mail.MessagingException, MessagingException {
        Object content = MailUtils.extractBodyFromMail((Message)mailMsg);
        String text = null;
        String html = null;
        if (content == null) {
            nmsg.setProperty("org.apache.servicemix.mail.text", (Object)"<no-content />");
            return;
        }
        if (mailMsg.isMimeType(MailContentType.TEXT_PLAIN.getMimeType())) {
            text = (String)content;
        } else if (mailMsg.isMimeType(MailContentType.TEXT_HTML.getMimeType()) || mailMsg.isMimeType(MailContentType.TEXT_XML.getMimeType())) {
            html = (String)content;
        } else if (mailMsg.isMimeType(MailContentType.MULTIPART.getMimeType())) {
            Multipart mp = (Multipart)content;
            try {
                Map<String, String> parts = MailUtils.extractBodyFromMultipart(mp, nmsg);
                if (parts.containsKey(KEY_BODY_TEXT)) {
                    text = parts.get(KEY_BODY_TEXT);
                }
                if (parts.containsKey(KEY_BODY_HTML)) {
                    html = parts.get(KEY_BODY_HTML);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error extracting body from message " + mailMsg), (Throwable)e);
            }
        }
        if (!(html != null && html.trim().length() >= 1 || text != null && text.trim().length() >= 1)) {
            text = "<no-content />";
        }
        if (text != null) {
            nmsg.setProperty("org.apache.servicemix.mail.text", (Object)text);
        }
        if (html != null) {
            nmsg.setProperty("org.apache.servicemix.mail.html", (Object)html);
            nmsg.setContent((Source)new StringSource(html));
        }
    }

    public static void extractAttachmentsFromMail(NormalizedMessage nmsg, MimeMessage mailMsg) {
        Object content = MailUtils.extractBodyFromMail((Message)mailMsg);
        if (content != null && content instanceof Multipart) {
            Multipart mp = (Multipart)content;
            try {
                MailUtils.extractAttachmentsFromMultipart(mp, nmsg);
                log.debug((Object)("Attachments found: " + nmsg.getAttachmentNames().size()));
            }
            catch (Exception e) {
                log.error((Object)("Error extracting attachments from message " + mailMsg), (Throwable)e);
            }
        }
    }
}

