/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.processor.DeadLetterChannel;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.LogFactory;

public class DeadLetterChannelBuilder
extends DefaultErrorHandlerBuilder {
    public DeadLetterChannelBuilder() {
    }

    public DeadLetterChannelBuilder(Endpoint deadLetter) {
        this.setDeadLetter(deadLetter);
    }

    public DeadLetterChannelBuilder(String uri) {
        this.setDeadLetterUri(uri);
    }

    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        this.validateDeadLetterUri(routeContext);
        DeadLetterChannel answer = new DeadLetterChannel(routeContext.getCamelContext(), processor, this.getLogger(), this.getOnRedelivery(), this.getRedeliveryPolicy(), this.getHandledPolicy(), this.getExceptionPolicyStrategy(), this.getFailureProcessor(), this.getDeadLetterUri(), this.isUseOriginalMessage(), this.getRetryWhilePolicy(routeContext.getCamelContext()));
        this.configure(answer);
        return answer;
    }

    public boolean supportTransacted() {
        return false;
    }

    public Processor getFailureProcessor() {
        if (this.failureProcessor == null) {
            this.failureProcessor = new SendProcessor(this.deadLetter, ExchangePattern.InOnly);
        }
        return this.failureProcessor;
    }

    protected void validateDeadLetterUri(RouteContext routeContext) {
        if (this.deadLetter == null) {
            ObjectHelper.notEmpty(this.deadLetterUri, "deadLetterUri", this);
            this.deadLetter = routeContext.getCamelContext().getEndpoint(this.deadLetterUri);
            if (this.deadLetter == null) {
                throw new NoSuchEndpointException(this.deadLetterUri);
            }
        }
    }

    protected Predicate createHandledPolicy() {
        return PredicateBuilder.toPredicate(ExpressionBuilder.constantExpression(true));
    }

    protected RedeliveryPolicy createRedeliveryPolicy() {
        return new RedeliveryPolicy();
    }

    protected Logger createLogger() {
        return new Logger(LogFactory.getLog(DeadLetterChannel.class), LoggingLevel.ERROR);
    }

    public String toString() {
        return "DeadLetterChannelBuilder(" + this.deadLetterUri + ")";
    }
}

