/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.log.LogEndpoint;
import org.apache.camel.component.log.LogFormatter;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.ThroughputLogger;
import org.apache.camel.util.IntrospectionSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogComponent
extends DefaultComponent {
    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Logger logger;
        LoggingLevel level = this.getLoggingLevel(parameters);
        Integer groupSize = this.getAndRemoveParameter(parameters, "groupSize", Integer.class);
        Long groupInterval = this.getAndRemoveParameter(parameters, "groupInterval", Long.class);
        if (groupSize != null) {
            logger = new ThroughputLogger(remaining, level, groupSize);
        } else if (groupInterval != null) {
            Boolean groupActiveOnly = this.getAndRemoveParameter(parameters, "groupActiveOnly", Boolean.class, Boolean.TRUE);
            Long groupDelay = this.getAndRemoveParameter(parameters, "groupDelay", Long.class);
            logger = new ThroughputLogger(this.getCamelContext(), remaining, level, groupInterval, groupDelay, groupActiveOnly);
        } else {
            LogFormatter formatter = new LogFormatter();
            IntrospectionSupport.setProperties(formatter, parameters);
            logger = new Logger(remaining);
            logger.setLevel(level);
            logger.setFormatter(formatter);
        }
        LogEndpoint endpoint = new LogEndpoint(uri, this);
        this.setProperties(endpoint, parameters);
        return new LogEndpoint(uri, (Component)this, logger);
    }

    protected LoggingLevel getLoggingLevel(Map<String, Object> parameters) {
        String levelText = this.getAndRemoveParameter(parameters, "level", String.class, "INFO");
        return LoggingLevel.valueOf(levelText.toUpperCase());
    }
}

