/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptSendToEndpoint
implements Endpoint {
    private static final transient Log LOG = LogFactory.getLog(InterceptSendToEndpoint.class);
    private final Endpoint delegate;
    private Producer producer;
    private Processor detour;
    private boolean skip;

    public InterceptSendToEndpoint(Endpoint destination, boolean skip) {
        this.delegate = destination;
        this.skip = skip;
    }

    public void setDetour(Processor detour) {
        this.detour = detour;
    }

    public Endpoint getDelegate() {
        return this.delegate;
    }

    @Override
    public String getEndpointUri() {
        return this.delegate.getEndpointUri();
    }

    @Override
    public String getEndpointKey() {
        return this.delegate.getEndpointKey();
    }

    @Override
    public Exchange createExchange() {
        return this.delegate.createExchange();
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        return this.delegate.createExchange(pattern);
    }

    @Override
    public Exchange createExchange(Exchange exchange) {
        return this.delegate.createExchange(exchange);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.delegate.getCamelContext();
    }

    @Override
    public Producer createProducer() throws Exception {
        this.producer = this.delegate.createProducer();
        return new Producer(){

            public Endpoint getEndpoint() {
                return InterceptSendToEndpoint.this.producer.getEndpoint();
            }

            public Exchange createExchange() {
                return InterceptSendToEndpoint.this.producer.createExchange();
            }

            public Exchange createExchange(ExchangePattern pattern) {
                return InterceptSendToEndpoint.this.producer.createExchange(pattern);
            }

            public Exchange createExchange(Exchange exchange) {
                return InterceptSendToEndpoint.this.producer.createExchange(exchange);
            }

            public void process(Exchange exchange) throws Exception {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Sending to endpoint: " + InterceptSendToEndpoint.this.getEndpointUri() + " is intercepted and detoured to: " + InterceptSendToEndpoint.this.detour + " for exchange: " + exchange));
                }
                exchange.getIn().setHeader("CamelInterceptedEndpoint", InterceptSendToEndpoint.this.delegate.getEndpointUri());
                try {
                    InterceptSendToEndpoint.this.detour.process(exchange);
                }
                catch (Exception e) {
                    exchange.setException(e);
                }
                if (!PipelineHelper.continueProcessing(exchange, "skip sending to original intended destination: " + InterceptSendToEndpoint.this.getEndpointUri(), LOG)) {
                    return;
                }
                if (!InterceptSendToEndpoint.this.skip) {
                    if (exchange.hasOut()) {
                        exchange.setIn(exchange.getOut());
                        exchange.setOut(null);
                    }
                    InterceptSendToEndpoint.this.producer.process(exchange);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Stop() means skip sending exchange to original intended destination: " + InterceptSendToEndpoint.this.getEndpointUri() + " for exchange: " + exchange));
                }
            }

            public boolean isSingleton() {
                return InterceptSendToEndpoint.this.producer.isSingleton();
            }

            public void start() throws Exception {
                ServiceHelper.startService(InterceptSendToEndpoint.this.detour);
            }

            public void stop() throws Exception {
            }
        };
    }

    private static boolean hasExceptionBeenHandledByErrorHandler(Exchange nextExchange) {
        return Boolean.TRUE.equals(nextExchange.getProperty("CamelErrorHandlerHandled"));
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return this.delegate.createConsumer(processor);
    }

    @Override
    public PollingConsumer createPollingConsumer() throws Exception {
        return this.delegate.createPollingConsumer();
    }

    @Override
    public void configureProperties(Map<String, Object> options) {
        this.delegate.configureProperties(options);
    }

    @Override
    public void setCamelContext(CamelContext context) {
        this.delegate.setCamelContext(context);
    }

    @Override
    public boolean isLenientProperties() {
        return this.delegate.isLenientProperties();
    }

    @Override
    public boolean isSingleton() {
        return this.delegate.isSingleton();
    }

    @Override
    public void start() throws Exception {
        ServiceHelper.startServices(this.detour, this.delegate);
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopServices(this.delegate, this.detour);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

