/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ShutdownableService;
import org.apache.camel.util.ServiceHelper;

public abstract class ServiceSupport
implements Service,
ShutdownableService {
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean starting = new AtomicBoolean(false);
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final AtomicBoolean suspending = new AtomicBoolean(false);
    private final AtomicBoolean suspended = new AtomicBoolean(false);
    private final AtomicBoolean shuttingdown = new AtomicBoolean(false);
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private Set<Object> childServices;
    private String version;

    public void start() throws Exception {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void start(boolean startChildren) throws Exception {
        block14: {
            if (!this.started.get() && this.starting.compareAndSet(false, true)) {
                Exception ex;
                boolean childrenStarted;
                block12: {
                    childrenStarted = false;
                    ex = null;
                    if (this.childServices != null && startChildren) {
                        ServiceHelper.startServices(this.childServices);
                    }
                    childrenStarted = true;
                    this.doStart();
                    Object var6_4 = null;
                    if (ex == null) break block12;
                    try {
                        this.stop(childrenStarted);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw ex;
                }
                this.started.set(true);
                this.starting.set(false);
                this.stopping.set(false);
                this.stopped.set(false);
                this.suspending.set(false);
                this.suspended.set(false);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
                {
                    break block14;
                    catch (Exception e) {
                        ex = e;
                        Object var6_5 = null;
                        if (ex != null) {
                            try {
                                this.stop(childrenStarted);
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            throw ex;
                        }
                        this.started.set(true);
                        this.starting.set(false);
                        this.stopping.set(false);
                        this.stopped.set(false);
                        this.suspending.set(false);
                        this.suspended.set(false);
                        this.shutdown.set(false);
                        this.shuttingdown.set(false);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (ex != null) {
                        try {
                            this.stop(childrenStarted);
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        throw ex;
                    }
                    this.started.set(true);
                    this.starting.set(false);
                    this.stopping.set(false);
                    this.stopped.set(false);
                    this.suspending.set(false);
                    this.suspended.set(false);
                    this.shutdown.set(false);
                    this.shuttingdown.set(false);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stop(boolean childrenStarted) throws Exception {
        if (!this.stopping.compareAndSet(false, true)) return;
        try {
            block5: {
                try {
                    this.starting.set(false);
                    this.suspending.set(false);
                    if (childrenStarted) {
                        this.doStop();
                    }
                    Object var3_2 = null;
                    this.started.set(false);
                    this.suspended.set(false);
                    if (this.childServices == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.started.set(false);
                    this.suspended.set(false);
                    if (this.childServices == null) throw throwable;
                    ServiceHelper.stopServices(this.childServices);
                    throw throwable;
                }
                ServiceHelper.stopServices(this.childServices);
            }
            Object var5_5 = null;
            this.stopped.set(true);
            this.stopping.set(false);
            this.starting.set(false);
            this.started.set(false);
            this.suspending.set(false);
            this.suspended.set(false);
            this.shutdown.set(false);
            this.shuttingdown.set(false);
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.stopped.set(true);
            this.stopping.set(false);
            this.starting.set(false);
            this.started.set(false);
            this.suspending.set(false);
            this.suspended.set(false);
            this.shutdown.set(false);
            this.shuttingdown.set(false);
            throw throwable;
        }
    }

    public void stop() throws Exception {
        if (!this.stopped.get()) {
            this.stop(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws Exception {
        if (!this.suspended.get() && this.suspending.compareAndSet(false, true)) {
            try {
                this.starting.set(false);
                this.stopping.set(false);
                this.doSuspend();
                Object var2_1 = null;
                this.stopped.set(false);
                this.stopping.set(false);
                this.starting.set(false);
                this.started.set(false);
                this.suspending.set(false);
                this.suspended.set(true);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.stopped.set(false);
                this.stopping.set(false);
                this.starting.set(false);
                this.started.set(false);
                this.suspending.set(false);
                this.suspended.set(true);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws Exception {
        if (this.suspended.get() && this.starting.compareAndSet(false, true)) {
            try {
                this.doResume();
                Object var2_1 = null;
                this.started.set(true);
                this.starting.set(false);
                this.stopping.set(false);
                this.stopped.set(false);
                this.suspending.set(false);
                this.suspended.set(false);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.started.set(true);
                this.starting.set(false);
                this.stopping.set(false);
                this.stopped.set(false);
                this.suspending.set(false);
                this.suspended.set(false);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() throws Exception {
        this.stop();
        if (!this.shuttingdown.compareAndSet(false, true)) return;
        try {
            block4: {
                try {
                    this.doShutdown();
                    Object var2_1 = null;
                    if (this.childServices == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    if (this.childServices == null) throw throwable;
                    ServiceHelper.stopAndShutdownService(this.childServices);
                    throw throwable;
                }
                ServiceHelper.stopAndShutdownService(this.childServices);
            }
            Object var4_4 = null;
            this.shutdown.set(true);
            this.shuttingdown.set(false);
            return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.shutdown.set(true);
            this.shuttingdown.set(false);
            throw throwable;
        }
    }

    public ServiceStatus getStatus() {
        if (this.isStarting()) {
            return ServiceStatus.Starting;
        }
        if (this.isStarted()) {
            return ServiceStatus.Started;
        }
        if (this.isStopping()) {
            return ServiceStatus.Stopping;
        }
        if (this.isStopped()) {
            return ServiceStatus.Stopped;
        }
        if (this.isSuspending()) {
            return ServiceStatus.Suspending;
        }
        if (this.isSuspended()) {
            return ServiceStatus.Suspended;
        }
        return ServiceStatus.Stopped;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isStarting() {
        return this.starting.get();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public boolean isSuspending() {
        return this.suspending.get();
    }

    public boolean isSuspended() {
        return this.suspended.get();
    }

    public boolean isRunAllowed() {
        return !this.stopping.get() && !this.stopped.get();
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doStop() throws Exception;

    protected void doSuspend() throws Exception {
    }

    protected void doResume() throws Exception {
    }

    protected void doShutdown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildService(Object childService) {
        ServiceSupport serviceSupport = this;
        synchronized (serviceSupport) {
            if (this.childServices == null) {
                this.childServices = new LinkedHashSet<Object>();
            }
        }
        this.childServices.add(childService);
    }

    protected boolean removeChildService(Object childService) {
        return this.childServices != null && this.childServices.remove(childService);
    }

    public synchronized String getVersion() {
        Package aPackage;
        if (this.version != null) {
            return this.version;
        }
        try {
            Properties p = new Properties();
            InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/org.apache.camel/camel-core/pom.properties");
            if (is != null) {
                p.load(is);
                this.version = p.getProperty("version", "");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.version == null && (aPackage = this.getClass().getPackage()) != null) {
            this.version = aPackage.getImplementationVersion();
            if (this.version == null) {
                this.version = aPackage.getSpecificationVersion();
            }
        }
        if (this.version == null) {
            this.version = "";
        }
        return this.version;
    }
}

