/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.management.DelegatePerformanceCounter;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstrumentationProcessor
extends DelegateAsyncProcessor {
    private static final transient Log LOG = LogFactory.getLog(InstrumentationProcessor.class);
    private PerformanceCounter counter;
    private String type;

    public InstrumentationProcessor() {
    }

    public InstrumentationProcessor(PerformanceCounter counter) {
        this.counter = counter;
    }

    public String toString() {
        return "Instrumentation" + (this.type != null ? ":" + this.type : "") + "[" + this.processor + "]";
    }

    public void setCounter(ManagedPerformanceCounter counter) {
        if (this.counter instanceof DelegatePerformanceCounter) {
            ((DelegatePerformanceCounter)this.counter).setCounter(counter);
        } else {
            this.counter = counter;
        }
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final StopWatch watch = this.counter != null && this.counter.isStatisticsEnabled() ? new StopWatch() : null;
        return super.process(exchange, new AsyncCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(boolean doneSync) {
                try {
                    if (watch != null) {
                        InstrumentationProcessor.this.recordTime(exchange, watch.stop());
                    }
                    Object var3_2 = null;
                    callback.done(doneSync);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    callback.done(doneSync);
                    throw throwable;
                }
            }
        });
    }

    protected void recordTime(Exchange exchange, long duration) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)((this.type != null ? this.type + ": " : "") + "Recording duration: " + duration + " millis for exchange: " + exchange));
        }
        if (!exchange.isFailed() && exchange.getException() == null) {
            this.counter.completedExchange(duration);
        } else {
            this.counter.failedExchange();
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

