/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.processor.OnCompletionProcessor;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="onCompletion")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OnCompletionDefinition
extends ProcessorDefinition<OnCompletionDefinition>
implements ExecutorServiceAwareDefinition<OnCompletionDefinition> {
    @XmlAttribute(required=false)
    private Boolean onCompleteOnly;
    @XmlAttribute(required=false)
    private Boolean onFailureOnly;
    @XmlElement(name="onWhen", required=false)
    private WhenDefinition onWhen;
    @XmlElementRef
    private List<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute(required=false)
    private String executorServiceRef;
    @XmlAttribute(name="useOriginalMessage", required=false)
    private Boolean useOriginalMessagePolicy;

    public String toString() {
        return "onCompletion[" + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "onCompletion";
    }

    @Override
    public String getLabel() {
        return "onCompletion";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (this.isOnCompleteOnly() && this.isOnFailureOnly()) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + this);
        }
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        childProcessor = new UnitOfWorkProcessor(routeContext, childProcessor);
        Predicate when = null;
        if (this.onWhen != null) {
            when = this.onWhen.getExpression().createPredicate(routeContext);
        }
        this.executorService = ExecutorServiceHelper.getConfiguredExecutorService(routeContext, "OnCompletion", this);
        if (this.executorService == null) {
            this.executorService = routeContext.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool(this, "OnCompletion");
        }
        boolean original = this.getUseOriginalMessagePolicy() != null ? this.getUseOriginalMessagePolicy() : false;
        OnCompletionProcessor answer = new OnCompletionProcessor(routeContext.getCamelContext(), childProcessor, this.executorService, this.isOnCompleteOnly(), this.isOnFailureOnly(), when, original);
        return answer;
    }

    public void removeAllOnCompletionDefinition(ProcessorDefinition definition) {
        Iterator<ProcessorDefinition> it = definition.getOutputs().iterator();
        while (it.hasNext()) {
            ProcessorDefinition out = it.next();
            if (!(out instanceof OnCompletionDefinition)) continue;
            it.remove();
        }
    }

    @Override
    public ProcessorDefinition end() {
        this.getParent().popBlock();
        return super.end();
    }

    public OnCompletionDefinition onCompleteOnly() {
        if (this.isOnFailureOnly()) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + this);
        }
        this.setOnCompleteOnly(Boolean.TRUE);
        this.setOnFailureOnly(Boolean.FALSE);
        return this;
    }

    public OnCompletionDefinition onFailureOnly() {
        if (this.isOnCompleteOnly()) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + this);
        }
        this.setOnCompleteOnly(Boolean.FALSE);
        this.setOnFailureOnly(Boolean.TRUE);
        return this;
    }

    public OnCompletionDefinition onWhen(Predicate predicate) {
        this.setOnWhen(new WhenDefinition(predicate));
        return this;
    }

    public ExpressionClause<OnCompletionDefinition> onWhen() {
        this.onWhen = new WhenDefinition();
        ExpressionClause<OnCompletionDefinition> clause = new ExpressionClause<OnCompletionDefinition>(this);
        this.onWhen.setExpression(clause);
        return clause;
    }

    public OnCompletionDefinition useOriginalBody() {
        this.setUseOriginalMessagePolicy(Boolean.TRUE);
        return this;
    }

    @Override
    public OnCompletionDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public OnCompletionDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition> outputs) {
        this.outputs = outputs;
    }

    public Boolean getOnCompleteOnly() {
        return this.onCompleteOnly;
    }

    public void setOnCompleteOnly(Boolean onCompleteOnly) {
        this.onCompleteOnly = onCompleteOnly;
    }

    public boolean isOnCompleteOnly() {
        return this.onCompleteOnly != null && this.onCompleteOnly != false;
    }

    public Boolean getOnFailureOnly() {
        return this.onFailureOnly;
    }

    public void setOnFailureOnly(Boolean onFailureOnly) {
        this.onFailureOnly = onFailureOnly;
    }

    public boolean isOnFailureOnly() {
        return this.onFailureOnly != null && this.onFailureOnly != false;
    }

    public WhenDefinition getOnWhen() {
        return this.onWhen;
    }

    public void setOnWhen(WhenDefinition onWhen) {
        this.onWhen = onWhen;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Boolean getUseOriginalMessagePolicy() {
        return this.useOriginalMessagePolicy != null;
    }

    public void setUseOriginalMessagePolicy(Boolean useOriginalMessagePolicy) {
        this.useOriginalMessagePolicy = useOriginalMessagePolicy;
    }
}

