/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ProcessorBuilder;
import org.apache.camel.model.NoOutputExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Required;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="setProperty")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SetPropertyDefinition
extends NoOutputExpressionNode {
    @XmlAttribute(required=true)
    private String propertyName;

    public SetPropertyDefinition() {
    }

    public SetPropertyDefinition(String propertyName, ExpressionDefinition expression) {
        super(expression);
        this.setPropertyName(propertyName);
    }

    public SetPropertyDefinition(String propertyName, Expression expression) {
        super(expression);
        this.setPropertyName(propertyName);
    }

    public SetPropertyDefinition(String propertyName, String value) {
        super(ExpressionBuilder.constantExpression(value));
        this.setPropertyName(propertyName);
    }

    public String toString() {
        return "SetProperty[" + this.getPropertyName() + ", " + this.getExpression() + "]";
    }

    public String getShortName() {
        return "setProperty";
    }

    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ObjectHelper.notNull(this.getPropertyName(), "propertyName", this);
        Expression expr = this.getExpression().createExpression(routeContext);
        return ProcessorBuilder.setProperty(this.getPropertyName(), expr);
    }

    @Required
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

