/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.loadbalancer;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedLoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedRandomLoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedRoundRobinLoadBalancer;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="weighted")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WeightedLoadBalancerDefinition
extends LoadBalancerDefinition {
    @XmlAttribute
    private Boolean roundRobin;
    @XmlAttribute(required=true)
    private String distributionRatio;
    @XmlAttribute
    private String distributionRatioDelimiter;

    protected LoadBalancer createLoadBalancer(RouteContext routeContext) {
        WeightedLoadBalancer loadBalancer;
        ArrayList<Integer> distributionRatioList = new ArrayList<Integer>();
        try {
            String[] ratios;
            if (this.distributionRatioDelimiter == null) {
                this.distributionRatioDelimiter = ",";
            }
            for (String ratio : ratios = this.distributionRatio.split(this.distributionRatioDelimiter)) {
                distributionRatioList.add(new Integer(ratio.trim()));
            }
            loadBalancer = !this.isRoundRobin() ? new WeightedRandomLoadBalancer(distributionRatioList) : new WeightedRoundRobinLoadBalancer(distributionRatioList);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return loadBalancer;
    }

    public Boolean getRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(Boolean roundRobin) {
        this.roundRobin = roundRobin;
    }

    public boolean isRoundRobin() {
        return this.roundRobin != null && this.roundRobin != false;
    }

    public String getDistributionRatio() {
        return this.distributionRatio;
    }

    public void setDistributionRatioList(String distributionRatio) {
        this.distributionRatio = distributionRatio;
    }

    public String toString() {
        if (!this.isRoundRobin()) {
            return "WeightedRandomLoadBalancer[" + this.distributionRatio + "]";
        }
        return "WeightedRoundRobinLoadBalancer[" + this.distributionRatio + "]";
    }
}

