/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.SynchronizationAdapter;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.spi.RoutePolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutePolicyProcessor
extends DelegateAsyncProcessor {
    private static final Log LOG = LogFactory.getLog(RoutePolicyProcessor.class);
    private final List<RoutePolicy> routePolicies;
    private Route route;

    public RoutePolicyProcessor(Processor processor, List<RoutePolicy> routePolicies) {
        super(processor);
        this.routePolicies = routePolicies;
    }

    @Override
    public String toString() {
        return "RoutePolicy[" + this.routePolicies + "]";
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        for (RoutePolicy policy : this.routePolicies) {
            try {
                if (!this.isRoutePolicyRunAllowed(policy)) continue;
                policy.onExchangeBegin(this.route, exchange);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error occurred during onExchangeBegin on RoutePolicy: " + policy + ". This exception will be ignored"), (Throwable)e);
            }
        }
        exchange.addOnCompletion(new SynchronizationAdapter(){

            public void onDone(Exchange exchange) {
                if (RoutePolicyProcessor.isCamelStopping(exchange.getContext())) {
                    return;
                }
                for (RoutePolicy policy : RoutePolicyProcessor.this.routePolicies) {
                    try {
                        if (!RoutePolicyProcessor.this.isRoutePolicyRunAllowed(policy)) continue;
                        policy.onExchangeDone(RoutePolicyProcessor.this.route, exchange);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error occurred during onExchangeDone on RoutePolicy: " + policy + ". This exception will be ignored"), (Throwable)e);
                    }
                }
            }

            public String toString() {
                return "RoutePolicyOnCompletion";
            }
        });
        return super.process(exchange, callback);
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    protected boolean isRoutePolicyRunAllowed(RoutePolicy policy) {
        if (policy instanceof ServiceSupport) {
            ServiceSupport ss = (ServiceSupport)((Object)policy);
            return ss.isRunAllowed();
        }
        return true;
    }

    private static boolean isCamelStopping(CamelContext context) {
        if (context instanceof ServiceSupport) {
            ServiceSupport ss = (ServiceSupport)((Object)context);
            return ss.isStopping() || ss.isStopped();
        }
        return false;
    }
}

