/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.camel.Service;
import org.apache.camel.ShutdownableService;
import org.apache.camel.SuspendableService;
import org.apache.camel.impl.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceHelper {
    private static final transient Log LOG = LogFactory.getLog(ServiceHelper.class);

    private ServiceHelper() {
    }

    public static void startService(Object value) throws Exception {
        if (ServiceHelper.isStarted(value)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Service already started: " + value));
            }
            return;
        }
        if (value instanceof Service) {
            Service service = (Service)value;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Starting service: " + service));
            }
            service.start();
        } else if (value instanceof Collection) {
            ServiceHelper.startServices((Collection)value);
        }
    }

    public static void startServices(Object ... services) throws Exception {
        if (services == null) {
            return;
        }
        for (Object value : services) {
            ServiceHelper.startService(value);
        }
    }

    public static void startServices(Collection<?> services) throws Exception {
        if (services == null) {
            return;
        }
        for (Object value : services) {
            ServiceHelper.startService(value);
        }
    }

    public static void stopServices(Object ... services) throws Exception {
        if (services == null) {
            return;
        }
        List<Object> list = Arrays.asList(services);
        ServiceHelper.stopServices(list);
    }

    public static void stopService(Object value) throws Exception {
        if (ServiceHelper.isStopped(value)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Service already stopped: " + value));
            }
            return;
        }
        if (value instanceof Service) {
            Service service = (Service)value;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Stopping service " + value));
            }
            service.stop();
        } else if (value instanceof Collection) {
            ServiceHelper.stopServices((Collection)value);
        }
    }

    public static void stopServices(Collection<?> services) throws Exception {
        if (services == null) {
            return;
        }
        Exception firstException = null;
        for (Object value : services) {
            try {
                ServiceHelper.stopService(value);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Caught exception stopping service: " + value), (Throwable)e);
                }
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static void stopAndShutdownServices(Object ... services) throws Exception {
        if (services == null) {
            return;
        }
        List<Object> list = Arrays.asList(services);
        ServiceHelper.stopAndShutdownServices(list);
    }

    public static void stopAndShutdownService(Object value) throws Exception {
        if (value instanceof Service) {
            ServiceHelper.stopService(value);
        }
        if (value instanceof ShutdownableService) {
            ShutdownableService service = (ShutdownableService)value;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Shutting down service " + value));
            }
            service.shutdown();
        } else if (value instanceof Collection) {
            ServiceHelper.stopAndShutdownServices((Collection)value);
        }
    }

    public static void stopAndShutdownServices(Collection<?> services) throws Exception {
        if (services == null) {
            return;
        }
        Exception firstException = null;
        for (Object value : services) {
            ServiceHelper.stopService(value);
            if (!(value instanceof ShutdownableService)) continue;
            ShutdownableService service = (ShutdownableService)value;
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Shutting down service: " + service));
                }
                service.shutdown();
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Caught exception shutting down service: " + service), (Throwable)e);
                }
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static void resumeServices(Collection<?> services) throws Exception {
        if (services == null) {
            return;
        }
        Exception firstException = null;
        for (Object value : services) {
            if (!(value instanceof Service)) continue;
            Service service = (Service)value;
            try {
                ServiceHelper.resumeService(service);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Caught exception resuming service: " + service), (Throwable)e);
                }
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static boolean resumeService(Object service) throws Exception {
        if (service instanceof SuspendableService) {
            SuspendableService ss = (SuspendableService)service;
            if (ss.isSuspended()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Resuming service " + service));
                }
                ss.resume();
                return true;
            }
            return false;
        }
        ServiceHelper.startService(service);
        return true;
    }

    public static void suspendServices(Collection<?> services) throws Exception {
        if (services == null) {
            return;
        }
        Exception firstException = null;
        for (Object value : services) {
            if (!(value instanceof Service)) continue;
            Service service = (Service)value;
            try {
                ServiceHelper.suspendService(service);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Caught exception suspending service: " + service), (Throwable)e);
                }
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static boolean suspendService(Service service) throws Exception {
        if (service instanceof SuspendableService) {
            SuspendableService ss = (SuspendableService)service;
            if (!ss.isSuspended()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Suspending service " + service));
                }
                ss.suspend();
                return true;
            }
            return false;
        }
        ServiceHelper.stopService(service);
        return true;
    }

    public static boolean isStopped(Object value) {
        ServiceSupport service;
        return value instanceof ServiceSupport && ((service = (ServiceSupport)value).isStopping() || service.isStopped());
    }

    public static boolean isStarted(Object value) {
        ServiceSupport service;
        return value instanceof ServiceSupport && ((service = (ServiceSupport)value).isStarting() || service.isStarted());
    }
}

