/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.PollingEndpoint;
import org.apache.servicemix.common.locks.LockManager;
import org.apache.servicemix.common.locks.impl.SimpleLockManager;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.executors.ExecutorAwareRunnable;
import org.apache.servicemix.vfs.FileObjectResolver;
import org.apache.servicemix.vfs.VFSEndpointType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSPollingEndpoint
extends PollingEndpoint
implements VFSEndpointType {
    private static final Log logger = LogFactory.getLog(VFSPollingEndpoint.class);
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private FileObject file;
    private FileSelector selector;
    private Set<FileObject> workingSet = new CopyOnWriteArraySet<FileObject>();
    private boolean deleteFile = true;
    private boolean recursive = true;
    private String path;
    private Comparator<FileObject> comparator = null;
    private FileSystemManager fileSystemManager;
    private LockManager lockManager;
    private ConcurrentMap<String, InputStream> openExchanges = new ConcurrentHashMap<String, InputStream>();
    private boolean concurrentExchange = true;

    public VFSPollingEndpoint() {
    }

    public VFSPollingEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public VFSPollingEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public synchronized void start() throws Exception {
        super.start();
        this.workingSet.clear();
        this.openExchanges = new ConcurrentHashMap<String, InputStream>();
        if (this.lockManager == null) {
            this.lockManager = this.createLockManager();
        }
    }

    protected LockManager createLockManager() {
        return new SimpleLockManager();
    }

    public String getLocationURI() {
        return this.getService() + "#" + this.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(MessageExchange exchange) throws Exception {
        if (this.openExchanges.containsKey(exchange.getExchangeId())) {
            InputStream stream = (InputStream)this.openExchanges.get(exchange.getExchangeId());
            FileObject aFile = (FileObject)exchange.getMessage("in").getProperty("org.apache.servicemix.vfs");
            if (aFile == null) {
                throw new JBIException("Property org.apache.servicemix.vfs was removed from the exchange -- unable to delete/archive the file");
            }
            logger.debug((Object)("Releasing " + aFile.getName().getPathDecoded()));
            try {
                stream.close();
            }
            catch (IOException ex) {
                logger.error((Object)("Unable to close stream for file " + aFile.getName().getPathDecoded()), (Throwable)ex);
            }
            try {
                if (exchange.getStatus() == ExchangeStatus.DONE) {
                    if (!this.isDeleteFile() || aFile.delete()) return;
                    throw new IOException("Could not delete file " + aFile.getName().getPathDecoded());
                }
                if (exchange.getStatus() != ExchangeStatus.ERROR) throw new JBIException("Unexpectedly received an exchange with status ACTIVE");
                Exception e = exchange.getError();
                if (e == null) {
                    throw new JBIException("Received an exchange with status ERROR, but no exception was set");
                }
                logger.warn((Object)("Message in file " + aFile.getName().getPathDecoded() + " could not be handled successfully: " + e.getMessage()), (Throwable)e);
                return;
            }
            finally {
                this.workingSet.remove(aFile);
                this.openExchanges.remove(exchange.getExchangeId());
                this.unlockAsyncFile(aFile);
            }
        }
        logger.debug((Object)"Received unknown exchange. Will be ignored...");
    }

    private void unlockAsyncFile(FileObject file) {
        String uri = file.getName().getURI().toString();
        Lock lock = this.lockManager.getLock(uri);
        if (lock != null) {
            try {
                lock.unlock();
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    public void poll() throws Exception {
        if (this.file == null) {
            try {
                this.file = FileObjectResolver.resolveToFileObject(this.getFileSystemManager(), this.getPath());
            }
            catch (Exception e) {
                logger.debug((Object)("Unable to resolve path: " + this.getPath()), (Throwable)e);
                this.file = null;
            }
        }
        if (this.file != null) {
            this.file.close();
            this.pollFileOrDirectory(this.file);
        }
    }

    protected void pollFileOrDirectory(FileObject fileOrDirectory) throws Exception {
        this.pollFileOrDirectory(fileOrDirectory, true);
    }

    protected void pollFileOrDirectory(FileObject fileOrDirectory, boolean processDir) throws Exception {
        if (fileOrDirectory.getType().equals(FileType.FILE)) {
            this.pollFile(fileOrDirectory);
        } else if (processDir) {
            logger.debug((Object)("Polling directory " + fileOrDirectory.getName().getPathDecoded()));
            FileObject[] files = null;
            files = this.selector != null ? this.sortPolledFiles(fileOrDirectory.findFiles(this.selector)) : this.sortPolledFiles(fileOrDirectory.getChildren());
            for (FileObject f : files) {
                this.pollFileOrDirectory(f, this.isRecursive());
            }
        } else {
            logger.debug((Object)("Skipping directory " + fileOrDirectory.getName().getPathDecoded()));
        }
    }

    private FileObject[] sortPolledFiles(FileObject[] files) {
        if (this.comparator == null) {
            return files;
        }
        Arrays.sort(files, this.comparator);
        return files;
    }

    protected void pollFile(final FileObject aFile) throws Exception {
        if (!this.isFullyAvailable(aFile)) {
            return;
        }
        if (this.workingSet.add(aFile)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Scheduling file " + aFile.getName().getPathDecoded() + " for processing"));
            }
            this.getExecutor().execute((Runnable)new ExecutorAwareRunnable(){

                public void run() {
                    String uri = aFile.getName().getURI().toString();
                    Lock lock = VFSPollingEndpoint.this.lockManager.getLock(uri);
                    if (lock.tryLock()) {
                        VFSPollingEndpoint.this.processFileNow(aFile);
                    } else {
                        VFSPollingEndpoint.this.workingSet.remove(aFile);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Unable to acquire lock on " + aFile.getName().getURI()));
                        }
                    }
                }

                public boolean shouldRunSynchronously() {
                    return !VFSPollingEndpoint.this.isConcurrentExchange();
                }
            });
        }
    }

    protected void processFileNow(FileObject aFile) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Processing file " + aFile.getName().getURI()));
            }
            if (aFile.exists()) {
                this.processFile(aFile);
            }
        }
        catch (Exception e) {
            this.workingSet.remove(aFile);
            this.unlockAsyncFile(aFile);
            logger.error((Object)("Failed to process file: " + aFile.getName().getURI() + ". Reason: " + e), (Throwable)e);
        }
    }

    protected void processFile(FileObject file) throws Exception {
        file.close();
        String name = file.getName().getURI();
        FileContent content = file.getContent();
        content.close();
        InputStream stream = content.getInputStream();
        if (stream == null) {
            throw new IOException("No input available for file!");
        }
        InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
        this.configureExchangeTarget((MessageExchange)exchange);
        NormalizedMessage message = exchange.createMessage();
        exchange.setInMessage(message);
        this.marshaler.readMessage((MessageExchange)exchange, message, stream, name);
        exchange.getInMessage().setProperty("org.apache.servicemix.vfs", (Object)file);
        this.openExchanges.put(exchange.getExchangeId(), stream);
        if (this.isConcurrentExchange()) {
            this.send((MessageExchange)exchange);
        } else {
            this.sendSync((MessageExchange)exchange);
            this.process((MessageExchange)exchange);
        }
    }

    private boolean isFullyAvailable(FileObject aFile) {
        block4: {
            try {
                if (aFile.getContent() == null) break block4;
                long size_old = aFile.getContent().getSize();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long size_new = aFile.getContent().getSize();
                return size_old == size_new;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public boolean isDeleteFile() {
        return this.deleteFile;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setComparator(Comparator<FileObject> comparator) {
        this.comparator = comparator;
    }

    public Comparator<FileObject> getComparator() {
        return this.comparator;
    }

    public void setSelector(FileSelector selector) {
        this.selector = selector;
    }

    public FileSelector getSelector() {
        return this.selector;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setFileSystemManager(FileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }

    public FileSystemManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    public Set<FileObject> getWorkingSet() {
        return this.workingSet;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isConcurrentExchange() {
        return this.concurrentExchange;
    }

    public void setConcurrentExchange(boolean concurrentExchange) {
        this.concurrentExchange = concurrentExchange;
    }
}

