/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.endpoints;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.Destination;
import org.apache.servicemix.jms.endpoints.DestinationChooser;

public class SimpleDestinationChooser
implements DestinationChooser {
    public static final String DESTINATION_KEY = "org.apache.servicemix.jms.destination";
    private Destination defaultDestination;
    private String defaultDestinationName;

    public SimpleDestinationChooser() {
    }

    public SimpleDestinationChooser(Destination defaultDestination) {
        this.defaultDestination = defaultDestination;
    }

    public SimpleDestinationChooser(String defaultDestinationName) {
        this.defaultDestinationName = defaultDestinationName;
    }

    public Object chooseDestination(MessageExchange exchange, Object message) {
        Object property = null;
        if (message instanceof NormalizedMessage) {
            property = ((NormalizedMessage)message).getProperty(DESTINATION_KEY);
        }
        if (property instanceof Destination) {
            return (Destination)property;
        }
        if (property instanceof String) {
            return (String)property;
        }
        if (this.getDefaultDestination() != null) {
            return this.getDefaultDestination();
        }
        return this.getDefaultDestinationName();
    }

    public Destination getDefaultDestination() {
        return this.defaultDestination;
    }

    public void setDefaultDestination(Destination defaultDestination) {
        this.defaultDestination = defaultDestination;
    }

    public String getDefaultDestinationName() {
        return this.defaultDestinationName;
    }

    public void setDefaultDestinationName(String defaultDestinationName) {
        this.defaultDestinationName = defaultDestinationName;
    }
}

