/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;

@JRubyModule(name={"Marshal"})
public class RubyMarshal {
    public static RubyModule createMarshalModule(Ruby runtime) {
        RubyModule module = runtime.defineModule("Marshal");
        runtime.setMarshal(module);
        module.defineAnnotatedMethods(RubyMarshal.class);
        module.defineConstant("MAJOR_VERSION", runtime.newFixnum(4));
        module.defineConstant("MINOR_VERSION", runtime.newFixnum(8));
        return module;
    }

    @JRubyMethod(name={"dump"}, required=1, optional=2, frame=true, module=true)
    public static IRubyObject dump(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        if (args.length < 1) {
            throw recv.getRuntime().newArgumentError("wrong # of arguments(at least 1)");
        }
        IRubyObject objectToDump = args[0];
        IRubyObject io = null;
        int depthLimit = -1;
        if (args.length >= 2) {
            if (args[1].respondsTo("write")) {
                io = args[1];
            } else if (args[1] instanceof RubyFixnum) {
                depthLimit = (int)((RubyFixnum)args[1]).getLongValue();
            } else {
                throw recv.getRuntime().newTypeError("Instance of IO needed");
            }
            if (args.length == 3) {
                depthLimit = (int)((RubyFixnum)args[2]).getLongValue();
            }
        }
        try {
            if (io != null) {
                RubyMarshal.dumpToStream(objectToDump, RubyMarshal.outputStream(io), depthLimit);
                return io;
            }
            ByteArrayOutputStream stringOutput = new ByteArrayOutputStream();
            RubyMarshal.dumpToStream(objectToDump, stringOutput, depthLimit);
            return RubyString.newString(recv.getRuntime(), new ByteList(stringOutput.toByteArray(), false));
        }
        catch (IOException ioe) {
            throw recv.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private static OutputStream outputStream(IRubyObject out) {
        RubyMarshal.setBinmodeIfPossible(out);
        if (out instanceof RubyIO) {
            return ((RubyIO)out).getOutStream();
        }
        return new IOOutputStream(out);
    }

    private static void setBinmodeIfPossible(IRubyObject io) {
        if (io.respondsTo("binmode")) {
            io.callMethod(io.getRuntime().getCurrentContext(), "binmode");
        }
    }

    @JRubyMethod(name={"load", "restore"}, required=1, optional=1, frame=true, module=true)
    public static IRubyObject load(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        try {
            InputStream rawInput;
            if (args.length < 1) {
                throw recv.getRuntime().newArgumentError("wrong number of arguments (0 for 1)");
            }
            if (args.length > 2) {
                throw recv.getRuntime().newArgumentError("wrong number of arguments (" + args.length + " for 2)");
            }
            IRubyObject in = null;
            IRubyObject proc = null;
            switch (args.length) {
                case 2: {
                    proc = args[1];
                }
                case 1: {
                    in = args[0];
                }
            }
            if (in != null && in.respondsTo("read")) {
                rawInput = RubyMarshal.inputStream(in);
            } else if (in != null && in.respondsTo("to_str")) {
                RubyString inString = (RubyString)RuntimeHelpers.invoke(context, in, MethodIndex.TO_STR, "to_str", IRubyObject.NULL_ARRAY);
                ByteList bytes = inString.getByteList();
                rawInput = new ByteArrayInputStream(bytes.unsafeBytes(), bytes.begin(), bytes.length());
            } else {
                throw recv.getRuntime().newTypeError("instance of IO needed");
            }
            UnmarshalStream input = new UnmarshalStream(recv.getRuntime(), rawInput, proc);
            return input.unmarshalObject();
        }
        catch (EOFException ee) {
            throw recv.getRuntime().newEOFError();
        }
        catch (IOException ioe) {
            throw recv.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private static InputStream inputStream(IRubyObject in) {
        RubyMarshal.setBinmodeIfPossible(in);
        if (in instanceof RubyIO) {
            return ((RubyIO)in).getInStream();
        }
        return new IOInputStream(in);
    }

    private static void dumpToStream(IRubyObject object, OutputStream rawOutput, int depthLimit) throws IOException {
        MarshalStream output = new MarshalStream(object.getRuntime(), rawOutput, depthLimit);
        output.dumpObject(object);
    }
}

