/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinedNode
extends Node {
    private final Node expressionNode;

    public DefinedNode(ISourcePosition position, Node expressionNode) {
        super(position, NodeType.DEFINEDNODE);
        assert (expressionNode != null) : "expressionNode is not null";
        this.expressionNode = expressionNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDefinedNode(this);
    }

    public Node getExpressionNode() {
        return this.expressionNode;
    }

    @Override
    public List<Node> childNodes() {
        return DefinedNode.createList(this.expressionNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        String definition = ASTInterpreter.getDefinition(runtime, context, this.expressionNode, self, aBlock);
        if (definition != null) {
            return runtime.newString(definition);
        }
        return runtime.getNil();
    }
}

